/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.tools.geoip;

import com.mohistmc.tools.geoip.GeoIP;
import com.mohistmc.tools.geoip.GeoIPException;
import com.mohistmc.tools.geoip.internal.IpAddressMatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class GeoIPResidentImpl
implements GeoIP {
    @Override
    public Optional<String> getTwoLetterCountryCode(InetAddress inetAddress) {
        return this.getTwoLetterCountryCode(inetAddress.getHostAddress());
    }

    @Override
    public Optional<String> getTwoLetterCountryCode(String ipAddress) {
        return MapHolder.getCidrNotationsToCountryIsoCodeMap().entrySet().parallelStream().filter(e -> ((IpAddressMatcher)e.getKey()).matches(ipAddress)).map(Map.Entry::getValue).filter(e -> !e.isEmpty()).findFirst();
    }

    @Override
    public Optional<String> getCountryName(InetAddress inetAddress) {
        return this.getCountryName(inetAddress.getHostAddress());
    }

    @Override
    public Optional<String> getCountryName(String ipAddress) {
        Optional<String> optionalTwoLetterCountryCode = this.getTwoLetterCountryCode(ipAddress);
        if (optionalTwoLetterCountryCode.isPresent()) {
            String twoLetterCountryCode = optionalTwoLetterCountryCode.get();
            Map<String, String> countryIsoCodeToCountryNameMap = MapHolder.getCountryIsoCodeToCountryNameMap();
            String countryName = countryIsoCodeToCountryNameMap.get(twoLetterCountryCode);
            return Optional.ofNullable(countryName);
        }
        return Optional.empty();
    }

    private static class MapHolder {
        private static final Map<IpAddressMatcher, String> CIDR_NOTATIONS_TO_COUNTRY_ISO_CODE_MAP = MapHolder.getCidrNotationsToCountryIdoCodeMap();
        private static final Map<String, String> COUNTRY_ISO_CODE_TO_COUNTRY_NAME_MAP = MapHolder.getCountryIsoCodeToCountryNameMapInternal();

        private MapHolder() {
        }

        private static Map<IpAddressMatcher, String> getCidrNotationsToCountryIdoCodeMap() {
            HashMap<IpAddressMatcher, String> cidrNotationsToCountryIsoCodeMap = new HashMap<IpAddressMatcher, String>();
            Map<String, String> countryIdToCountryIsoCodeMap = MapHolder.getCountryIdToCountryIsoCodeMap();
            MapHolder.loadIpv4Csv(cidrNotationsToCountryIsoCodeMap, countryIdToCountryIsoCodeMap);
            MapHolder.loadIpv6Csv(cidrNotationsToCountryIsoCodeMap, countryIdToCountryIsoCodeMap);
            return cidrNotationsToCountryIsoCodeMap;
        }

        private static void loadIpv4Csv(Map<IpAddressMatcher, String> cidrNotationsToCountryIsoCodeMap, Map<String, String> countryIdToCountryIsoCodeMap) {
            MapHolder.loadIpvCsv(cidrNotationsToCountryIsoCodeMap, countryIdToCountryIsoCodeMap, "GeoLite2-Country-Blocks-IPv4.csv");
        }

        private static void loadIpv6Csv(Map<IpAddressMatcher, String> cidrNotationsToCountryIsoCodeMap, Map<String, String> countryIdToCountryIsoCodeMap) {
            MapHolder.loadIpvCsv(cidrNotationsToCountryIsoCodeMap, countryIdToCountryIsoCodeMap, "GeoLite2-Country-Blocks-IPv6.csv");
        }

        private static void loadIpvCsv(Map<IpAddressMatcher, String> cidrNotationsToCountryIsoCodeMap, Map<String, String> countryIdToCountryIsoCodeMap, String filename) {
            try (InputStream inputStream = MapHolder.class.getClassLoader().getResourceAsStream(filename);){
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                Map<IpAddressMatcher, String> ipMap = reader.lines().skip(1L).map(e -> e.split(",")).filter(e -> !e[2].isEmpty() || !e[1].isEmpty()).collect(Collectors.toMap(e -> new IpAddressMatcher(e[0]), e -> MapHolder.mapCountryCodeToCountryIsoCode(countryIdToCountryIsoCodeMap, e)));
                cidrNotationsToCountryIsoCodeMap.putAll(ipMap);
            }
            catch (IOException e2) {
                throw new GeoIPException("Failed to read csv: " + filename, e2);
            }
        }

        private static Map<String, String> getCountryIdToCountryIsoCodeMap() {
            Map<String, String> map;
            block8: {
                InputStream inputStream = MapHolder.class.getClassLoader().getResourceAsStream("GeoLite2-Country-Locations-en.csv");
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    map = reader.lines().skip(1L).map(e -> e.split(",")).collect(Collectors.toMap(e -> e[0], e -> e[4]));
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e2) {
                        throw new GeoIPException("Failed to read GeoLite2-Country-Locations-en.csv", e2);
                    }
                }
                inputStream.close();
            }
            return map;
        }

        private static Map<String, String> getCountryIsoCodeToCountryNameMapInternal() {
            Map<String, String> map;
            block8: {
                InputStream inputStream = MapHolder.class.getClassLoader().getResourceAsStream("GeoLite2-Country-Locations-en.csv");
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    map = reader.lines().skip(1L).map(e -> e.split(",")).filter(e -> e[4] != null && !e[4].isEmpty()).filter(e -> e[5] != null && !e[5].isEmpty()).collect(Collectors.toMap(e -> e[4], e -> MapHolder.stripLeadingAndTrailingDoubleQuotes(e[5]), (a, b) -> a));
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e2) {
                        throw new GeoIPException("Failed to read GeoLite2-Country-Locations-en.csv", e2);
                    }
                }
                inputStream.close();
            }
            return map;
        }

        private static String mapCountryCodeToCountryIsoCode(Map<String, String> countryIdToCountryIsoCodeMap, String[] splittedLine) {
            String registeredCountryGeonameId = splittedLine[2];
            String geonameId = splittedLine[1];
            String countryId = registeredCountryGeonameId.isEmpty() ? geonameId : registeredCountryGeonameId;
            return MapHolder.getCountryIsoCodeFromCountryId(countryIdToCountryIsoCodeMap, countryId);
        }

        private static String getCountryIsoCodeFromCountryId(Map<String, String> countryIdToCountryIsoCodeMap, String countryId) {
            boolean countryIsoCodeWasNotFoundForCountryId;
            String countryIsoCode = countryIdToCountryIsoCodeMap.get(countryId);
            boolean bl = countryIsoCodeWasNotFoundForCountryId = countryIsoCode == null;
            if (countryIsoCodeWasNotFoundForCountryId) {
                throw new GeoIPException("Country iso code was not found for countryId, countryId: " + countryId);
            }
            return countryIsoCode;
        }

        private static String stripLeadingAndTrailingDoubleQuotes(String maybeQuotedCountryName) {
            String countryName = maybeQuotedCountryName;
            if (countryName.startsWith("\"")) {
                countryName = countryName.substring(1);
            }
            if (countryName.endsWith("\"")) {
                countryName = countryName.substring(0, countryName.length() - 1);
            }
            return countryName;
        }

        private static Map<IpAddressMatcher, String> getCidrNotationsToCountryIsoCodeMap() {
            return CIDR_NOTATIONS_TO_COUNTRY_ISO_CODE_MAP;
        }

        private static Map<String, String> getCountryIsoCodeToCountryNameMap() {
            return COUNTRY_ISO_CODE_TO_COUNTRY_NAME_MAP;
        }
    }
}

