/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import net.minecraftforge.eventbus.ListenerList;
import net.minecraftforge.eventbus.api.EventListenerHelper;
import net.minecraftforge.eventbus.api.EventPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Event {
    private boolean isCanceled = false;
    private Result result = Result.DEFAULT;
    private EventPriority phase = null;

    public boolean isCancelable() {
        return EventListenerHelper.isCancelable(this.getClass());
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean cancel) {
        if (!this.isCancelable()) {
            throw new UnsupportedOperationException("Attempted to call Event#setCanceled() on a non-cancelable event of type: " + this.getClass().getCanonicalName());
        }
        if (this.seenPhase(EventPriority.MONITOR)) {
            throw new IllegalStateException("Attempted to call Event#setCanceled() after the MONITOR phase");
        }
        this.isCanceled = cancel;
    }

    public boolean hasResult() {
        return EventListenerHelper.hasResult(this.getClass());
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result value) {
        this.result = value;
    }

    public ListenerList getListenerList() {
        return EventListenerHelper.getListenerListInternal(this.getClass(), true);
    }

    @Nullable
    public EventPriority getPhase() {
        return this.phase;
    }

    public void setPhase(@NotNull EventPriority value) {
        Objects.requireNonNull(value, "setPhase argument must not be null");
        if (this.seenPhase(value)) {
            throw new IllegalArgumentException("Attempted to set event phase to " + value + " when already " + this.phase);
        }
        this.phase = value;
    }

    private boolean seenPhase(@NotNull EventPriority value) {
        int prev = this.phase == null ? -1 : this.phase.ordinal();
        return prev >= value.ordinal();
    }

    public static enum Result {
        DENY,
        DEFAULT,
        ALLOW;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface HasResult {
    }
}

