/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource.transformer;

import com.google.common.base.Preconditions;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.transformer.MappingTransformer;
import net.md_5.specialsource.transformer.MethodDescriptor;

public class MinecraftCodersPack
extends MappingTransformer {
    private final Map<String, String> fieldMap = new HashMap<String, String>();
    private final Map<String, String> methodMap = new HashMap<String, String>();
    private final Map<String, String> classPackageMap;

    public MinecraftCodersPack(File fieldsCsv, File methodsCsv, File packagesCsv) throws IOException {
        if (fieldsCsv != null && fieldsCsv.exists()) {
            this.readIntoMap(fieldsCsv, this.fieldMap);
        }
        if (methodsCsv != null && methodsCsv.exists()) {
            this.readIntoMap(methodsCsv, this.methodMap);
        }
        if (packagesCsv != null && packagesCsv.exists()) {
            this.classPackageMap = new HashMap<String, String>();
            HashMap<String, String> packages = new HashMap<String, String>();
            this.readIntoMap(packagesCsv, packages);
            for (Map.Entry entry : packages.entrySet()) {
                this.classPackageMap.put("net/minecraft/src/" + (String)entry.getKey(), (String)entry.getValue() + "/" + (String)entry.getKey());
            }
        } else {
            this.classPackageMap = null;
        }
    }

    private void readIntoMap(File file, Map<String, String> map) throws IOException {
        try (FileReader fileReader = new FileReader(file);
             CSVReader csvReader = new CSVReader((Reader)fileReader);){
            String[] line;
            while ((line = csvReader.readNextSilently()) != null) {
                if (line.length == 0) continue;
                Preconditions.checkArgument((line.length >= 2 ? 1 : 0) != 0, (String)"Invalid csv line: %s", (Object)line);
                map.put(line[0], line[1]);
            }
        }
    }

    @Override
    public String transformFieldName(String className, String fieldName) {
        String mapped = this.fieldMap.get(fieldName);
        return mapped != null ? mapped : fieldName;
    }

    @Override
    public String transformMethodName(String className, String methodName, String methodDescriptor) {
        String mapped = this.methodMap.get(methodName);
        return mapped != null ? mapped : methodName;
    }

    @Override
    public String transformClassName(String className) {
        if (this.classPackageMap == null) {
            return className;
        }
        String mapped = this.classPackageMap.get(className);
        return mapped != null ? JarRemapper.mapTypeName(className, null, this.classPackageMap, className) : className;
    }

    @Override
    public String transformMethodDescriptor(String oldDescriptor) {
        if (this.classPackageMap == null) {
            return oldDescriptor;
        }
        MethodDescriptor methodDescriptorTransformer = new MethodDescriptor(null, this.classPackageMap);
        return methodDescriptorTransformer.transform(oldDescriptor);
    }
}

