/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.primitives.Ints;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.logging.LogUtils;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.login.ClientboundGameProfilePacket;
import net.minecraft.network.protocol.login.ClientboundHelloPacket;
import net.minecraft.network.protocol.login.ClientboundLoginCompressionPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.ServerLoginPacketListener;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.network.protocol.login.ServerboundKeyPacket;
import net.minecraft.network.protocol.login.ServerboundLoginAcknowledgedPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class ServerLoginPacketListenerImpl
implements ServerLoginPacketListener,
TickablePacketListener {
    private static final AtomicInteger f_10014_ = new AtomicInteger(0);
    static final Logger f_10015_ = LogUtils.getLogger();
    private static final int f_143698_ = 600;
    private static final Component f_291075_ = Component.m_237115_("multiplayer.disconnect.unexpected_query_response");
    private final byte[] f_252396_;
    final MinecraftServer f_10018_;
    final Connection f_10013_;
    private volatile State f_10019_ = State.HELLO;
    private int f_10020_;
    @Nullable
    String f_291165_;
    @Nullable
    private GameProfile f_291112_;
    private final String f_10022_ = "";

    public ServerLoginPacketListenerImpl(MinecraftServer p_10027_, Connection p_10028_) {
        this.f_10018_ = p_10027_;
        this.f_10013_ = p_10028_;
        this.f_252396_ = Ints.toByteArray((int)RandomSource.m_216327_().m_188502_());
    }

    @Override
    public void m_9933_() {
        if (this.f_10019_ == State.VERIFYING) {
            this.m_294778_(Objects.requireNonNull(this.f_291112_));
        }
        if (this.f_10019_ == State.WAITING_FOR_DUPE_DISCONNECT && !this.m_294137_(Objects.requireNonNull(this.f_291112_))) {
            this.m_293203_(this.f_291112_);
        }
        if (this.f_10020_++ == 600) {
            this.m_10053_(Component.m_237115_("multiplayer.disconnect.slow_login"));
        }
    }

    @Override
    public boolean m_6198_() {
        return this.f_10013_.m_129536_();
    }

    public void m_10053_(Component p_10054_) {
        try {
            f_10015_.info("Disconnecting {}: {}", (Object)this.m_10056_(), (Object)p_10054_.getString());
            this.f_10013_.m_129512_(new ClientboundLoginDisconnectPacket(p_10054_));
            this.f_10013_.m_129507_(p_10054_);
        }
        catch (Exception $$1) {
            f_10015_.error("Error whilst disconnecting player", (Throwable)$$1);
        }
    }

    private boolean m_294137_(GameProfile p_298499_) {
        return this.f_10018_.m_6846_().m_11259_(p_298499_.getId()) != null;
    }

    @Override
    public void m_7026_(Component p_10043_) {
        f_10015_.info("{} lost connection: {}", (Object)this.m_10056_(), (Object)p_10043_.getString());
    }

    public String m_10056_() {
        String $$0 = this.f_10013_.m_295656_(this.f_10018_.m_292975_());
        if (this.f_291165_ != null) {
            return this.f_291165_ + " (" + $$0 + ")";
        }
        return $$0;
    }

    @Override
    public void m_5990_(ServerboundHelloPacket p_10047_) {
        Validate.validState((this.f_10019_ == State.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)ServerLoginPacketListenerImpl.m_203792_(p_10047_.f_238040_()), (String)"Invalid characters in username", (Object[])new Object[0]);
        this.f_291165_ = p_10047_.f_238040_();
        GameProfile $$1 = this.f_10018_.m_236731_();
        if ($$1 != null && this.f_291165_.equalsIgnoreCase($$1.getName())) {
            this.m_294008_($$1);
            return;
        }
        if (this.f_10018_.m_129797_() && !this.f_10013_.m_129531_()) {
            this.f_10019_ = State.KEY;
            this.f_10013_.m_129512_(new ClientboundHelloPacket("", this.f_10018_.m_129790_().getPublic().getEncoded(), this.f_252396_));
        } else {
            this.m_294008_(ServerLoginPacketListenerImpl.m_295545_(this.f_291165_));
        }
    }

    void m_294008_(GameProfile p_301095_) {
        this.f_291112_ = p_301095_;
        this.f_10019_ = State.VERIFYING;
    }

    private void m_294778_(GameProfile p_299507_) {
        PlayerList $$1 = this.f_10018_.m_6846_();
        Component $$2 = $$1.m_6418_(this.f_10013_.m_129523_(), p_299507_);
        if ($$2 != null) {
            this.m_10053_($$2);
        } else {
            boolean $$3;
            if (this.f_10018_.m_6328_() >= 0 && !this.f_10013_.m_129531_()) {
                this.f_10013_.m_243124_(new ClientboundLoginCompressionPacket(this.f_10018_.m_6328_()), PacketSendListener.m_243092_(() -> this.f_10013_.m_129484_(this.f_10018_.m_6328_(), true)));
            }
            if ($$3 = $$1.m_292966_(p_299507_)) {
                this.f_10019_ = State.WAITING_FOR_DUPE_DISCONNECT;
            } else {
                this.m_293203_(p_299507_);
            }
        }
    }

    private void m_293203_(GameProfile p_300150_) {
        this.f_10019_ = State.PROTOCOL_SWITCHING;
        this.f_10013_.m_129512_(new ClientboundGameProfilePacket(p_300150_));
    }

    public static boolean m_203792_(String p_203793_) {
        return p_203793_.chars().filter(p_203791_ -> p_203791_ <= 32 || p_203791_ >= 127).findAny().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void m_8072_(ServerboundKeyPacket p_10049_) {
        void $$7;
        Validate.validState((this.f_10019_ == State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey $$1 = this.f_10018_.m_129790_().getPrivate();
            if (!p_10049_.m_253194_(this.f_252396_, $$1)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey $$2 = p_10049_.m_134859_($$1);
            Cipher $$3 = Crypt.m_13583_(2, $$2);
            Cipher $$4 = Crypt.m_13583_(1, $$2);
            String $$5 = new BigInteger(Crypt.m_13590_("", this.f_10018_.m_129790_().getPublic(), $$2)).toString(16);
            this.f_10019_ = State.AUTHENTICATING;
            this.f_10013_.m_129495_($$3, $$4);
        }
        catch (CryptException $$6) {
            throw new IllegalStateException("Protocol error", $$6);
        }
        Thread $$8 = new Thread("User Authenticator #" + f_10014_.incrementAndGet(), (String)$$7){
            final /* synthetic */ String f_10058_;
            {
                this.f_10058_ = string;
                super(p_10062_);
            }

            @Override
            public void run() {
                String $$0 = Objects.requireNonNull(ServerLoginPacketListenerImpl.this.f_291165_, "Player name not initialized");
                try {
                    ProfileResult $$1 = ServerLoginPacketListenerImpl.this.f_10018_.m_129925_().hasJoinedServer($$0, this.f_10058_, this.m_10064_());
                    if ($$1 != null) {
                        GameProfile $$2 = $$1.profile();
                        f_10015_.info("UUID of player {} is {}", (Object)$$2.getName(), (Object)$$2.getId());
                        ServerLoginPacketListenerImpl.this.m_294008_($$2);
                    } else if (ServerLoginPacketListenerImpl.this.f_10018_.m_129792_()) {
                        f_10015_.warn("Failed to verify username but will let them in anyway!");
                        ServerLoginPacketListenerImpl.this.m_294008_(ServerLoginPacketListenerImpl.m_295545_($$0));
                    } else {
                        ServerLoginPacketListenerImpl.this.m_10053_(Component.m_237115_("multiplayer.disconnect.unverified_username"));
                        f_10015_.error("Username '{}' tried to join with an invalid session", (Object)$$0);
                    }
                }
                catch (AuthenticationUnavailableException $$3) {
                    if (ServerLoginPacketListenerImpl.this.f_10018_.m_129792_()) {
                        f_10015_.warn("Authentication servers are down but will let them in anyway!");
                        ServerLoginPacketListenerImpl.this.m_294008_(ServerLoginPacketListenerImpl.m_295545_($$0));
                    }
                    ServerLoginPacketListenerImpl.this.m_10053_(Component.m_237115_("multiplayer.disconnect.authservers_down"));
                    f_10015_.error("Couldn't verify username because servers are unavailable");
                }
            }

            @Nullable
            private InetAddress m_10064_() {
                SocketAddress $$0 = ServerLoginPacketListenerImpl.this.f_10013_.m_129523_();
                return ServerLoginPacketListenerImpl.this.f_10018_.m_129798_() && $$0 instanceof InetSocketAddress ? ((InetSocketAddress)$$0).getAddress() : null;
            }
        };
        $$8.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(f_10015_));
        $$8.start();
    }

    @Override
    public void m_10044_(ServerboundCustomQueryAnswerPacket p_297965_) {
        this.m_10053_(f_291075_);
    }

    @Override
    public void m_7223_(ServerboundLoginAcknowledgedPacket p_298815_) {
        Validate.validState((this.f_10019_ == State.PROTOCOL_SWITCHING ? 1 : 0) != 0, (String)"Unexpected login acknowledgement packet", (Object[])new Object[0]);
        CommonListenerCookie $$1 = CommonListenerCookie.m_294081_(Objects.requireNonNull(this.f_291112_));
        ServerConfigurationPacketListenerImpl $$2 = new ServerConfigurationPacketListenerImpl(this.f_10018_, this.f_10013_, $$1);
        this.f_10013_.m_129505_($$2);
        $$2.m_294295_();
        this.f_10019_ = State.ACCEPTED;
    }

    protected static GameProfile m_295545_(String p_297551_) {
        UUID $$1 = UUIDUtil.m_235879_(p_297551_);
        return new GameProfile($$1, p_297551_);
    }

    static final class State
    extends Enum<State> {
        public static final /* enum */ State HELLO = new State();
        public static final /* enum */ State KEY = new State();
        public static final /* enum */ State AUTHENTICATING = new State();
        public static final /* enum */ State NEGOTIATING = new State();
        public static final /* enum */ State VERIFYING = new State();
        public static final /* enum */ State WAITING_FOR_DUPE_DISCONNECT = new State();
        public static final /* enum */ State PROTOCOL_SWITCHING = new State();
        public static final /* enum */ State ACCEPTED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String p_10079_) {
            return Enum.valueOf(State.class, p_10079_);
        }

        private static /* synthetic */ State[] m_143701_() {
            return new State[]{HELLO, KEY, AUTHENTICATING, NEGOTIATING, VERIFYING, WAITING_FOR_DUPE_DISCONNECT, PROTOCOL_SWITCHING, ACCEPTED};
        }

        static {
            $VALUES = State.m_143701_();
        }
    }
}

