/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RecipeBookManager;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientRecipeBook
extends RecipeBook {
    private static final Logger f_90618_ = LogUtils.getLogger();
    private Map<RecipeBookCategories, List<RecipeCollection>> f_90619_ = ImmutableMap.of();
    private List<RecipeCollection> f_90620_ = ImmutableList.of();

    public void m_266394_(Iterable<RecipeHolder<?>> p_266814_, RegistryAccess p_266878_) {
        Map<RecipeBookCategories, List<List<RecipeHolder<?>>>> map = ClientRecipeBook.m_90642_(p_266814_);
        HashMap map1 = Maps.newHashMap();
        ImmutableList.Builder builder = ImmutableList.builder();
        map.forEach((p_266602_, p_266603_) -> map1.put(p_266602_, (List)p_266603_.stream().map(p_266605_ -> new RecipeCollection(p_266878_, p_266605_)).peek(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)).collect(ImmutableList.toImmutableList())));
        RecipeBookCategories.f_92260_.forEach((p_90637_, p_90638_) -> map1.put(p_90637_, (List)p_90638_.stream().flatMap(p_167706_ -> ((List)map1.getOrDefault(p_167706_, ImmutableList.of())).stream()).collect(ImmutableList.toImmutableList())));
        this.f_90619_ = ImmutableMap.copyOf((Map)map1);
        this.f_90620_ = builder.build();
    }

    private static Map<RecipeBookCategories, List<List<RecipeHolder<?>>>> m_90642_(Iterable<RecipeHolder<?>> p_90643_) {
        HashMap map = Maps.newHashMap();
        HashBasedTable table = HashBasedTable.create();
        for (RecipeHolder<?> recipeholder : p_90643_) {
            String s;
            Object recipe = recipeholder.f_291008_();
            if (recipe.m_5598_() || recipe.m_142505_()) continue;
            RecipeBookCategories recipebookcategories = ClientRecipeBook.m_90646_(recipeholder);
            String string = s = recipe.m_6076_().isEmpty() ? recipeholder.f_291676_().toString() : recipe.m_6076_();
            if (s.isEmpty()) {
                map.computeIfAbsent(recipebookcategories, p_90645_ -> Lists.newArrayList()).add(ImmutableList.of(recipeholder));
                continue;
            }
            List list = (List)table.get((Object)recipebookcategories, (Object)s);
            if (list == null) {
                list = Lists.newArrayList();
                table.put((Object)recipebookcategories, (Object)s, (Object)list);
                map.computeIfAbsent(recipebookcategories, p_90641_ -> Lists.newArrayList()).add(list);
            }
            list.add(recipeholder);
        }
        return map;
    }

    private static RecipeBookCategories m_90646_(RecipeHolder<?> p_299041_) {
        Object recipe = p_299041_.f_291008_();
        if (recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingrecipe = (CraftingRecipe)recipe;
            return switch (craftingrecipe.m_245232_()) {
                case CraftingBookCategory.BUILDING -> RecipeBookCategories.CRAFTING_BUILDING_BLOCKS;
                case CraftingBookCategory.EQUIPMENT -> RecipeBookCategories.CRAFTING_EQUIPMENT;
                case CraftingBookCategory.REDSTONE -> RecipeBookCategories.CRAFTING_REDSTONE;
                case CraftingBookCategory.MISC -> RecipeBookCategories.CRAFTING_MISC;
                default -> throw new IncompatibleClassChangeError();
            };
        }
        RecipeType<?> recipetype = recipe.m_6671_();
        if (recipe instanceof AbstractCookingRecipe) {
            AbstractCookingRecipe abstractcookingrecipe = (AbstractCookingRecipe)recipe;
            CookingBookCategory cookingbookcategory = abstractcookingrecipe.m_245534_();
            if (recipetype == RecipeType.f_44108_) {
                return switch (cookingbookcategory) {
                    case CookingBookCategory.BLOCKS -> RecipeBookCategories.FURNACE_BLOCKS;
                    case CookingBookCategory.FOOD -> RecipeBookCategories.FURNACE_FOOD;
                    case CookingBookCategory.MISC -> RecipeBookCategories.FURNACE_MISC;
                    default -> throw new IncompatibleClassChangeError();
                };
            }
            if (recipetype == RecipeType.f_44109_) {
                return cookingbookcategory == CookingBookCategory.BLOCKS ? RecipeBookCategories.BLAST_FURNACE_BLOCKS : RecipeBookCategories.BLAST_FURNACE_MISC;
            }
            if (recipetype == RecipeType.f_44110_) {
                return RecipeBookCategories.SMOKER_FOOD;
            }
            if (recipetype == RecipeType.f_44111_) {
                return RecipeBookCategories.CAMPFIRE;
            }
        }
        if (recipetype == RecipeType.f_44112_) {
            return RecipeBookCategories.STONECUTTER;
        }
        if (recipetype == RecipeType.f_44113_) {
            return RecipeBookCategories.SMITHING;
        }
        RecipeBookCategories categories = RecipeBookManager.findCategories(recipetype, p_299041_);
        if (categories != null) {
            return categories;
        }
        f_90618_.warn("Unknown recipe category: {}/{}", LogUtils.defer(() -> BuiltInRegistries.f_256990_.m_7981_(recipe.m_6671_())), LogUtils.defer(p_299041_::f_291676_));
        return RecipeBookCategories.UNKNOWN;
    }

    public List<RecipeCollection> m_90639_() {
        return this.f_90620_;
    }

    public List<RecipeCollection> m_90623_(RecipeBookCategories p_90624_) {
        return this.f_90619_.getOrDefault((Object)p_90624_, Collections.emptyList());
    }
}

