/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.StitcherException;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceList;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class SpriteLoader {
    public static final Set<MetadataSectionSerializer<?>> f_291626_ = Set.of(AnimationMetadataSection.f_119011_);
    private static final Logger f_244357_ = LogUtils.getLogger();
    private final ResourceLocation f_244500_;
    private final int f_243676_;
    private final int f_276071_;
    private final int f_276068_;

    public SpriteLoader(ResourceLocation p_276126_, int p_276121_, int p_276110_, int p_276114_) {
        this.f_244500_ = p_276126_;
        this.f_243676_ = p_276121_;
        this.f_276071_ = p_276110_;
        this.f_276068_ = p_276114_;
    }

    public static SpriteLoader m_245483_(TextureAtlas p_249085_) {
        return new SpriteLoader(p_249085_.m_118330_(), p_249085_.m_245285_(), p_249085_.m_276092_(), p_249085_.m_276095_());
    }

    public Preparations m_261295_(List<SpriteContents> p_262029_, int p_261919_, Executor p_261665_) {
        int i = this.f_243676_;
        Stitcher<SpriteContents> stitcher = new Stitcher<SpriteContents>(i, i, p_261919_);
        int j = Integer.MAX_VALUE;
        int k = 1 << p_261919_;
        for (SpriteContents spritecontents : p_262029_) {
            j = Math.min(j, Math.min(spritecontents.m_246492_(), spritecontents.m_245330_()));
            int l = Math.min(Integer.lowestOneBit(spritecontents.m_246492_()), Integer.lowestOneBit(spritecontents.m_245330_()));
            if (l < k) {
                f_244357_.warn("Texture {} with size {}x{} limits mip level from {} to {}", new Object[]{spritecontents.m_246162_(), spritecontents.m_246492_(), spritecontents.m_245330_(), Mth.m_14173_((int)k), Mth.m_14173_((int)l)});
                k = l;
            }
            stitcher.m_246099_(spritecontents);
        }
        int j1 = Math.min(j, k);
        int k1 = Mth.m_14173_((int)j1);
        int l1 = p_261919_;
        try {
            stitcher.m_118193_();
        }
        catch (StitcherException stitcherexception) {
            CrashReport crashreport = CrashReport.m_127521_(stitcherexception, "Stitching");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Stitcher");
            crashreportcategory.m_128159_("Sprites", stitcherexception.m_118258_().stream().map(p_249576_ -> String.format(Locale.ROOT, "%s[%dx%d]", p_249576_.m_246162_(), p_249576_.m_246492_(), p_249576_.m_245330_())).collect(Collectors.joining(",")));
            crashreportcategory.m_128159_("Max Texture Size", i);
            throw new ReportedException(crashreport);
        }
        int i1 = Math.max(stitcher.m_118174_(), this.f_276071_);
        int i2 = Math.max(stitcher.m_118187_(), this.f_276068_);
        Map<ResourceLocation, TextureAtlasSprite> map = this.m_276091_(stitcher, i1, i2);
        TextureAtlasSprite textureatlassprite = map.get(MissingTextureAtlasSprite.m_118071_());
        CompletableFuture<Void> completablefuture = l1 > 0 ? CompletableFuture.runAsync(() -> map.values().forEach(p_251202_ -> p_251202_.m_245424_().m_246368_(l1)), p_261665_) : CompletableFuture.completedFuture(null);
        return new Preparations(i1, i2, l1, textureatlassprite, map, completablefuture);
    }

    public static CompletableFuture<List<SpriteContents>> m_260809_(SpriteResourceLoader p_297457_, List<Function<SpriteResourceLoader, SpriteContents>> p_261516_, Executor p_261791_) {
        List<CompletableFuture> list = p_261516_.stream().map(p_296294_ -> CompletableFuture.supplyAsync(() -> (SpriteContents)p_296294_.apply(p_297457_), p_261791_)).toList();
        return Util.m_137567_(list).thenApply(p_252234_ -> p_252234_.stream().filter(Objects::nonNull).toList());
    }

    public CompletableFuture<Preparations> m_260881_(ResourceManager p_262108_, ResourceLocation p_261754_, int p_262104_, Executor p_261687_) {
        return this.m_293475_(p_262108_, p_261754_, p_262104_, p_261687_, f_291626_);
    }

    public CompletableFuture<Preparations> m_293475_(ResourceManager p_300124_, ResourceLocation p_301196_, int p_300787_, Executor p_300950_, Collection<MetadataSectionSerializer<?>> p_298047_) {
        SpriteResourceLoader spriteresourceloader = SpriteResourceLoader.m_292996_(p_298047_);
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> SpriteSourceList.m_294995_((ResourceManager)p_300124_, (ResourceLocation)p_301196_).m_294473_(p_300124_), p_300950_).thenCompose(p_296297_ -> SpriteLoader.m_260809_(spriteresourceloader, p_296297_, p_300950_))).thenApply(p_261393_ -> this.m_261295_((List<SpriteContents>)p_261393_, p_300787_, p_300950_));
    }

    private Map<ResourceLocation, TextureAtlasSprite> m_276091_(Stitcher<SpriteContents> p_276117_, int p_276111_, int p_276112_) {
        HashMap<ResourceLocation, TextureAtlasSprite> map = new HashMap<ResourceLocation, TextureAtlasSprite>();
        p_276117_.m_118180_((p_251421_, p_250533_, p_251913_) -> {
            TextureAtlasSprite sprite = ForgeHooksClient.loadTextureAtlasSprite((ResourceLocation)this.f_244500_, (SpriteContents)p_251421_, (int)p_276111_, (int)p_276112_, (int)p_250533_, (int)p_251913_, (int)(p_251421_.f_243731_.length - 1));
            if (sprite != null) {
                map.put(p_251421_.m_246162_(), sprite);
                return;
            }
            map.put(p_251421_.m_246162_(), new TextureAtlasSprite(this.f_244500_, (SpriteContents)p_251421_, p_276111_, p_276112_, p_250533_, p_251913_));
        });
        return map;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Preparations(int f_243669_, int f_244632_, int f_244353_, TextureAtlasSprite f_243912_, Map<ResourceLocation, TextureAtlasSprite> f_243807_, CompletableFuture<Void> f_244415_) {
        public CompletableFuture<Preparations> m_246429_() {
            return this.f_244415_.thenApply(p_249056_ -> this);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Preparations.class, "width;height;mipLevel;missing;regions;readyForUpload", "f_243669_", "f_244632_", "f_244353_", "f_243912_", "f_243807_", "f_244415_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Preparations.class, "width;height;mipLevel;missing;regions;readyForUpload", "f_243669_", "f_244632_", "f_244353_", "f_243912_", "f_243807_", "f_244415_"}, this);
        }

        @Override
        public final boolean equals(Object p_250785_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Preparations.class, "width;height;mipLevel;missing;regions;readyForUpload", "f_243669_", "f_244632_", "f_244353_", "f_243912_", "f_243807_", "f_244415_"}, this, p_250785_);
        }
    }
}

