/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.base.Suppliers;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mohistmc.api.PlayerAPI;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.CipherDecoder;
import net.minecraft.network.CipherEncoder;
import net.minecraft.network.CompressionDecoder;
import net.minecraft.network.CompressionEncoder;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketBundlePacker;
import net.minecraft.network.PacketBundleUnpacker;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketFlowValidator;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.SkipPacketException;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.Varint21FrameDecoder;
import net.minecraft.network.Varint21LengthFieldPrepender;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.login.ClientLoginPacketListener;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.util.Mth;
import net.minecraft.util.SampleLogger;
import net.minecraftforge.common.util.PacketLogger;
import net.minecraftforge.network.DualStackUtils;
import net.minecraftforge.network.NetworkContext;
import net.minecraftforge.network.NetworkRegistry;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Connection
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float f_178299_ = 0.75f;
    private static final Logger f_129465_ = LogUtils.getLogger();
    public static final Marker f_129459_ = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker f_129460_ = Util.m_137469_(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), p_202569_ -> p_202569_.add(f_129459_));
    public static final Marker f_202554_ = Util.m_137469_(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), p_202562_ -> p_202562_.add(f_129460_));
    public static final Marker f_202555_ = Util.m_137469_(MarkerFactory.getMarker((String)"PACKET_SENT"), p_202557_ -> p_202557_.add(f_129460_));
    public static final AttributeKey<ConnectionProtocol.CodecData<?>> f_290984_ = AttributeKey.valueOf((String)"serverbound_protocol");
    public static final AttributeKey<ConnectionProtocol.CodecData<?>> f_291426_ = AttributeKey.valueOf((String)"clientbound_protocol");
    public static final Supplier<NioEventLoopGroup> f_129462_ = Suppliers.memoize(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).build()));
    public static final Supplier<EpollEventLoopGroup> f_129463_ = Suppliers.memoize(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).build()));
    public static final Supplier<DefaultEventLoopGroup> f_129464_ = Suppliers.memoize(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).build()));
    private final PacketFlow f_129466_;
    private final Queue<Consumer<Connection>> f_290881_ = Queues.newConcurrentLinkedQueue();
    public Channel f_129468_;
    public SocketAddress f_129469_;
    @Nullable
    private volatile PacketListener f_290681_;
    @Nullable
    private volatile PacketListener f_129470_;
    @Nullable
    private Component f_129471_;
    private boolean f_129472_;
    private boolean f_129473_;
    private int f_129474_;
    private int f_129475_;
    private float f_129476_;
    private float f_129477_;
    private int f_129478_;
    private boolean f_129479_;
    @Nullable
    private volatile Component f_290021_;
    @Nullable
    BandwidthDebugMonitor f_291520_;
    private Consumer<Connection> activationHandler;
    private final PacketLogger packetLogger;
    public String hostname = "";
    public UUID spoofedUUID;
    public Property[] spoofedProfile;
    public boolean preparing = true;
    public GameProfile player;

    public Connection(PacketFlow p_129482_) {
        this.f_129466_ = p_129482_;
        this.packetLogger = new PacketLogger(this);
    }

    public void channelActive(ChannelHandlerContext p_129525_) throws Exception {
        super.channelActive(p_129525_);
        this.f_129468_ = p_129525_.channel();
        this.f_129469_ = this.f_129468_.remoteAddress();
        if (this.activationHandler != null) {
            this.activationHandler.accept(this);
        }
        this.preparing = false;
        if (this.f_290021_ != null) {
            this.m_129507_(this.f_290021_);
        }
    }

    public static void m_294111_(Channel p_300821_) {
        p_300821_.attr(f_290984_).set(ConnectionProtocol.HANDSHAKING.m_295783_(PacketFlow.SERVERBOUND));
        p_300821_.attr(f_291426_).set(ConnectionProtocol.HANDSHAKING.m_295783_(PacketFlow.CLIENTBOUND));
    }

    public void channelInactive(ChannelHandlerContext p_129527_) {
        this.m_129507_((Component)Component.m_237115_("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext p_129533_, Throwable p_129534_) {
        if (p_129534_ instanceof SkipPacketException) {
            f_129465_.debug("Skipping packet due to errors", p_129534_.getCause());
        } else {
            boolean flag = !this.f_129479_;
            this.f_129479_ = true;
            if (this.f_129468_.isOpen()) {
                if (p_129534_ instanceof TimeoutException) {
                    f_129465_.debug("Timeout", p_129534_);
                    this.m_129507_((Component)Component.m_237115_("disconnect.timeout"));
                } else {
                    MutableComponent component = Component.m_237110_("disconnect.genericReason", "Internal Exception: " + p_129534_);
                    if (flag) {
                        f_129465_.debug("Failed to sent packet", p_129534_);
                        if (this.m_178314_() == PacketFlow.CLIENTBOUND) {
                            ConnectionProtocol connectionprotocol = ((ConnectionProtocol.CodecData)this.f_129468_.attr(f_291426_).get()).m_295191_();
                            ClientboundLoginDisconnectPacket packet = connectionprotocol == ConnectionProtocol.LOGIN ? new ClientboundLoginDisconnectPacket((Component)component) : new ClientboundDisconnectPacket((Component)component);
                            this.m_243124_((Packet<?>)packet, PacketSendListener.m_243092_(() -> this.m_202558_((Component)component)));
                        } else {
                            this.m_129507_((Component)component);
                        }
                        this.m_129540_();
                    } else {
                        f_129465_.debug("Double fault", p_129534_);
                        this.m_129507_((Component)component);
                    }
                }
            }
        }
    }

    protected void channelRead0(ChannelHandlerContext p_129487_, Packet<?> p_129488_) {
        if (this.f_129468_.isOpen()) {
            PacketListener packetlistener = this.f_129470_;
            if (packetlistener == null) {
                throw new IllegalStateException("Received a packet before the packet listener was initialized");
            }
            if (packetlistener.m_294638_(p_129488_)) {
                try {
                    this.packetLogger.recv(p_129488_);
                    Connection.m_129517_(p_129488_, packetlistener);
                }
                catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
                }
                catch (RejectedExecutionException rejectedexecutionexception) {
                    this.m_129507_((Component)Component.m_237115_("multiplayer.disconnect.server_shutdown"));
                }
                catch (ClassCastException classcastexception) {
                    f_129465_.error("Received {} that couldn't be processed", p_129488_.getClass(), (Object)classcastexception);
                    this.m_129507_((Component)Component.m_237115_("multiplayer.disconnect.invalid_packet"));
                }
                ++this.f_129474_;
            }
        }
    }

    private static <T extends PacketListener> void m_129517_(Packet<T> p_129518_, PacketListener p_129519_) {
        p_129518_.m_5797_(p_129519_);
    }

    public void m_294044_() {
        this.f_129468_.config().setAutoRead(false);
    }

    public void m_294304_() {
        this.f_129468_.config().setAutoRead(true);
    }

    public void m_129505_(PacketListener p_129506_) {
        Validate.notNull((Object)p_129506_, (String)"packetListener", (Object[])new Object[0]);
        PacketFlow packetflow = p_129506_.m_292762_();
        if (packetflow != this.f_129466_) {
            throw new IllegalStateException("Trying to set listener for wrong side: connection is " + this.f_129466_ + ", but listener is " + packetflow);
        }
        ConnectionProtocol connectionprotocol = p_129506_.m_292716_();
        ConnectionProtocol connectionprotocol1 = ((ConnectionProtocol.CodecData)this.f_129468_.attr(Connection.m_295397_(packetflow)).get()).m_295191_();
        if (connectionprotocol1 != connectionprotocol) {
            throw new IllegalStateException("Trying to set listener for protocol " + connectionprotocol.m_294991_() + ", but current " + packetflow + " protocol is " + connectionprotocol1.m_294991_());
        }
        this.f_129470_ = p_129506_;
        this.f_290681_ = null;
    }

    public void m_294587_(PacketListener p_299346_) {
        if (this.f_129470_ != null) {
            throw new IllegalStateException("Listener already set");
        }
        if (this.f_129466_ != PacketFlow.SERVERBOUND || p_299346_.m_292762_() != PacketFlow.SERVERBOUND || p_299346_.m_292716_() != ConnectionProtocol.HANDSHAKING) {
            throw new IllegalStateException("Invalid initial listener");
        }
        this.f_129470_ = p_299346_;
    }

    public void m_292894_(String p_297855_, int p_297423_, ClientStatusPacketListener p_300237_) {
        this.m_295796_(p_297855_, p_297423_, (PacketListener)p_300237_, ClientIntent.STATUS);
    }

    public void m_295889_(String p_300250_, int p_297906_, ClientLoginPacketListener p_297708_) {
        this.m_295796_(p_300250_, p_297906_, (PacketListener)p_297708_, ClientIntent.LOGIN);
    }

    private void m_295796_(String p_300730_, int p_300598_, PacketListener p_298739_, ClientIntent p_297789_) {
        this.f_290681_ = p_298739_;
        this.m_295864_(p_296374_ -> {
            p_296374_.m_294993_(p_297789_);
            this.m_129505_(p_298739_);
            p_296374_.m_129520_((Packet<?>)new ClientIntentionPacket(SharedConstants.m_183709_().m_132495_(), NetworkContext.enhanceHostName((String)p_300730_), p_300598_, p_297789_), null, true);
        });
    }

    public void m_294993_(ClientIntent p_300629_) {
        this.f_129468_.attr(f_291426_).set(p_300629_.m_295530_().m_295783_(PacketFlow.CLIENTBOUND));
    }

    public void m_129512_(Packet<?> p_129513_) {
        this.m_243124_(p_129513_, null);
    }

    public void m_243124_(Packet<?> p_243248_, @Nullable PacketSendListener p_243316_) {
        this.m_294750_(p_243248_, p_243316_, true);
    }

    public void m_294750_(Packet<?> p_298754_, @Nullable PacketSendListener p_300685_, boolean p_298821_) {
        if (this.m_129536_()) {
            this.m_129544_();
            this.m_129520_(p_298754_, p_300685_, p_298821_);
        } else {
            this.f_290881_.add(p_296381_ -> p_296381_.m_129520_(p_298754_, p_300685_, p_298821_));
        }
    }

    public void m_295864_(Consumer<Connection> p_297681_) {
        if (this.m_129536_()) {
            this.m_129544_();
            p_297681_.accept(this);
        } else {
            this.f_290881_.add(p_297681_);
        }
    }

    private void m_129520_(Packet<?> p_129521_, @Nullable PacketSendListener p_243246_, boolean p_299777_) {
        ++this.f_129475_;
        if (this.f_129468_.eventLoop().inEventLoop()) {
            this.m_243087_(p_129521_, p_243246_, p_299777_);
        } else {
            this.f_129468_.eventLoop().execute(() -> this.m_243087_(p_129521_, p_243246_, p_299777_));
        }
    }

    private void m_243087_(Packet<?> p_243260_, @Nullable PacketSendListener p_243290_, boolean p_299937_) {
        ChannelFuture channelfuture = p_299937_ ? this.f_129468_.writeAndFlush(p_243260_) : this.f_129468_.write(p_243260_);
        channelfuture.addListener(f -> this.packetLogger.send(p_243260_));
        if (p_243290_ != null) {
            channelfuture.addListener(p_243167_ -> {
                if (p_243167_.isSuccess()) {
                    p_243290_.m_243096_();
                } else {
                    Packet packet = p_243290_.m_243103_();
                    if (packet != null) {
                        ChannelFuture channelfuture1 = this.f_129468_.writeAndFlush((Object)packet);
                        channelfuture1.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                    }
                }
            });
        }
        channelfuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void m_295610_() {
        if (this.m_129536_()) {
            this.m_294674_();
        } else {
            this.f_290881_.add(Connection::m_294674_);
        }
    }

    private void m_294674_() {
        if (this.f_129468_.eventLoop().inEventLoop()) {
            this.f_129468_.flush();
        } else {
            this.f_129468_.eventLoop().execute(() -> this.f_129468_.flush());
        }
    }

    private static AttributeKey<ConnectionProtocol.CodecData<?>> m_295397_(PacketFlow p_298298_) {
        return switch (p_298298_) {
            case PacketFlow.CLIENTBOUND -> f_291426_;
            case PacketFlow.SERVERBOUND -> f_290984_;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void m_129544_() {
        if (this.f_129468_ != null && this.f_129468_.isOpen()) {
            Queue<Consumer<Connection>> queue = this.f_290881_;
            synchronized (queue) {
                Consumer<Connection> consumer;
                while ((consumer = this.f_290881_.poll()) != null) {
                    consumer.accept(this);
                }
            }
        }
    }

    public void m_129483_() {
        this.m_129544_();
        PacketListener packetlistener = this.f_129470_;
        if (packetlistener instanceof TickablePacketListener) {
            TickablePacketListener tickablepacketlistener = (TickablePacketListener)packetlistener;
            tickablepacketlistener.m_9933_();
        }
        if (!this.m_129536_() && !this.f_129473_) {
            this.m_129541_();
        }
        if (this.f_129468_ != null) {
            this.f_129468_.flush();
        }
        if (this.f_129478_++ % 20 == 0) {
            this.m_7073_();
        }
        if (this.f_291520_ != null) {
            this.f_291520_.m_293130_();
        }
    }

    protected void m_7073_() {
        this.f_129477_ = Mth.m_14179_((float)0.75f, (float)this.f_129475_, (float)this.f_129477_);
        this.f_129476_ = Mth.m_14179_((float)0.75f, (float)this.f_129474_, (float)this.f_129476_);
        this.f_129475_ = 0;
        this.f_129474_ = 0;
    }

    public SocketAddress m_129523_() {
        return this.f_129469_;
    }

    public String m_295656_(boolean p_298740_) {
        if (this.f_129469_ == null) {
            return "local";
        }
        return p_298740_ ? DualStackUtils.getAddressString((SocketAddress)this.f_129469_) : "IP hidden";
    }

    public void m_129507_(Component p_129508_) {
        if (this.f_129468_ == null) {
            this.f_290021_ = p_129508_;
        }
        this.preparing = false;
        if (this.m_129536_()) {
            this.f_129468_.close();
            this.f_129471_ = p_129508_;
        }
        if (this.player != null && PlayerAPI.modlist.containsKey(this.player.getId())) {
            PlayerAPI.modlist.remove(this.player.getId());
        }
    }

    public boolean m_129531_() {
        return this.f_129468_ instanceof LocalChannel || this.f_129468_ instanceof LocalServerChannel;
    }

    public PacketFlow m_178313_() {
        return this.f_129466_;
    }

    public PacketFlow m_178314_() {
        return this.f_129466_.m_178539_();
    }

    public static Connection m_178300_(InetSocketAddress p_178301_, boolean p_178302_, @Nullable SampleLogger p_300093_) {
        Connection connection = new Connection(PacketFlow.CLIENTBOUND);
        if (p_300093_ != null) {
            connection.m_292855_(p_300093_);
        }
        ChannelFuture channelfuture = Connection.m_290025_(p_178301_, p_178302_, connection);
        channelfuture.syncUninterruptibly();
        return connection;
    }

    public static ChannelFuture m_290025_(InetSocketAddress p_290034_, boolean p_290035_, final Connection p_290031_) {
        EventLoopGroup eventloopgroup;
        Class<NioSocketChannel> oclass;
        DualStackUtils.checkIPv6((InetAddress)p_290034_.getAddress());
        p_290031_.activationHandler = NetworkRegistry::onConnectionStart;
        if (Epoll.isAvailable() && p_290035_) {
            oclass = EpollSocketChannel.class;
            eventloopgroup = (EventLoopGroup)f_129463_.get();
        } else {
            oclass = NioSocketChannel.class;
            eventloopgroup = (EventLoopGroup)f_129462_.get();
        }
        return ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventloopgroup)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel p_129552_) {
                Connection.m_294111_(p_129552_);
                try {
                    p_129552_.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline channelpipeline = p_129552_.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                Connection.m_264299_(channelpipeline, PacketFlow.CLIENTBOUND, p_290031_.f_291520_);
                p_290031_.m_295611_(channelpipeline);
            }
        })).channel(oclass)).connect(p_290034_.getAddress(), p_290034_.getPort());
    }

    public static void m_264299_(ChannelPipeline p_265436_, PacketFlow p_265104_, @Nullable BandwidthDebugMonitor p_299297_) {
        PacketFlow packetflow = p_265104_.m_178539_();
        AttributeKey<ConnectionProtocol.CodecData<?>> attributekey = Connection.m_295397_(p_265104_);
        AttributeKey<ConnectionProtocol.CodecData<?>> attributekey1 = Connection.m_295397_(packetflow);
        p_265436_.addLast("splitter", (ChannelHandler)new Varint21FrameDecoder(p_299297_)).addLast("decoder", (ChannelHandler)new PacketDecoder(attributekey)).addLast("prepender", (ChannelHandler)new Varint21LengthFieldPrepender()).addLast("encoder", (ChannelHandler)new PacketEncoder(attributekey1)).addLast("unbundler", (ChannelHandler)new PacketBundleUnpacker(attributekey1)).addLast("bundler", (ChannelHandler)new PacketBundlePacker(attributekey));
    }

    public void m_295611_(ChannelPipeline p_300754_) {
        p_300754_.addLast(new ChannelHandler[]{new FlowControlHandler()}).addLast("packet_handler", (ChannelHandler)this);
    }

    private static void m_293223_(ChannelPipeline p_299383_, PacketFlow p_299305_) {
        PacketFlow packetflow = p_299305_.m_178539_();
        AttributeKey<ConnectionProtocol.CodecData<?>> attributekey = Connection.m_295397_(p_299305_);
        AttributeKey<ConnectionProtocol.CodecData<?>> attributekey1 = Connection.m_295397_(packetflow);
        p_299383_.addLast("validator", (ChannelHandler)new PacketFlowValidator(attributekey, attributekey1));
    }

    public static void m_294700_(ChannelPipeline p_298130_, PacketFlow p_298133_) {
        Connection.m_293223_(p_298130_, p_298133_);
    }

    public static Connection m_129493_(SocketAddress p_129494_) {
        final Connection connection = new Connection(PacketFlow.CLIENTBOUND);
        connection.activationHandler = NetworkRegistry::onConnectionStart;
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)f_129464_.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel p_129557_) {
                Connection.m_294111_(p_129557_);
                ChannelPipeline channelpipeline = p_129557_.pipeline();
                Connection.m_294700_(channelpipeline, PacketFlow.CLIENTBOUND);
                connection.m_295611_(channelpipeline);
            }
        })).channel(LocalChannel.class)).connect(p_129494_).syncUninterruptibly();
        return connection;
    }

    public void m_129495_(Cipher p_129496_, Cipher p_129497_) {
        this.f_129472_ = true;
        this.f_129468_.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new CipherDecoder(p_129496_));
        this.f_129468_.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new CipherEncoder(p_129497_));
    }

    public boolean m_129535_() {
        return this.f_129472_;
    }

    public boolean m_129536_() {
        return this.f_129468_ != null && this.f_129468_.isOpen();
    }

    public boolean m_129537_() {
        return this.f_129468_ == null;
    }

    @Nullable
    public PacketListener m_129538_() {
        return this.f_129470_;
    }

    @Nullable
    public Component m_129539_() {
        return this.f_129471_;
    }

    public void m_129540_() {
        if (this.f_129468_ != null) {
            this.f_129468_.config().setAutoRead(false);
        }
    }

    public void m_129484_(int p_129485_, boolean p_182682_) {
        if (p_129485_ >= 0) {
            if (this.f_129468_.pipeline().get("decompress") instanceof CompressionDecoder) {
                ((CompressionDecoder)this.f_129468_.pipeline().get("decompress")).m_182677_(p_129485_, p_182682_);
            } else {
                this.f_129468_.pipeline().addBefore("decoder", "decompress", (ChannelHandler)new CompressionDecoder(p_129485_, p_182682_));
            }
            if (this.f_129468_.pipeline().get("compress") instanceof CompressionEncoder) {
                ((CompressionEncoder)this.f_129468_.pipeline().get("compress")).m_129449_(p_129485_);
            } else {
                this.f_129468_.pipeline().addBefore("encoder", "compress", (ChannelHandler)new CompressionEncoder(p_129485_));
            }
        } else {
            if (this.f_129468_.pipeline().get("decompress") instanceof CompressionDecoder) {
                this.f_129468_.pipeline().remove("decompress");
            }
            if (this.f_129468_.pipeline().get("compress") instanceof CompressionEncoder) {
                this.f_129468_.pipeline().remove("compress");
            }
        }
    }

    public void m_129541_() {
        if (this.f_129468_ != null && !this.f_129468_.isOpen()) {
            if (this.f_129473_) {
                f_129465_.warn("handleDisconnection() called twice");
            } else {
                PacketListener packetlistener1;
                this.f_129473_ = true;
                PacketListener packetlistener = this.m_129538_();
                PacketListener packetListener = packetlistener1 = packetlistener != null ? packetlistener : this.f_290681_;
                if (packetlistener1 != null) {
                    Component component = Objects.requireNonNullElseGet(this.m_129539_(), () -> Component.m_237115_("multiplayer.disconnect.generic"));
                    packetlistener1.m_7026_(component);
                }
            }
        }
    }

    public float m_129542_() {
        return this.f_129476_;
    }

    public float m_129543_() {
        return this.f_129477_;
    }

    public Channel channel() {
        return this.f_129468_;
    }

    public ConnectionProtocol getProtocol() {
        return ((ConnectionProtocol.CodecData)this.f_129468_.attr(Connection.m_295397_(this.m_178314_())).get()).m_295191_();
    }

    public void m_292855_(SampleLogger p_300126_) {
        this.f_291520_ = new BandwidthDebugMonitor(p_300126_);
    }

    public SocketAddress getRawAddress() {
        return this.f_129468_.remoteAddress();
    }

    private /* synthetic */ void m_202558_(Component p_202559_) {
        this.m_129507_(p_202559_);
    }
}

