/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.apache.commons.lang3.ObjectUtils;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.slf4j.Logger;

public class SynchedEntityData {
    private static final Logger f_135342_ = LogUtils.getLogger();
    private static final Object2IntMap<Class<? extends net.minecraft.world.entity.Entity>> f_135343_ = new Object2IntOpenHashMap();
    private static final int f_179843_ = 254;
    private final net.minecraft.world.entity.Entity f_135344_;
    private final Int2ObjectMap<DataItem<?>> f_135345_ = new Int2ObjectOpenHashMap();
    private final ReadWriteLock f_135346_ = new ReentrantReadWriteLock();
    private boolean f_135348_;

    public SynchedEntityData(net.minecraft.world.entity.Entity p_135351_) {
        this.f_135344_ = p_135351_;
    }

    public static <T> EntityDataAccessor<T> m_135353_(Class<? extends net.minecraft.world.entity.Entity> p_135354_, EntityDataSerializer<T> p_135355_) {
        int j;
        if (f_135342_.isDebugEnabled()) {
            try {
                Class<?> oclass = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!oclass.equals(p_135354_)) {
                    f_135342_.debug("defineId called for: {} from {}", new Object[]{p_135354_, oclass, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException oclass) {
                // empty catch block
            }
        }
        if (f_135343_.containsKey(p_135354_)) {
            j = f_135343_.getInt(p_135354_) + 1;
        } else {
            int i = 0;
            Class<? extends net.minecraft.world.entity.Entity> oclass1 = p_135354_;
            while (oclass1 != net.minecraft.world.entity.Entity.class) {
                if (!f_135343_.containsKey(oclass1 = oclass1.getSuperclass())) continue;
                i = f_135343_.getInt(oclass1) + 1;
                break;
            }
            j = i;
        }
        if (j > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + j + "! (Max is 254)");
        }
        f_135343_.put(p_135354_, j);
        return p_135355_.m_135021_(j);
    }

    public <T> void m_135372_(EntityDataAccessor<T> p_135373_, T p_135374_) {
        int i = p_135373_.m_135015_();
        if (i > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i + "! (Max is 254)");
        }
        if (this.f_135345_.containsKey(i)) {
            throw new IllegalArgumentException("Duplicate id value for " + i + "!");
        }
        if (EntityDataSerializers.m_135052_(p_135373_.m_135016_()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + p_135373_.m_135016_() + " for " + i + "!");
        }
        this.m_135385_(p_135373_, p_135374_);
    }

    private <T> void m_135385_(EntityDataAccessor<T> p_135386_, T p_135387_) {
        DataItem<T> dataitem = new DataItem<T>(p_135386_, p_135387_);
        this.f_135346_.writeLock().lock();
        this.f_135345_.put(p_135386_.m_135015_(), dataitem);
        this.f_135346_.writeLock().unlock();
    }

    public <T> boolean m_285897_(EntityDataAccessor<T> p_286294_) {
        return this.f_135345_.containsKey(p_286294_.m_135015_());
    }

    private <T> DataItem<T> m_135379_(EntityDataAccessor<T> p_135380_) {
        DataItem dataitem;
        this.f_135346_.readLock().lock();
        try {
            dataitem = (DataItem)this.f_135345_.get(p_135380_.m_135015_());
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, "Getting synched entity data");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Synched entity data");
            crashreportcategory.m_128159_("Data ID", p_135380_);
            throw new ReportedException(crashreport);
        }
        finally {
            this.f_135346_.readLock().unlock();
        }
        return dataitem;
    }

    public <T> T m_135370_(EntityDataAccessor<T> p_135371_) {
        return this.m_135379_(p_135371_).m_135403_();
    }

    public <T> void m_135381_(EntityDataAccessor<T> p_135382_, T p_135383_) {
        this.m_276349_(p_135382_, p_135383_, false);
    }

    public <T> void m_276349_(EntityDataAccessor<T> p_276368_, T p_276363_, boolean p_276370_) {
        net.minecraft.world.entity.Entity entity;
        if (p_276368_ == LivingEntity.f_20961_ && (entity = this.f_135344_) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (serverPlayer.initialized) {
                CraftPlayer player = serverPlayer.getBukkitEntity();
                player.setRealHealth((double)((Float)p_276363_).floatValue());
            }
        }
        DataItem<T> dataitem = this.m_135379_(p_276368_);
        if (p_276370_ || ObjectUtils.notEqual(p_276363_, dataitem.m_135403_())) {
            dataitem.m_135397_(p_276363_);
            this.f_135344_.m_7350_(p_276368_);
            dataitem.m_135401_(true);
            this.f_135348_ = true;
        }
    }

    public boolean m_135352_() {
        return this.f_135348_;
    }

    @Nullable
    public List<DataValue<?>> m_135378_() {
        ArrayList list = null;
        if (this.f_135348_) {
            this.f_135346_.readLock().lock();
            for (DataItem dataitem : this.f_135345_.values()) {
                if (!dataitem.m_135406_()) continue;
                dataitem.m_135401_(false);
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(dataitem.m_253123_());
            }
            this.f_135346_.readLock().unlock();
        }
        this.f_135348_ = false;
        return list;
    }

    @Nullable
    public List<DataValue<?>> m_252804_() {
        ArrayList list = null;
        this.f_135346_.readLock().lock();
        for (DataItem dataitem : this.f_135345_.values()) {
            if (dataitem.m_252838_()) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(dataitem.m_253123_());
        }
        this.f_135346_.readLock().unlock();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_135356_(List<DataValue<?>> p_135357_) {
        this.f_135346_.writeLock().lock();
        try {
            for (DataValue<?> datavalue : p_135357_) {
                DataItem dataitem = (DataItem)this.f_135345_.get(datavalue.f_252469_);
                if (dataitem == null) continue;
                this.m_135375_(dataitem, datavalue);
                this.f_135344_.m_7350_(dataitem.m_135396_());
            }
        }
        finally {
            this.f_135346_.writeLock().unlock();
        }
        this.f_135344_.m_269505_(p_135357_);
    }

    private <T> void m_135375_(DataItem<T> p_135376_, DataValue<?> p_254484_) {
        if (!Objects.equals(p_254484_.f_252511_(), p_135376_.f_135390_.m_135016_())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", p_135376_.f_135390_.m_135015_(), this.f_135344_, p_135376_.f_135391_, p_135376_.f_135391_.getClass(), p_254484_.f_252525_, p_254484_.f_252525_.getClass()));
        }
        p_135376_.m_135397_(p_254484_.f_252525_);
    }

    public boolean m_135388_() {
        return this.f_135345_.isEmpty();
    }

    public <T> void markDirty(EntityDataAccessor<T> datawatcherobject) {
        this.m_135379_(datawatcherobject).m_135401_(true);
        this.f_135348_ = true;
    }

    public void refresh(ServerPlayer to) {
        List<DataValue<?>> list;
        if (!this.m_135388_() && (list = this.m_252804_()) != null) {
            to.f_8906_.m_141995_(new ClientboundSetEntityDataPacket(this.f_135344_.m_19879_(), list));
        }
    }

    public void resendPossiblyDesyncedDataValues(List<EntityDataAccessor<?>> keys, ServerPlayer to) {
        if (!to.getBukkitEntity().canSee((Entity)this.f_135344_.getBukkitEntity())) {
            return;
        }
        ArrayList values = new ArrayList(keys.size());
        for (EntityDataAccessor<?> key : keys) {
            DataItem<?> synchedValue = this.m_135379_(key);
            values.add(synchedValue.m_253123_());
        }
        to.f_8906_.m_141995_(new ClientboundSetEntityDataPacket(this.f_135344_.m_19879_(), values));
    }

    public static class DataItem<T> {
        final EntityDataAccessor<T> f_135390_;
        T f_135391_;
        private final T f_252454_;
        private boolean f_135392_;

        public DataItem(EntityDataAccessor<T> p_135394_, T p_135395_) {
            this.f_135390_ = p_135394_;
            this.f_252454_ = p_135395_;
            this.f_135391_ = p_135395_;
        }

        public EntityDataAccessor<T> m_135396_() {
            return this.f_135390_;
        }

        public void m_135397_(T p_135398_) {
            this.f_135391_ = p_135398_;
        }

        public T m_135403_() {
            return this.f_135391_;
        }

        public boolean m_135406_() {
            return this.f_135392_;
        }

        public void m_135401_(boolean p_135402_) {
            this.f_135392_ = p_135402_;
        }

        public boolean m_252838_() {
            return this.f_252454_.equals(this.f_135391_);
        }

        public DataValue<T> m_253123_() {
            return DataValue.m_252847_(this.f_135390_, this.f_135391_);
        }
    }

    public record DataValue<T>(int f_252469_, EntityDataSerializer<T> f_252511_, T f_252525_) {
        public static <T> DataValue<T> m_252847_(EntityDataAccessor<T> p_254543_, T p_254138_) {
            EntityDataSerializer entitydataserializer = p_254543_.m_135016_();
            return new DataValue<Object>(p_254543_.m_135015_(), entitydataserializer, entitydataserializer.m_7020_(p_254138_));
        }

        public void m_252897_(FriendlyByteBuf p_253709_) {
            int i = EntityDataSerializers.m_135052_(this.f_252511_);
            if (i < 0) {
                throw new EncoderException("Unknown serializer type " + this.f_252511_);
            }
            p_253709_.writeByte(this.f_252469_);
            p_253709_.m_130130_(i);
            this.f_252511_.m_6856_(p_253709_, this.f_252525_);
        }

        public static DataValue<?> m_252860_(FriendlyByteBuf p_254314_, int p_254356_) {
            int i = p_254314_.m_130242_();
            EntityDataSerializer<?> entitydataserializer = EntityDataSerializers.m_135048_(i);
            if (entitydataserializer == null) {
                throw new DecoderException("Unknown serializer type " + i);
            }
            return DataValue.m_252951_(p_254314_, p_254356_, entitydataserializer);
        }

        private static <T> DataValue<T> m_252951_(FriendlyByteBuf p_254224_, int p_253899_, EntityDataSerializer<T> p_254222_) {
            return new DataValue<Object>(p_253899_, p_254222_, p_254222_.m_6709_(p_254224_));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DataValue.class, "id;serializer;value", "f_252469_", "f_252511_", "f_252525_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DataValue.class, "id;serializer;value", "f_252469_", "f_252511_", "f_252525_"}, this);
        }

        @Override
        public final boolean equals(Object p_253935_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DataValue.class, "id;serializer;value", "f_252469_", "f_252511_", "f_252525_"}, this, p_253935_);
        }
    }
}

