/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import net.minecraft.SharedConstants;
import net.minecraftforge.gametest.ForgeGameTestHooks;
import org.slf4j.Logger;

public class Eula {
    private static final Logger f_135938_ = LogUtils.getLogger();
    private final Path f_135939_;
    private final boolean f_135940_;

    public Eula(Path p_135943_) {
        this.f_135939_ = p_135943_;
        this.f_135940_ = SharedConstants.f_136183_ || ForgeGameTestHooks.isGametestServer() || this.readFile(p_135943_);
    }

    private boolean globalEula() {
        File globalEula = new File(System.getProperty("user.home"), "eula.txt");
        if (globalEula.exists()) {
            System.out.println("Loaded global eula file from " + globalEula.getAbsolutePath());
            return this.readFile(globalEula.toPath());
        }
        System.out.println("No global eula file found at " + globalEula.getAbsolutePath());
        return false;
    }

    private boolean readFile(Path path) {
        boolean bl;
        block8: {
            InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
            try {
                Properties properties = new Properties();
                properties.load(inputstream);
                bl = Boolean.parseBoolean(properties.getProperty("eula", "false"));
                if (inputstream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    f_135938_.warn("Failed to load {}", (Object)this.f_135939_);
                    this.m_135946_();
                    return false;
                }
            }
            inputstream.close();
        }
        return bl;
    }

    public boolean m_135944_() {
        return this.f_135940_;
    }

    private void m_135946_() {
        if (!SharedConstants.f_136183_) {
            try (OutputStream outputstream = Files.newOutputStream(this.f_135939_, new OpenOption[0]);){
                Properties properties = new Properties();
                properties.setProperty("eula", "false");
                properties.store(outputstream, "By changing the setting below to TRUE you are indicating your agreement to our EULA (https://aka.ms/MinecraftEULA).");
            }
            catch (Exception exception) {
                f_135938_.warn("Failed to save {}", (Object)this.f_135939_, (Object)exception);
            }
        }
    }
}

