/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.commands.Commands;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraftforge.registries.DataPackRegistriesHooks;
import org.slf4j.Logger;

public class WorldLoader {
    private static final Logger f_244206_ = LogUtils.getLogger();

    public static <D, R> CompletableFuture<R> m_214362_(InitConfig p_214363_, WorldDataSupplier<D> p_214364_, ResultFactory<D, R> p_214365_, Executor p_214366_, Executor p_214367_) {
        try {
            Pair<WorldDataConfiguration, CloseableResourceManager> pair = p_214363_.f_214378_.m_214399_();
            CloseableResourceManager closeableresourcemanager = (CloseableResourceManager)pair.getSecond();
            LayeredRegistryAccess layeredregistryaccess = RegistryLayer.m_245849_();
            LayeredRegistryAccess<RegistryLayer> layeredregistryaccess1 = WorldLoader.m_245736_((ResourceManager)closeableresourcemanager, (LayeredRegistryAccess<RegistryLayer>)layeredregistryaccess, RegistryLayer.WORLDGEN, DataPackRegistriesHooks.getDataPackRegistries());
            RegistryAccess.Frozen registryaccess$frozen = layeredregistryaccess1.m_246035_((Object)RegistryLayer.DIMENSIONS);
            RegistryAccess.Frozen registryaccess$frozen1 = RegistryDataLoader.m_247207_((ResourceManager)closeableresourcemanager, (RegistryAccess)registryaccess$frozen, RegistryDataLoader.f_244547_);
            WorldDataConfiguration worlddataconfiguration = (WorldDataConfiguration)pair.getFirst();
            DataLoadOutput<D> dataloadoutput = p_214364_.m_214412_(new DataLoadContext((ResourceManager)closeableresourcemanager, worlddataconfiguration, registryaccess$frozen, registryaccess$frozen1));
            LayeredRegistryAccess layeredregistryaccess2 = layeredregistryaccess1.m_247705_((Object)RegistryLayer.DIMENSIONS, new RegistryAccess.Frozen[]{dataloadoutput.f_244143_});
            RegistryAccess.Frozen registryaccess$frozen2 = layeredregistryaccess2.m_246035_((Object)RegistryLayer.RELOADABLE);
            return ((CompletableFuture)ReloadableServerResources.m_247740_((ResourceManager)closeableresourcemanager, registryaccess$frozen2, worlddataconfiguration.f_243973_(), p_214363_.f_214379_(), p_214363_.f_214380_(), p_214366_, p_214367_).whenComplete((p_214370_, p_214371_) -> {
                if (p_214371_ != null) {
                    closeableresourcemanager.close();
                }
            })).thenApplyAsync(p_248101_ -> {
                p_248101_.m_206868_((RegistryAccess)registryaccess$frozen2);
                return p_214365_.m_214407_(closeableresourcemanager, (ReloadableServerResources)p_248101_, (LayeredRegistryAccess<RegistryLayer>)layeredregistryaccess2, p_248100_.f_244458_);
            }, p_214367_);
        }
        catch (Exception exception) {
            return CompletableFuture.failedFuture(exception);
        }
    }

    private static RegistryAccess.Frozen m_246152_(ResourceManager p_251529_, LayeredRegistryAccess<RegistryLayer> p_250737_, RegistryLayer p_250790_, List<RegistryDataLoader.RegistryData<?>> p_249516_) {
        RegistryAccess.Frozen registryaccess$frozen = p_250737_.m_246035_((Object)p_250790_);
        return RegistryDataLoader.m_247207_(p_251529_, (RegistryAccess)registryaccess$frozen, p_249516_);
    }

    public static LayeredRegistryAccess<RegistryLayer> m_245736_(ResourceManager p_249913_, LayeredRegistryAccess<RegistryLayer> p_252077_, RegistryLayer p_250346_, List<RegistryDataLoader.RegistryData<?>> p_250589_) {
        RegistryAccess.Frozen registryaccess$frozen = WorldLoader.m_246152_(p_249913_, p_252077_, p_250346_, p_250589_);
        return p_252077_.m_247705_((Object)p_250346_, new RegistryAccess.Frozen[]{registryaccess$frozen});
    }

    public record InitConfig(PackConfig f_214378_, Commands.CommandSelection f_214379_, int f_214380_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{InitConfig.class, "packConfig;commandSelection;functionCompilationLevel", "f_214378_", "f_214379_", "f_214380_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InitConfig.class, "packConfig;commandSelection;functionCompilationLevel", "f_214378_", "f_214379_", "f_214380_"}, this);
        }

        @Override
        public final boolean equals(Object p_214389_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InitConfig.class, "packConfig;commandSelection;functionCompilationLevel", "f_214378_", "f_214379_", "f_214380_"}, this, p_214389_);
        }
    }

    public record PackConfig(PackRepository f_214392_, WorldDataConfiguration f_244366_, boolean f_214394_, boolean f_244133_) {
        public Pair<WorldDataConfiguration, CloseableResourceManager> m_214399_() {
            FeatureFlagSet featureflagset = this.f_244133_ ? FeatureFlags.f_244280_.m_247355_() : this.f_244366_.f_243973_();
            WorldDataConfiguration worlddataconfiguration = MinecraftServer.m_246048_(this.f_214392_, this.f_244366_.f_244096_(), this.f_214394_, featureflagset);
            if (!this.f_244133_) {
                worlddataconfiguration = worlddataconfiguration.m_245801_(this.f_244366_.f_243973_());
            }
            List<PackResources> list = this.f_214392_.m_10525_();
            MultiPackResourceManager closeableresourcemanager = new MultiPackResourceManager(PackType.SERVER_DATA, list);
            return Pair.of((Object)worlddataconfiguration, (Object)closeableresourcemanager);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PackConfig.class, "packRepository;initialDataConfig;safeMode;initMode", "f_214392_", "f_244366_", "f_214394_", "f_244133_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PackConfig.class, "packRepository;initialDataConfig;safeMode;initMode", "f_214392_", "f_244366_", "f_214394_", "f_244133_"}, this);
        }

        @Override
        public final boolean equals(Object p_214404_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PackConfig.class, "packRepository;initialDataConfig;safeMode;initMode", "f_214392_", "f_244366_", "f_214394_", "f_244133_"}, this, p_214404_);
        }
    }

    public record DataLoadContext(ResourceManager f_244187_, WorldDataConfiguration f_244127_, RegistryAccess.Frozen f_244104_, RegistryAccess.Frozen f_243759_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DataLoadContext.class, "resources;dataConfiguration;datapackWorldgen;datapackDimensions", "f_244187_", "f_244127_", "f_244104_", "f_243759_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DataLoadContext.class, "resources;dataConfiguration;datapackWorldgen;datapackDimensions", "f_244187_", "f_244127_", "f_244104_", "f_243759_"}, this);
        }

        @Override
        public final boolean equals(Object p_250459_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DataLoadContext.class, "resources;dataConfiguration;datapackWorldgen;datapackDimensions", "f_244187_", "f_244127_", "f_244104_", "f_243759_"}, this, p_250459_);
        }
    }

    @FunctionalInterface
    public static interface WorldDataSupplier<D> {
        public DataLoadOutput<D> m_214412_(DataLoadContext var1);
    }

    public record DataLoadOutput<D>(D f_244458_, RegistryAccess.Frozen f_244143_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DataLoadOutput.class, "cookie;finalDimensions", "f_244458_", "f_244143_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DataLoadOutput.class, "cookie;finalDimensions", "f_244458_", "f_244143_"}, this);
        }

        @Override
        public final boolean equals(Object p_250694_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DataLoadOutput.class, "cookie;finalDimensions", "f_244458_", "f_244143_"}, this, p_250694_);
        }
    }

    @FunctionalInterface
    public static interface ResultFactory<D, R> {
        public R m_214407_(CloseableResourceManager var1, ReloadableServerResources var2, LayeredRegistryAccess<RegistryLayer> var3, D var4);
    }
}

