/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Locale;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.network.LegacyProtocolUtils;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.event.server.ServerListPingEvent;
import org.slf4j.Logger;

public class LegacyQueryHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger f_9675_ = LogUtils.getLogger();
    private final ServerInfo f_291585_;

    public LegacyQueryHandler(ServerInfo p_298392_) {
        this.f_291585_ = p_298392_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext p_9686_, Object p_9687_) {
        ByteBuf bytebuf = (ByteBuf)p_9687_;
        bytebuf.markReaderIndex();
        boolean flag = true;
        try {
            if (bytebuf.readUnsignedByte() == 254) {
                SocketAddress socketaddress = p_9686_.channel().remoteAddress();
                int i = bytebuf.readableBytes();
                ServerListPingEvent event = CraftEventFactory.callServerListPingEvent((SocketAddress)socketaddress, (String)this.f_291585_.m_129916_(), (int)this.f_291585_.m_129787_(), (int)this.f_291585_.m_129788_());
                if (i == 0) {
                    f_9675_.debug("Ping: (<1.3.x) from {}", (Object)socketaddress);
                    String s = LegacyQueryHandler.createVersion0Response(this.f_291585_, event);
                    LegacyQueryHandler.m_9680_(p_9686_, LegacyQueryHandler.m_294988_(p_9686_.alloc(), s));
                } else {
                    if (bytebuf.readUnsignedByte() != 1) {
                        return;
                    }
                    if (bytebuf.isReadable()) {
                        if (!LegacyQueryHandler.m_294298_(bytebuf)) {
                            return;
                        }
                        f_9675_.debug("Ping: (1.6) from {}", (Object)socketaddress);
                    } else {
                        f_9675_.debug("Ping: (1.4-1.5.x) from {}", (Object)socketaddress);
                    }
                    String s1 = LegacyQueryHandler.createVersion1Response(this.f_291585_, event);
                    LegacyQueryHandler.m_9680_(p_9686_, LegacyQueryHandler.m_294988_(p_9686_.alloc(), s1));
                }
                bytebuf.release();
                flag = false;
                return;
            }
        }
        catch (RuntimeException runtimeexception) {
            return;
        }
        finally {
            if (flag) {
                bytebuf.resetReaderIndex();
                p_9686_.channel().pipeline().remove((ChannelHandler)this);
                p_9686_.fireChannelRead(p_9687_);
            }
        }
    }

    private static boolean m_294298_(ByteBuf p_297429_) {
        short short1 = p_297429_.readUnsignedByte();
        if (short1 != 250) {
            return false;
        }
        String s = LegacyProtocolUtils.m_294258_((ByteBuf)p_297429_);
        if (!"MC|PingHost".equals(s)) {
            return false;
        }
        int i = p_297429_.readUnsignedShort();
        if (p_297429_.readableBytes() != i) {
            return false;
        }
        short short2 = p_297429_.readUnsignedByte();
        if (short2 < 73) {
            return false;
        }
        String s1 = LegacyProtocolUtils.m_294258_((ByteBuf)p_297429_);
        int j = p_297429_.readInt();
        return j <= 65535;
    }

    private static String createVersion0Response(ServerInfo p_300881_, ServerListPingEvent event) {
        return String.format(Locale.ROOT, "%s\u00a7%d\u00a7%d", event.getMotd(), event.getNumPlayers(), event.getMaxPlayers());
    }

    private static String createVersion1Response(ServerInfo p_297753_, ServerListPingEvent event) {
        return String.format(Locale.ROOT, "\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", 127, p_297753_.m_129786_(), event.getMotd(), event.getNumPlayers(), event.getMaxPlayers());
    }

    private static void m_9680_(ChannelHandlerContext p_9681_, ByteBuf p_9682_) {
        p_9681_.pipeline().firstContext().writeAndFlush((Object)p_9682_).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static ByteBuf m_294988_(ByteBufAllocator p_298175_, String p_298389_) {
        ByteBuf bytebuf = p_298175_.buffer();
        bytebuf.writeByte(255);
        LegacyProtocolUtils.m_294952_((ByteBuf)bytebuf, (String)p_298389_);
        return bytebuf;
    }
}

