/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.destroystokyo.paper.event.player.PlayerUseUnknownEntityEvent;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mohistmc.bukkit.inventory.MohistModsInventory;
import com.mohistmc.plugins.ban.bans.BanItem;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.SocketAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundBlockEntityTagQuery;
import net.minecraft.network.protocol.game.ServerboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.network.protocol.game.ServerboundEntityTagQuery;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundJigsawGeneratePacket;
import net.minecraft.network.protocol.game.ServerboundLockDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.network.protocol.game.ServerboundSetBeaconPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandMinecartPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundSetJigsawBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetStructureBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ServerboundPingRequestPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.network.TextFilter;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.util.FutureChain;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.util.TaskChainer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingSwapItemsEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R2.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_20_R2.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerGamePacketListenerImpl
extends ServerCommonPacketListenerImpl
implements ServerGamePacketListener,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger f_9744_ = LogUtils.getLogger();
    @Deprecated
    public static final double f_215198_ = Mth.m_144952_((double)6.0);
    private static final int f_215199_ = -1;
    private static final int f_244471_ = 4096;
    private static final Component f_244304_ = Component.m_237115_("multiplayer.disconnect.chat_validation_failed");
    public ServerPlayer f_9743_;
    public final PlayerChunkSender f_290664_;
    private int f_9746_;
    private int f_215200_ = -1;
    private int f_9750_;
    private int f_9751_;
    private double f_9753_;
    private double f_9754_;
    private double f_9755_;
    private double f_9756_;
    private double f_9757_;
    private double f_9758_;
    @Nullable
    private net.minecraft.world.entity.Entity f_9759_;
    private double f_9760_;
    private double f_9761_;
    private double f_9762_;
    private double f_9763_;
    private double f_9764_;
    private double f_9765_;
    @Nullable
    private Vec3 f_9766_;
    private int f_9767_;
    private int f_9735_;
    private boolean f_9736_;
    private int f_9737_;
    private boolean f_9738_;
    private int f_9739_;
    private int f_9740_;
    private int f_9741_;
    private final AtomicReference<Instant> f_215197_ = new AtomicReference<Instant>(Instant.EPOCH);
    @Nullable
    private RemoteChatSession f_252494_;
    private SignedMessageChain.Decoder f_240889_;
    private final LastSeenMessagesValidator f_244262_ = new LastSeenMessagesValidator(20);
    private final MessageSignatureCache f_243718_ = MessageSignatureCache.m_246587_();
    private final FutureChain f_241681_;
    private boolean f_290343_;
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private boolean hasMoved;
    private AtomicInteger mohist$slot = new AtomicInteger(-1);
    private AtomicReference<ItemStack> mohist$handItem = new AtomicReference<Object>(null);
    private int limitedPackets;
    private long lastLimitedPacket = -1L;
    private String s = null;

    public ServerGamePacketListenerImpl(MinecraftServer p_9770_, Connection p_9771_, ServerPlayer p_9772_, CommonListenerCookie p_300908_) {
        super(p_9770_, p_9771_, p_300908_, p_9772_);
        this.f_290664_ = new PlayerChunkSender(p_9771_.m_129531_());
        p_9771_.m_129505_((PacketListener)this);
        this.f_9743_ = p_9772_;
        p_9772_.f_8906_ = this;
        p_9772_.m_8967_().m_7674_();
        this.f_240889_ = p_9770_.m_214005_() ? SignedMessageChain.Decoder.f_252472_ : SignedMessageChain.Decoder.m_246683_((UUID)p_9772_.m_20148_());
        this.f_241681_ = new FutureChain((Executor)p_9770_.chatExecutor);
    }

    @Override
    public CraftPlayer getCraftPlayer() {
        return this.f_9743_ == null ? null : this.f_9743_.getBukkitEntity();
    }

    public void m_9933_() {
        if (this.f_215200_ > -1) {
            this.m_141995_((Packet<?>)new ClientboundBlockChangedAckPacket(this.f_215200_));
            this.f_215200_ = -1;
        }
        this.m_9953_();
        this.f_9743_.f_19854_ = this.f_9743_.m_20185_();
        this.f_9743_.f_19855_ = this.f_9743_.m_20186_();
        this.f_9743_.f_19856_ = this.f_9743_.m_20189_();
        this.f_9743_.m_9240_();
        this.f_9743_.m_19890_(this.f_9753_, this.f_9754_, this.f_9755_, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
        ++this.f_9746_;
        this.f_9741_ = this.f_9740_;
        if (this.f_9736_ && !this.f_9743_.m_5803_() && !this.f_9743_.m_20159_() && !this.f_9743_.m_21224_()) {
            if (++this.f_9737_ > 80) {
                f_9744_.warn("{} was kicked for floating too long!", (Object)this.f_9743_.m_7755_().getString());
                this.m_294716_((Component)Component.m_237115_("multiplayer.disconnect.flying"));
                return;
            }
        } else {
            this.f_9736_ = false;
            this.f_9737_ = 0;
        }
        this.f_9759_ = this.f_9743_.m_20201_();
        if (this.f_9759_ != this.f_9743_ && this.f_9759_.m_6688_() == this.f_9743_) {
            this.f_9760_ = this.f_9759_.m_20185_();
            this.f_9761_ = this.f_9759_.m_20186_();
            this.f_9762_ = this.f_9759_.m_20189_();
            this.f_9763_ = this.f_9759_.m_20185_();
            this.f_9764_ = this.f_9759_.m_20186_();
            this.f_9765_ = this.f_9759_.m_20189_();
            if (this.f_9738_ && this.f_9743_.m_20201_().m_6688_() == this.f_9743_) {
                if (++this.f_9739_ > 80) {
                    f_9744_.warn("{} was kicked for floating a vehicle too long!", (Object)this.f_9743_.m_7755_().getString());
                    this.m_294716_((Component)Component.m_237115_("multiplayer.disconnect.flying"));
                    return;
                }
            } else {
                this.f_9738_ = false;
                this.f_9739_ = 0;
            }
        } else {
            this.f_9759_ = null;
            this.f_9738_ = false;
            this.f_9739_ = 0;
        }
        this.m_295188_();
        if (this.f_9750_ > 0) {
            --this.f_9750_;
        }
        if (this.f_9751_ > 0) {
            --this.f_9751_;
        }
        if (this.f_9743_.m_8956_() > 0L && this.f_291389_.m_129924_() > 0 && Util.m_137550_() - this.f_9743_.m_8956_() > (long)this.f_291389_.m_129924_() * 1000L * 60L) {
            this.f_9743_.m_9243_();
            this.m_294716_((Component)Component.m_237115_("multiplayer.disconnect.idling"));
        }
    }

    public void m_9953_() {
        this.f_9753_ = this.f_9743_.m_20185_();
        this.f_9754_ = this.f_9743_.m_20186_();
        this.f_9755_ = this.f_9743_.m_20189_();
        this.f_9756_ = this.f_9743_.m_20185_();
        this.f_9757_ = this.f_9743_.m_20186_();
        this.f_9758_ = this.f_9743_.m_20189_();
    }

    public boolean m_6198_() {
        return this.f_291338_.m_129536_() && !this.f_290343_;
    }

    public boolean m_294638_(Packet<?> p_298646_) {
        if (super.m_294638_(p_298646_)) {
            return true;
        }
        return this.f_290343_ && this.f_291338_.m_129536_() && p_298646_ instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile m_293343_() {
        return this.f_9743_.m_36316_();
    }

    private <T, R> CompletableFuture<R> m_243080_(T p_243240_, BiFunction<TextFilter, T, CompletableFuture<R>> p_243271_) {
        return p_243271_.apply(this.f_9743_.m_8967_(), (TextFilter)p_243240_).thenApply(p_264862_ -> {
            if (!this.m_6198_()) {
                f_9744_.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return p_264862_;
        });
    }

    private CompletableFuture<FilteredText> m_243132_(String p_243213_) {
        return this.m_243080_(p_243213_, TextFilter::m_6770_);
    }

    private CompletableFuture<List<FilteredText>> m_243065_(List<String> p_243258_) {
        return this.m_243080_(p_243258_, TextFilter::m_5925_);
    }

    public void m_5918_(ServerboundPlayerInputPacket p_9893_) {
        PacketUtils.m_131359_((Packet)p_9893_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        this.f_9743_.m_8980_(p_9893_.m_134355_(), p_9893_.m_134358_(), p_9893_.m_134359_(), p_9893_.m_134360_());
    }

    private static boolean m_143663_(double p_143664_, double p_143665_, double p_143666_, float p_143667_, float p_143668_) {
        return Double.isNaN(p_143664_) || Double.isNaN(p_143665_) || Double.isNaN(p_143666_) || !Floats.isFinite((float)p_143668_) || !Floats.isFinite((float)p_143667_);
    }

    private static double m_143609_(double p_143610_) {
        return Mth.m_14008_((double)p_143610_, (double)-3.0E7, (double)3.0E7);
    }

    private static double m_143653_(double p_143654_) {
        return Mth.m_14008_((double)p_143654_, (double)-2.0E7, (double)2.0E7);
    }

    public void m_5659_(ServerboundMoveVehiclePacket p_9876_) {
        PacketUtils.m_131359_((Packet)p_9876_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (ServerGamePacketListenerImpl.m_143663_(p_9876_.m_134199_(), p_9876_.m_134202_(), p_9876_.m_134203_(), p_9876_.m_134204_(), p_9876_.m_134205_())) {
            this.m_294716_((Component)Component.m_237115_("multiplayer.disconnect.invalid_vehicle_movement"));
        } else {
            net.minecraft.world.entity.Entity entity = this.f_9743_.m_20201_();
            if (entity != this.f_9743_ && entity.m_6688_() == this.f_9743_ && entity == this.f_9759_) {
                LivingEntity livingentity;
                ServerLevel serverlevel = this.f_9743_.m_284548_();
                double d0 = entity.m_20185_();
                double d1 = entity.m_20186_();
                double d2 = entity.m_20189_();
                double d3 = ServerGamePacketListenerImpl.m_143609_(p_9876_.m_134199_());
                double d4 = ServerGamePacketListenerImpl.m_143653_(p_9876_.m_134202_());
                double d5 = ServerGamePacketListenerImpl.m_143609_(p_9876_.m_134203_());
                float f = Mth.m_14177_((float)p_9876_.m_134204_());
                float f1 = Mth.m_14177_((float)p_9876_.m_134205_());
                double d6 = d3 - this.f_9760_;
                double d7 = d4 - this.f_9761_;
                double d8 = d5 - this.f_9762_;
                double d9 = entity.m_20184_().m_82556_();
                double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.f_9740_;
                int i = this.f_9740_ - this.f_9741_;
                if (i > Math.max(this.allowedPlayerTicks, 5)) {
                    f_9744_.debug(this.f_9743_.m_6302_() + " is sending move packets too frequently (" + i + " packets since last tick)");
                    i = 1;
                }
                this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.f_9743_.m_150110_().f_35935_ ? (double)(this.f_9743_.m_150110_().f_35939_ * 20.0f) : (double)(this.f_9743_.m_150110_().f_35940_ * 10.0f);
                speed *= 2.0;
                if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i * speed, 2.0)) && !this.m_293330_()) {
                    f_9744_.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.m_7755_().getString(), this.f_9743_.m_7755_().getString(), d6, d7, d8});
                    this.m_141995_((Packet<?>)new ClientboundMoveVehiclePacket(entity));
                    return;
                }
                boolean flag = serverlevel.m_45756_(entity, entity.m_20191_().m_82406_(0.0625));
                d6 = d3 - this.f_9763_;
                d7 = d4 - this.f_9764_ - 1.0E-6;
                d8 = d5 - this.f_9765_;
                boolean flag1 = entity.f_201939_;
                if (entity instanceof LivingEntity && (livingentity = (LivingEntity)entity).m_6147_()) {
                    livingentity.m_183634_();
                }
                entity.m_6478_(MoverType.PLAYER, new Vec3(d6, d7, d8));
                d6 = d3 - entity.m_20185_();
                d7 = d4 - entity.m_20186_();
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.m_20189_();
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag2 = false;
                if (d10 > SpigotConfig.movedWronglyThreshold) {
                    flag2 = true;
                    f_9744_.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{entity.m_7755_().getString(), this.f_9743_.m_7755_().getString(), Math.sqrt(d10)});
                }
                Location curPos = this.getCraftPlayer().getLocation();
                entity.m_19890_(d3, d4, d5, f, f1);
                this.f_9743_.m_19890_(d3, d4, d5, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
                boolean flag3 = serverlevel.m_45756_(entity, entity.m_20191_().m_82406_(0.0625));
                if (flag && (flag2 || !flag3)) {
                    entity.m_19890_(d0, d1, d2, f, f1);
                    this.f_9743_.m_19890_(d3, d4, d5, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
                    this.m_141995_((Packet<?>)new ClientboundMoveVehiclePacket(entity));
                    return;
                }
                CraftPlayer player = this.getCraftPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = curPos.getX();
                    this.lastPosY = curPos.getY();
                    this.lastPosZ = curPos.getZ();
                    this.lastYaw = curPos.getYaw();
                    this.lastPitch = curPos.getPitch();
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = player.getLocation().clone();
                to.setX(p_9876_.m_134199_());
                to.setY(p_9876_.m_134202_());
                to.setZ(p_9876_.m_134203_());
                to.setYaw(p_9876_.m_134204_());
                to.setPitch(p_9876_.m_134205_());
                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f_9743_.m_6107_()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    if (from.getX() != Double.MAX_VALUE) {
                        Location oldTo = to.clone();
                        PlayerMoveEvent event = new PlayerMoveEvent((org.bukkit.entity.Player)player, from, to);
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            this.teleport(from);
                            return;
                        }
                        if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                            this.f_9743_.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                            return;
                        }
                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                            this.justTeleported = false;
                            return;
                        }
                    }
                }
                this.f_9743_.m_284548_().m_7726_().m_8385_(this.f_9743_);
                this.f_9743_.m_36378_(this.f_9743_.m_20185_() - d0, this.f_9743_.m_20186_() - d1, this.f_9743_.m_20189_() - d2);
                this.f_9738_ = d7 >= -0.03125 && !flag1 && !this.f_291389_.m_129915_() && !entity.m_20068_() && this.m_9793_(entity);
                this.f_9763_ = entity.m_20185_();
                this.f_9764_ = entity.m_20186_();
                this.f_9765_ = entity.m_20189_();
            }
        }
    }

    private boolean m_9793_(net.minecraft.world.entity.Entity p_9794_) {
        return p_9794_.m_9236_().m_45556_(p_9794_.m_20191_().m_82400_(0.0625).m_82363_(0.0, -0.55, 0.0)).allMatch(BlockBehaviour.BlockStateBase::m_60795_);
    }

    public void m_7376_(ServerboundAcceptTeleportationPacket p_9835_) {
        PacketUtils.m_131359_((Packet)p_9835_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (p_9835_.m_133795_() == this.f_9767_) {
            if (this.f_9766_ == null) {
                this.m_294716_((Component)Component.m_237115_("multiplayer.disconnect.invalid_player_movement"));
                return;
            }
            this.f_9743_.m_19890_(this.f_9766_.f_82479_, this.f_9766_.f_82480_, this.f_9766_.f_82481_, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
            this.f_9756_ = this.f_9766_.f_82479_;
            this.f_9757_ = this.f_9766_.f_82480_;
            this.f_9758_ = this.f_9766_.f_82481_;
            if (this.f_9743_.m_8958_()) {
                this.f_9743_.m_8959_();
            }
            this.f_9766_ = null;
            this.f_9743_.m_284548_().m_7726_().m_8385_(this.f_9743_);
        }
    }

    public void m_7411_(ServerboundRecipeBookSeenRecipePacket p_9897_) {
        PacketUtils.m_131359_((Packet)p_9897_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        this.f_291389_.m_129894_().m_44043_(p_9897_.m_134390_()).ifPresent(arg_0 -> ((ServerRecipeBook)this.f_9743_.m_8952_()).m_12721_(arg_0));
    }

    public void m_7982_(ServerboundRecipeBookChangeSettingsPacket p_9895_) {
        PacketUtils.m_131359_((Packet)p_9895_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        CraftEventFactory.callRecipeBookSettingsEvent((ServerPlayer)this.f_9743_, (RecipeBookType)p_9895_.m_134375_(), (boolean)p_9895_.m_134378_(), (boolean)p_9895_.m_134379_());
        this.f_9743_.m_8952_().m_12696_(p_9895_.m_134375_(), p_9895_.m_134378_(), p_9895_.m_134379_());
    }

    public void m_6947_(ServerboundSeenAdvancementsPacket p_9903_) {
        PacketUtils.m_131359_((Packet)p_9903_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (p_9903_.m_134447_() == ServerboundSeenAdvancementsPacket.Action.OPENED_TAB) {
            ResourceLocation resourcelocation = Objects.requireNonNull(p_9903_.m_134448_());
            AdvancementHolder advancementholder = this.f_291389_.m_129889_().m_294099_(resourcelocation);
            if (advancementholder != null) {
                this.f_9743_.m_8960_().m_135983_(advancementholder);
            }
        }
    }

    public void m_7741_(ServerboundCommandSuggestionPacket p_9847_) {
        PacketUtils.m_131359_((Packet)p_9847_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        StringReader stringreader = new StringReader(p_9847_.m_133904_());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        ParseResults parseresults = this.f_291389_.m_129892_().m_82094_().parse(stringreader, (Object)this.f_9743_.m_20203_());
        this.f_291389_.m_129892_().m_82094_().getCompletionSuggestions(parseresults).thenAccept(p_296597_ -> {
            if (p_296597_.isEmpty()) {
                return;
            }
            this.m_141995_((Packet<?>)new ClientboundCommandSuggestionsPacket(p_9847_.m_133901_(), p_296597_));
        });
    }

    public void m_7192_(ServerboundSetCommandBlockPacket p_9911_) {
        PacketUtils.m_131359_((Packet)p_9911_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (!this.f_291389_.m_6993_()) {
            this.f_9743_.m_213846_((Component)Component.m_237115_("advMode.notEnabled"));
        } else if (!this.f_9743_.m_36337_()) {
            this.f_9743_.m_213846_((Component)Component.m_237115_("advMode.notAllowed"));
        } else {
            BaseCommandBlock basecommandblock = null;
            CommandBlockEntity commandblockentity = null;
            BlockPos blockpos = p_9911_.m_134521_();
            BlockEntity blockentity = this.f_9743_.m_9236_().m_7702_(blockpos);
            if (blockentity instanceof CommandBlockEntity) {
                commandblockentity = (CommandBlockEntity)blockentity;
                basecommandblock = commandblockentity.m_59141_();
            }
            String s = p_9911_.m_134524_();
            boolean flag = p_9911_.m_134525_();
            if (basecommandblock != null) {
                CommandBlockEntity.Mode commandblockentity$mode = commandblockentity.m_59148_();
                BlockState blockstate = this.f_9743_.m_9236_().m_8055_(blockpos);
                Direction direction = (Direction)blockstate.m_61143_((Property)CommandBlock.f_51793_);
                BlockState blockstate2 = (BlockState)((Object)((BlockState)((Object)(switch (p_9911_.m_134528_()) {
                    case CommandBlockEntity.Mode.SEQUENCE -> Blocks.f_50448_.m_49966_();
                    case CommandBlockEntity.Mode.AUTO -> Blocks.f_50447_.m_49966_();
                    default -> Blocks.f_50272_.m_49966_();
                }).m_61124_((Property)CommandBlock.f_51793_, (Comparable)direction))).m_61124_((Property)CommandBlock.f_51794_, Boolean.valueOf(p_9911_.m_134526_())));
                if (blockstate2 != blockstate) {
                    this.f_9743_.m_9236_().m_7731_(blockpos, blockstate2, 2);
                    blockentity.m_155250_(blockstate2);
                    this.f_9743_.m_9236_().m_46745_(blockpos).m_142169_(blockentity);
                }
                basecommandblock.m_6590_(s);
                basecommandblock.m_45428_(flag);
                if (!flag) {
                    basecommandblock.m_45433_(null);
                }
                commandblockentity.m_59137_(p_9911_.m_134527_());
                if (commandblockentity$mode != p_9911_.m_134528_()) {
                    commandblockentity.m_59144_();
                }
                basecommandblock.m_7368_();
                if (!StringUtil.m_14408_((String)s)) {
                    this.f_9743_.m_213846_((Component)Component.m_237110_("advMode.setCommand.success", s));
                }
            }
        }
    }

    public void m_6629_(ServerboundSetCommandMinecartPacket p_9913_) {
        PacketUtils.m_131359_((Packet)p_9913_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (!this.f_291389_.m_6993_()) {
            this.f_9743_.m_213846_((Component)Component.m_237115_("advMode.notEnabled"));
        } else if (!this.f_9743_.m_36337_()) {
            this.f_9743_.m_213846_((Component)Component.m_237115_("advMode.notAllowed"));
        } else {
            BaseCommandBlock basecommandblock = p_9913_.m_134537_(this.f_9743_.m_9236_());
            if (basecommandblock != null) {
                basecommandblock.m_6590_(p_9913_.m_134545_());
                basecommandblock.m_45428_(p_9913_.m_134548_());
                if (!p_9913_.m_134548_()) {
                    basecommandblock.m_45433_(null);
                }
                basecommandblock.m_7368_();
                this.f_9743_.m_213846_((Component)Component.m_237110_("advMode.setCommand.success", p_9913_.m_134545_()));
            }
        }
    }

    public void m_7965_(ServerboundPickItemPacket p_9880_) {
        PacketUtils.m_131359_((Packet)p_9880_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        this.f_9743_.m_150109_().m_36038_(p_9880_.m_134232_());
        this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(-2, 0, this.f_9743_.m_150109_().f_35977_, this.f_9743_.m_150109_().m_8020_(this.f_9743_.m_150109_().f_35977_)));
        this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(-2, 0, p_9880_.m_134232_(), this.f_9743_.m_150109_().m_8020_(p_9880_.m_134232_())));
        this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundSetCarriedItemPacket(this.f_9743_.m_150109_().f_35977_));
    }

    public void m_5591_(ServerboundRenameItemPacket p_9899_) {
        PacketUtils.m_131359_((Packet)p_9899_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        AbstractContainerMenu abstractcontainermenu = this.f_9743_.f_36096_;
        if (abstractcontainermenu instanceof AnvilMenu) {
            AnvilMenu anvilmenu = (AnvilMenu)abstractcontainermenu;
            if (!anvilmenu.m_6875_(this.f_9743_)) {
                f_9744_.debug("Player {} interacted with invalid menu {}", (Object)this.f_9743_, (Object)anvilmenu);
                return;
            }
            anvilmenu.m_39020_(p_9899_.m_134403_());
        }
    }

    public void m_5712_(ServerboundSetBeaconPacket p_9907_) {
        PacketUtils.m_131359_((Packet)p_9907_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        AbstractContainerMenu abstractcontainermenu = this.f_9743_.f_36096_;
        if (abstractcontainermenu instanceof BeaconMenu) {
            BeaconMenu beaconmenu = (BeaconMenu)abstractcontainermenu;
            if (!this.f_9743_.f_36096_.m_6875_(this.f_9743_)) {
                f_9744_.debug("Player {} interacted with invalid menu {}", (Object)this.f_9743_, (Object)this.f_9743_.f_36096_);
                return;
            }
            beaconmenu.m_219972_(p_9907_.m_237994_(), p_9907_.m_238000_());
        }
    }

    public void m_7424_(ServerboundSetStructureBlockPacket p_9919_) {
        PacketUtils.m_131359_((Packet)p_9919_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_36337_()) {
            BlockPos blockpos = p_9919_.m_134629_();
            BlockState blockstate = this.f_9743_.m_9236_().m_8055_(blockpos);
            BlockEntity blockentity = this.f_9743_.m_9236_().m_7702_(blockpos);
            if (blockentity instanceof StructureBlockEntity) {
                StructureBlockEntity structureblockentity = (StructureBlockEntity)blockentity;
                structureblockentity.m_59860_(p_9919_.m_134633_());
                structureblockentity.m_59868_(p_9919_.m_134634_());
                structureblockentity.m_59885_(p_9919_.m_134635_());
                structureblockentity.m_155797_(p_9919_.m_179787_());
                structureblockentity.m_59881_(p_9919_.m_134637_());
                structureblockentity.m_59883_(p_9919_.m_134638_());
                structureblockentity.m_59887_(p_9919_.m_134639_());
                structureblockentity.m_59876_(p_9919_.m_134640_());
                structureblockentity.m_59896_(p_9919_.m_134641_());
                structureblockentity.m_59898_(p_9919_.m_134642_());
                structureblockentity.m_59838_(p_9919_.m_134643_());
                structureblockentity.m_59840_(p_9919_.m_134644_());
                if (structureblockentity.m_59901_()) {
                    String s = structureblockentity.m_59895_();
                    if (p_9919_.m_134632_() == StructureBlockEntity.UpdateType.SAVE_AREA) {
                        if (structureblockentity.m_59830_()) {
                            this.f_9743_.m_5661_((Component)Component.m_237110_("structure_block.save_success", s), false);
                        } else {
                            this.f_9743_.m_5661_((Component)Component.m_237110_("structure_block.save_failure", s), false);
                        }
                    } else if (p_9919_.m_134632_() == StructureBlockEntity.UpdateType.LOAD_AREA) {
                        if (!structureblockentity.m_59832_()) {
                            this.f_9743_.m_5661_((Component)Component.m_237110_("structure_block.load_not_found", s), false);
                        } else if (structureblockentity.m_59842_(this.f_9743_.m_284548_())) {
                            this.f_9743_.m_5661_((Component)Component.m_237110_("structure_block.load_success", s), false);
                        } else {
                            this.f_9743_.m_5661_((Component)Component.m_237110_("structure_block.load_prepare", s), false);
                        }
                    } else if (p_9919_.m_134632_() == StructureBlockEntity.UpdateType.SCAN_AREA) {
                        if (structureblockentity.m_59829_()) {
                            this.f_9743_.m_5661_((Component)Component.m_237110_("structure_block.size_success", s), false);
                        } else {
                            this.f_9743_.m_5661_((Component)Component.m_237115_("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.f_9743_.m_5661_((Component)Component.m_237110_("structure_block.invalid_structure_name", p_9919_.m_134634_()), false);
                }
                structureblockentity.m_6596_();
                this.f_9743_.m_9236_().m_7260_(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public void m_8019_(ServerboundSetJigsawBlockPacket p_9917_) {
        PacketUtils.m_131359_((Packet)p_9917_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_36337_()) {
            BlockPos blockpos = p_9917_.m_134585_();
            BlockState blockstate = this.f_9743_.m_9236_().m_8055_(blockpos);
            BlockEntity blockentity = this.f_9743_.m_9236_().m_7702_(blockpos);
            if (blockentity instanceof JigsawBlockEntity) {
                JigsawBlockEntity jigsawblockentity = (JigsawBlockEntity)blockentity;
                jigsawblockentity.m_59435_(p_9917_.m_134588_());
                jigsawblockentity.m_59438_(p_9917_.m_134589_());
                jigsawblockentity.m_222763_(ResourceKey.m_135785_(Registries.f_256948_, p_9917_.m_134590_()));
                jigsawblockentity.m_59431_(p_9917_.m_134591_());
                jigsawblockentity.m_59424_(p_9917_.m_134592_());
                jigsawblockentity.m_6596_();
                this.f_9743_.m_9236_().m_7260_(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public void m_6449_(ServerboundJigsawGeneratePacket p_9868_) {
        PacketUtils.m_131359_((Packet)p_9868_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_36337_()) {
            BlockPos blockpos = p_9868_.m_134087_();
            BlockEntity blockentity = this.f_9743_.m_9236_().m_7702_(blockpos);
            if (blockentity instanceof JigsawBlockEntity) {
                JigsawBlockEntity jigsawblockentity = (JigsawBlockEntity)blockentity;
                jigsawblockentity.m_59420_(this.f_9743_.m_284548_(), p_9868_.m_134090_(), p_9868_.m_134091_());
            }
        }
    }

    public void m_6321_(ServerboundSelectTradePacket p_9905_) {
        PacketUtils.m_131359_((Packet)p_9905_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        int i = p_9905_.m_134469_();
        AbstractContainerMenu abstractcontainermenu = this.f_9743_.f_36096_;
        if (abstractcontainermenu instanceof MerchantMenu) {
            MerchantMenu merchantmenu = (MerchantMenu)abstractcontainermenu;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent((ServerPlayer)this.f_9743_, (int)i, (MerchantMenu)merchantmenu);
            if (tradeSelectEvent.isCancelled()) {
                this.f_9743_.getBukkitEntity().updateInventory();
                return;
            }
            if (!merchantmenu.m_6875_(this.f_9743_)) {
                f_9744_.debug("Player {} interacted with invalid menu {}", (Object)this.f_9743_, (Object)merchantmenu);
                return;
            }
            merchantmenu.m_40063_(i);
            merchantmenu.m_40072_(i);
        }
    }

    public void m_6829_(ServerboundEditBookPacket p_9862_) {
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.disconnect("Book edited too quickly!");
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i = p_9862_.m_134013_();
        if (net.minecraft.world.entity.player.Inventory.m_36045_(i) || i == 40) {
            ArrayList list = Lists.newArrayList();
            Optional optional = p_9862_.m_182761_();
            optional.ifPresent(list::add);
            p_9862_.m_182755_().stream().limit(100L).forEach(list::add);
            Consumer<List> consumer = optional.isPresent() ? p_238198_ -> this.m_215208_((FilteredText)p_238198_.get(0), p_238198_.subList(1, p_238198_.size()), i) : p_143627_ -> this.m_9812_((List<FilteredText>)p_143627_, i);
            this.m_243065_(list).thenAcceptAsync(consumer, (Executor)((Object)this.f_291389_));
        }
    }

    private void m_9812_(List<FilteredText> p_9813_, int p_9814_) {
        ItemStack itemstack = this.f_9743_.m_150109_().m_8020_(p_9814_);
        if (itemstack.m_150930_(Items.f_42614_)) {
            this.mohist$slot.set(p_9814_);
            this.mohist$handItem.set(itemstack);
            this.m_143634_(p_9813_, UnaryOperator.identity(), itemstack);
        }
    }

    private void m_215208_(FilteredText p_215209_, List<FilteredText> p_215210_, int p_215211_) {
        ItemStack itemstack = this.f_9743_.m_150109_().m_8020_(p_215211_);
        if (itemstack.m_150930_(Items.f_42614_)) {
            ItemStack itemstack1 = new ItemStack(Items.f_42615_);
            CompoundTag compoundtag = itemstack.m_41783_();
            if (compoundtag != null) {
                itemstack1.m_41751_(compoundtag.m_6426_());
            }
            itemstack1.m_41700_("author", StringTag.m_129297_(this.f_9743_.m_7755_().getString()));
            if (this.f_9743_.m_143387_()) {
                itemstack1.m_41700_("title", StringTag.m_129297_(p_215209_.m_243113_()));
            } else {
                itemstack1.m_41700_("filtered_title", StringTag.m_129297_(p_215209_.m_243113_()));
                itemstack1.m_41700_("title", StringTag.m_129297_(p_215209_.f_215168_()));
            }
            this.mohist$slot.set(p_215211_);
            this.mohist$handItem.set(itemstack);
            this.m_143634_(p_215210_, p_238206_ -> Component.Serializer.m_130703_((Component)Component.m_237113_(p_238206_)), itemstack1);
            this.f_9743_.m_150109_().m_6836_(p_215211_, itemstack);
        }
    }

    private void updateBookPages(List<FilteredText> pPages, UnaryOperator<String> pUpdater, ItemStack pBook, int slot, ItemStack handItem) {
        this.mohist$slot.set(slot);
        this.mohist$handItem.set(handItem);
        this.m_143634_(pPages, pUpdater, pBook);
    }

    private void m_143634_(List<FilteredText> p_143635_, UnaryOperator<String> p_143636_, ItemStack p_143637_) {
        ListTag listtag = new ListTag();
        if (this.f_9743_.m_143387_()) {
            p_143635_.stream().map(p_238209_ -> StringTag.m_129297_((String)p_143636_.apply(p_238209_.m_243113_()))).forEach(arg_0 -> listtag.add(arg_0));
        } else {
            CompoundTag compoundtag = new CompoundTag();
            int j = p_143635_.size();
            for (int i = 0; i < j; ++i) {
                FilteredText filteredtext = p_143635_.get(i);
                String s = filteredtext.f_215168_();
                listtag.add((Object)StringTag.m_129297_((String)p_143636_.apply(s)));
                if (!filteredtext.m_215174_()) continue;
                compoundtag.m_128359_(String.valueOf(i), (String)p_143636_.apply(filteredtext.m_243113_()));
            }
            if (!compoundtag.m_128456_()) {
                p_143637_.m_41700_("filtered_pages", compoundtag);
            }
        }
        p_143637_.m_41700_("pages", (Tag)listtag);
        CraftEventFactory.handleEditBookEvent((ServerPlayer)this.f_9743_, (int)this.mohist$slot.getAndSet(-1), (ItemStack)this.mohist$handItem.getAndSet(null), (ItemStack)p_143637_);
    }

    public void m_7548_(ServerboundEntityTagQuery p_9864_) {
        net.minecraft.world.entity.Entity entity;
        PacketUtils.m_131359_((Packet)p_9864_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_20310_(2) && (entity = this.f_9743_.m_9236_().m_6815_(p_9864_.m_134029_())) != null) {
            CompoundTag compoundtag = entity.m_20240_(new CompoundTag());
            this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundTagQueryPacket(p_9864_.m_134026_(), compoundtag));
        }
    }

    public void m_6780_(ServerboundBlockEntityTagQuery p_9837_) {
        PacketUtils.m_131359_((Packet)p_9837_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_20310_(2)) {
            BlockEntity blockentity = this.f_9743_.m_9236_().m_7702_(p_9837_.m_133813_());
            CompoundTag compoundtag = blockentity != null ? blockentity.m_187482_() : null;
            this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundTagQueryPacket(p_9837_.m_133810_(), compoundtag));
        }
    }

    public void m_7185_(ServerboundMovePlayerPacket p_9874_) {
        PacketUtils.m_131359_((Packet)p_9874_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (ServerGamePacketListenerImpl.m_143663_(p_9874_.m_134129_(0.0), p_9874_.m_134140_(0.0), p_9874_.m_134146_(0.0), p_9874_.m_134131_(0.0f), p_9874_.m_134142_(0.0f))) {
            this.m_294716_((Component)Component.m_237115_("multiplayer.disconnect.invalid_player_movement"));
        } else {
            ServerLevel serverlevel = this.f_9743_.m_284548_();
            if (!this.f_9743_.f_8944_ && !this.f_9743_.m_6107_()) {
                if (this.f_9746_ == 0) {
                    this.m_9953_();
                }
                if (this.f_9766_ != null) {
                    if (this.f_9746_ - this.f_9735_ > 20) {
                        this.f_9735_ = this.f_9746_;
                        this.m_9774_(this.f_9766_.f_82479_, this.f_9766_.f_82480_, this.f_9766_.f_82481_, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
                    }
                    this.allowedPlayerTicks = 20;
                } else {
                    this.f_9735_ = this.f_9746_;
                    double d0 = ServerGamePacketListenerImpl.m_143609_(p_9874_.m_134129_(this.f_9743_.m_20185_()));
                    double d1 = ServerGamePacketListenerImpl.m_143653_(p_9874_.m_134140_(this.f_9743_.m_20186_()));
                    double d2 = ServerGamePacketListenerImpl.m_143609_(p_9874_.m_134146_(this.f_9743_.m_20189_()));
                    float f = Mth.m_14177_((float)p_9874_.m_134131_(this.f_9743_.m_146908_()));
                    float f1 = Mth.m_14177_((float)p_9874_.m_134142_(this.f_9743_.m_146909_()));
                    if (this.f_9743_.m_20159_()) {
                        this.f_9743_.m_19890_(this.f_9743_.m_20185_(), this.f_9743_.m_20186_(), this.f_9743_.m_20189_(), f, f1);
                        this.f_9743_.m_284548_().m_7726_().m_8385_(this.f_9743_);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double prevX = this.f_9743_.m_20185_();
                        double prevY = this.f_9743_.m_20186_();
                        double prevZ = this.f_9743_.m_20189_();
                        float prevYaw = this.f_9743_.m_146908_();
                        float prevPitch = this.f_9743_.m_146909_();
                        double d3 = this.f_9743_.m_20185_();
                        double d4 = this.f_9743_.m_20186_();
                        double d5 = this.f_9743_.m_20189_();
                        double d6 = d0 - this.f_9753_;
                        double d7 = d1 - this.f_9754_;
                        double d8 = d2 - this.f_9755_;
                        double d9 = this.f_9743_.m_20184_().m_82556_();
                        double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (this.f_9743_.m_5803_()) {
                            if (d10 > 1.0) {
                                this.m_9774_(this.f_9743_.m_20185_(), this.f_9743_.m_20186_(), this.f_9743_.m_20189_(), f, f1);
                            }
                        } else {
                            boolean flag;
                            ++this.f_9740_;
                            int i = this.f_9740_ - this.f_9741_;
                            this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                            this.lastTick = (int)(System.currentTimeMillis() / 50L);
                            if (i > Math.max(this.allowedPlayerTicks, 5)) {
                                f_9744_.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.f_9743_.m_7755_().getString(), (Object)i);
                                i = 1;
                            }
                            this.allowedPlayerTicks = p_9874_.f_134125_ || d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                            double speed = this.f_9743_.m_150110_().f_35935_ ? (double)(this.f_9743_.m_150110_().f_35939_ * 20.0f) : (double)(this.f_9743_.m_150110_().f_35940_ * 10.0f);
                            if (!(this.f_9743_.m_8958_() || this.f_9743_.m_9236_().m_46469_().m_46207_(GameRules.f_46148_) && this.f_9743_.m_21255_())) {
                                float f2;
                                float f3 = f2 = this.f_9743_.m_21255_() ? 300.0f : 100.0f;
                                if (d10 - d9 > Math.max((double)f2, Math.pow((double)(10.0f * (float)i) * speed, 2.0)) && !this.m_293330_()) {
                                    f_9744_.warn("{} moved too quickly! {},{},{}", new Object[]{this.f_9743_.m_7755_().getString(), d6, d7, d8});
                                    this.m_9774_(this.f_9743_.m_20185_(), this.f_9743_.m_20186_(), this.f_9743_.m_20189_(), this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
                                    return;
                                }
                            }
                            AABB aabb = this.f_9743_.m_20191_();
                            d6 = d0 - this.f_9756_;
                            d7 = d1 - this.f_9757_;
                            d8 = d2 - this.f_9758_;
                            boolean bl = flag = d7 > 0.0;
                            if (this.f_9743_.m_20096_() && !p_9874_.m_134139_() && flag) {
                                PlayerJumpEvent event;
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (p_9874_.f_134124_) {
                                    to.setX(p_9874_.f_134118_);
                                    to.setY(p_9874_.f_134119_);
                                    to.setZ(p_9874_.f_134120_);
                                }
                                if (p_9874_.f_134125_) {
                                    to.setYaw(p_9874_.f_134121_);
                                    to.setPitch(p_9874_.f_134122_);
                                }
                                if ((event = new PlayerJumpEvent((org.bukkit.entity.Player)player, from, to)).callEvent()) {
                                    this.f_9743_.m_6135_();
                                } else {
                                    from = event.getFrom();
                                    this.internalTeleport(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch(), Collections.emptySet());
                                    return;
                                }
                            }
                            boolean flag1 = this.f_9743_.f_201939_;
                            this.f_9743_.m_6478_(MoverType.PLAYER, new Vec3(d6, d7, d8));
                            this.f_9743_.f_19861_ = p_9874_.m_134139_();
                            d6 = d0 - this.f_9743_.m_20185_();
                            d7 = d1 - this.f_9743_.m_20186_();
                            if (d7 > -0.5 || d7 < 0.5) {
                                d7 = 0.0;
                            }
                            d8 = d2 - this.f_9743_.m_20189_();
                            d10 = d6 * d6 + d7 * d7 + d8 * d8;
                            boolean flag2 = false;
                            if (!this.f_9743_.m_8958_() && d10 > SpigotConfig.movedWronglyThreshold && !this.f_9743_.m_5803_() && !this.f_9743_.f_8941_.m_9295_() && this.f_9743_.f_8941_.m_9290_() != GameType.SPECTATOR) {
                                flag2 = true;
                                f_9744_.warn("{} moved wrongly!", (Object)this.f_9743_.m_7755_().getString());
                            }
                            if (this.f_9743_.f_19794_ || this.f_9743_.m_5803_() || (!flag2 || !serverlevel.m_45756_(this.f_9743_, aabb)) && !this.m_288208_(serverlevel, aabb, d0, d1, d2)) {
                                this.f_9743_.m_19890_(prevX, prevY, prevZ, prevYaw, prevPitch);
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (p_9874_.f_134124_) {
                                    to.setX(p_9874_.f_134118_);
                                    to.setY(p_9874_.f_134119_);
                                    to.setZ(p_9874_.f_134120_);
                                }
                                if (p_9874_.f_134125_) {
                                    to.setYaw(p_9874_.f_134121_);
                                    to.setPitch(p_9874_.f_134122_);
                                }
                                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f_9743_.m_6107_()) {
                                    this.lastPosX = to.getX();
                                    this.lastPosY = to.getY();
                                    this.lastPosZ = to.getZ();
                                    this.lastYaw = to.getYaw();
                                    this.lastPitch = to.getPitch();
                                    if (from.getX() != Double.MAX_VALUE) {
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event = new PlayerMoveEvent((org.bukkit.entity.Player)player, from, to);
                                        this.cserver.getPluginManager().callEvent((Event)event);
                                        if (event.isCancelled()) {
                                            this.teleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                                            this.f_9743_.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                }
                                this.f_9743_.m_19890_(d0, d1, d2, f, f1);
                                this.f_9736_ = d7 >= -0.03125 && !flag1 && this.f_9743_.f_8941_.m_9290_() != GameType.SPECTATOR && !this.f_291389_.m_129915_() && !this.f_9743_.m_150110_().f_35936_ && !this.f_9743_.m_21023_(MobEffects.f_19620_) && !this.f_9743_.m_21255_() && !this.f_9743_.m_21209_() && this.m_9793_(this.f_9743_);
                                this.f_9743_.m_284548_().m_7726_().m_8385_(this.f_9743_);
                                this.f_9743_.m_289599_(this.f_9743_.m_20185_() - d3, this.f_9743_.m_20186_() - d4, this.f_9743_.m_20189_() - d5, p_9874_.m_134139_());
                                this.f_9743_.m_289603_(p_9874_.m_134139_(), new Vec3(this.f_9743_.m_20185_() - d3, this.f_9743_.m_20186_() - d4, this.f_9743_.m_20189_() - d5));
                                if (flag) {
                                    this.f_9743_.m_183634_();
                                }
                                this.f_9743_.m_36378_(this.f_9743_.m_20185_() - d3, this.f_9743_.m_20186_() - d4, this.f_9743_.m_20189_() - d5);
                                this.f_9756_ = this.f_9743_.m_20185_();
                                this.f_9757_ = this.f_9743_.m_20186_();
                                this.f_9758_ = this.f_9743_.m_20189_();
                            } else {
                                this.internalTeleport(d3, d4, d5, f, f1, Collections.emptySet());
                                this.f_9743_.m_289599_(this.f_9743_.m_20185_() - d3, this.f_9743_.m_20186_() - d4, this.f_9743_.m_20189_() - d5, p_9874_.m_134139_());
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean m_288208_(LevelReader p_289008_, AABB p_288986_, double p_288990_, double p_288991_, double p_288967_) {
        AABB aabb = this.f_9743_.m_20191_().m_82386_(p_288990_ - this.f_9743_.m_20185_(), p_288991_ - this.f_9743_.m_20186_(), p_288967_ - this.f_9743_.m_20189_());
        Iterable iterable = p_289008_.m_186431_(this.f_9743_, aabb.m_82406_((double)1.0E-5f));
        VoxelShape voxelshape = Shapes.m_83064_((AABB)p_288986_.m_82406_((double)1.0E-5f));
        for (VoxelShape voxelshape1 : iterable) {
            if (Shapes.m_83157_((VoxelShape)voxelshape1, (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
            return true;
        }
        return false;
    }

    public void m_9774_(double p_9775_, double p_9776_, double p_9777_, float p_9778_, float p_9779_) {
        this.teleport(p_9775_, p_9776_, p_9777_, p_9778_, p_9779_, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleport(double d0, double d1, double d2, float f, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.teleport(d0, d1, d2, f, f1, Collections.emptySet(), cause);
    }

    public void m_9780_(double p_9781_, double p_9782_, double p_9783_, float p_9784_, float p_9785_, Set<RelativeMovement> p_9786_) {
        this.teleport(p_9781_, p_9782_, p_9783_, p_9784_, p_9785_, p_9786_, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f, float f1, Set<RelativeMovement> set, PlayerTeleportEvent.TeleportCause cause) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        double x = d0;
        double y = d1;
        double z = d2;
        float yaw = f;
        float pitch = f1;
        Location to = new Location(this.getCraftPlayer().getWorld(), x, y, z, yaw, pitch);
        if (from.equals((Object)to)) {
            this.internalTeleport(d0, d1, d2, f, f1, set);
            return false;
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((org.bukkit.entity.Player)player, from.clone(), to.clone(), cause);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            set.clear();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            d0 = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f = to.getYaw();
            f1 = to.getPitch();
        }
        this.internalTeleport(d0, d1, d2, f, f1, set);
        return event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch(), Collections.emptySet());
    }

    private void internalTeleport(double pX, double pY, double pZ, float pYaw, float pPitch, Set<RelativeMovement> pRelativeSet) {
        if (Float.isNaN(pYaw)) {
            pYaw = 0.0f;
        }
        if (Float.isNaN(pPitch)) {
            pPitch = 0.0f;
        }
        this.justTeleported = true;
        double d0 = pRelativeSet.contains(RelativeMovement.X) ? this.f_9743_.m_20185_() : 0.0;
        double d1 = pRelativeSet.contains(RelativeMovement.Y) ? this.f_9743_.m_20186_() : 0.0;
        double d2 = pRelativeSet.contains(RelativeMovement.Z) ? this.f_9743_.m_20189_() : 0.0;
        float f = pRelativeSet.contains(RelativeMovement.Y_ROT) ? this.f_9743_.m_146908_() : 0.0f;
        float f1 = pRelativeSet.contains(RelativeMovement.X_ROT) ? this.f_9743_.m_146909_() : 0.0f;
        this.f_9766_ = new Vec3(pX, pY, pZ);
        if (++this.f_9767_ == Integer.MAX_VALUE) {
            this.f_9767_ = 0;
        }
        this.f_9735_ = this.f_9746_;
        this.f_9743_.m_19890_(pX, pY, pZ, pYaw, pPitch);
        this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundPlayerPositionPacket(pX - d0, pY - d1, pZ - d2, pYaw - f, pPitch - f1, pRelativeSet, this.f_9767_));
    }

    public void m_7502_(ServerboundPlayerActionPacket p_9889_) {
        PacketUtils.m_131359_((Packet)p_9889_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        BlockPos blockpos = p_9889_.m_134281_();
        this.f_9743_.m_9243_();
        ServerboundPlayerActionPacket.Action serverboundplayeractionpacket$action = p_9889_.m_134285_();
        switch (serverboundplayeractionpacket$action) {
            case SWAP_ITEM_WITH_OFFHAND: {
                if (!this.f_9743_.m_5833_()) {
                    ItemStack itemstack = this.f_9743_.m_21120_(InteractionHand.OFF_HAND);
                    LivingSwapItemsEvent.Hands event = ForgeEventFactory.onLivingSwapHandItems((LivingEntity)this.f_9743_);
                    if (event.isCanceled()) {
                        return;
                    }
                    CraftItemStack mainHand = CraftItemStack.asCraftMirror((ItemStack)event.getItemSwappedToMainHand());
                    CraftItemStack offHand = CraftItemStack.asCraftMirror((ItemStack)event.getItemSwappedToOffHand());
                    PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((org.bukkit.entity.Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                    this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                    if (swapItemsEvent.isCancelled()) {
                        return;
                    }
                    if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                        this.f_9743_.m_21008_(InteractionHand.OFF_HAND, event.getItemSwappedToOffHand());
                    } else {
                        this.f_9743_.m_21008_(InteractionHand.OFF_HAND, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)swapItemsEvent.getOffHandItem()));
                    }
                    if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                        this.f_9743_.m_21008_(InteractionHand.MAIN_HAND, event.getItemSwappedToMainHand());
                    } else {
                        this.f_9743_.m_21008_(InteractionHand.MAIN_HAND, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)swapItemsEvent.getMainHandItem()));
                    }
                    this.f_9743_.m_5810_();
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.f_9743_.m_5833_()) {
                    this.f_9743_.m_182294_(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.f_9743_.m_5833_()) {
                    if (this.lastDropTick != MinecraftServer.currentTick) {
                        this.dropCount = 0;
                        this.lastDropTick = MinecraftServer.currentTick;
                    } else {
                        ++this.dropCount;
                        if (this.dropCount >= 20) {
                            f_9744_.warn(this.f_9743_.m_6302_() + " dropped their items too quickly!");
                            this.disconnect("You dropped your items too quickly (Hacking?)");
                            return;
                        }
                    }
                    this.f_9743_.m_182294_(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.f_9743_.m_21253_();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.f_9743_.f_8941_.m_214168_(blockpos, serverboundplayeractionpacket$action, p_9889_.m_134284_(), this.f_9743_.m_9236_().m_151558_(), p_9889_.m_237987_());
                this.f_9743_.f_8906_.m_215201_(p_9889_.m_237987_());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean m_9790_(ServerPlayer p_9791_, ItemStack p_9792_) {
        if (p_9792_.m_41619_()) {
            return false;
        }
        Item item = p_9792_.m_41720_();
        return (item instanceof BlockItem || item instanceof BucketItem) && !p_9791_.m_36335_().m_41519_(item);
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < 30L && this.limitedPackets++ >= 4) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= 30L) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    public void m_6371_(ServerboundUseItemOnPacket p_9930_) {
        PacketUtils.m_131359_((Packet)p_9930_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        if (!this.checkLimit(p_9930_.timestamp)) {
            return;
        }
        this.f_9743_.f_8906_.m_215201_(p_9930_.m_238008_());
        ServerLevel serverlevel = this.f_9743_.m_284548_();
        InteractionHand interactionhand = p_9930_.m_134703_();
        ItemStack itemstack = this.f_9743_.m_21120_(interactionhand);
        if (itemstack.m_246617_(serverlevel.m_246046_())) {
            BlockHitResult blockhitresult = p_9930_.m_134706_();
            Vec3 vec3 = blockhitresult.m_82450_();
            BlockPos blockpos = blockhitresult.m_82425_();
            Vec3 vec31 = Vec3.m_82512_((Vec3i)blockpos);
            if (this.f_9743_.canReach(blockpos, 1.5)) {
                Vec3 vec32 = vec3.m_82546_(vec31);
                double d0 = 1.0000001;
                if (Math.abs(vec32.m_7096_()) < 1.0000001 && Math.abs(vec32.m_7098_()) < 1.0000001 && Math.abs(vec32.m_7094_()) < 1.0000001) {
                    Direction direction = blockhitresult.m_82434_();
                    this.f_9743_.m_9243_();
                    int i = this.f_9743_.m_9236_().m_151558_();
                    if (blockpos.m_123342_() < i) {
                        if (this.f_9766_ == null && serverlevel.m_7966_(this.f_9743_, blockpos)) {
                            this.f_9743_.m_5810_();
                            InteractionResult interactionresult = this.f_9743_.f_8941_.m_7179_(this.f_9743_, serverlevel, itemstack, interactionhand, blockhitresult);
                            if (direction == Direction.UP && !interactionresult.m_19077_() && blockpos.m_123342_() >= i - 1 && ServerGamePacketListenerImpl.m_9790_(this.f_9743_, itemstack)) {
                                MutableComponent component = Component.m_237110_("build.tooHigh", i - 1).m_130940_(ChatFormatting.RED);
                                this.f_9743_.m_240418_((Component)component, true);
                            } else if (interactionresult.m_19080_()) {
                                this.f_9743_.m_21011_(interactionhand, true);
                            }
                        }
                    } else {
                        MutableComponent component1 = Component.m_237110_("build.tooHigh", i - 1).m_130940_(ChatFormatting.RED);
                        this.f_9743_.m_240418_((Component)component1, true);
                    }
                    this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)serverlevel, blockpos));
                    this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)serverlevel, blockpos.m_121945_(direction)));
                } else {
                    f_9744_.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.f_9743_.m_36316_().getName(), vec3, blockpos});
                }
            }
        }
    }

    public void m_5760_(ServerboundUseItemPacket p_9932_) {
        PacketUtils.m_131359_((Packet)p_9932_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        if (!this.checkLimit(p_9932_.timestamp)) {
            return;
        }
        InteractionHand interactionhand = p_9932_.m_134717_();
        ItemStack itemstack = this.f_9743_.m_21120_(interactionhand);
        if (BanItem.check((Player)this.f_9743_, (ItemStack)itemstack)) {
            return;
        }
        this.m_215201_(p_9932_.m_238013_());
        ServerLevel serverlevel = this.f_9743_.m_284548_();
        this.f_9743_.m_9243_();
        if (!itemstack.m_41619_() && itemstack.m_246617_(serverlevel.m_246046_())) {
            boolean cancelled;
            float f1 = this.f_9743_.m_146909_();
            float f2 = this.f_9743_.m_146908_();
            double d0 = this.f_9743_.m_20185_();
            double d1 = this.f_9743_.m_20186_() + (double)this.f_9743_.m_20192_();
            double d2 = this.f_9743_.m_20189_();
            Vec3 vec3d = new Vec3(d0, d1, d2);
            float f3 = Mth.m_14089_((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f4 = Mth.m_14031_((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f5 = -Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180)));
            float f6 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180)));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = this.f_9743_.f_8941_.m_9290_() == GameType.CREATIVE ? 5.0 : 4.5;
            Vec3 vec3d1 = vec3d.m_82520_((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            BlockHitResult movingobjectposition = this.f_9743_.f_19853_.m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, this.f_9743_));
            if (movingobjectposition == null || movingobjectposition.m_6662_() != HitResult.Type.BLOCK) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((Player)this.f_9743_, (Action)Action.RIGHT_CLICK_AIR, (ItemStack)itemstack, (InteractionHand)interactionhand);
                cancelled = event.useItemInHand() == Event.Result.DENY;
            } else {
                PlayerInteractEvent event;
                BlockHitResult movingobjectpositionblock = movingobjectposition;
                cancelled = this.f_9743_.f_8941_.firedInteract && this.f_9743_.f_8941_.interactPosition.equals((Object)movingobjectpositionblock.m_82425_()) && this.f_9743_.f_8941_.interactHand == interactionhand && ItemStack.m_150942_(this.f_9743_.f_8941_.interactItemStack, itemstack) ? this.f_9743_.f_8941_.interactResult : (event = CraftEventFactory.callPlayerInteractEvent((Player)this.f_9743_, (Action)Action.RIGHT_CLICK_BLOCK, (BlockPos)movingobjectpositionblock.m_82425_(), (Direction)movingobjectpositionblock.m_82434_(), (ItemStack)itemstack, (boolean)true, (InteractionHand)interactionhand, (Vec3)movingobjectpositionblock.m_82450_())).useItemInHand() == Event.Result.DENY;
                this.f_9743_.f_8941_.firedInteract = false;
            }
            if (cancelled) {
                this.f_9743_.resyncUsingItem(this.f_9743_);
                this.f_9743_.getBukkitEntity().updateInventory();
                return;
            }
            itemstack = this.f_9743_.m_21120_(interactionhand);
            if (itemstack.m_41619_()) {
                return;
            }
            InteractionResult interactionresult = this.f_9743_.f_8941_.m_6261_(this.f_9743_, serverlevel, itemstack, interactionhand);
            if (interactionresult.m_19080_()) {
                this.f_9743_.m_21011_(interactionhand, true);
            }
        }
    }

    public void m_6936_(ServerboundTeleportToEntityPacket p_9928_) {
        PacketUtils.m_131359_((Packet)p_9928_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_5833_()) {
            for (ServerLevel serverlevel : this.f_291389_.m_129785_()) {
                net.minecraft.world.entity.Entity entity = p_9928_.m_134681_(serverlevel);
                if (entity == null) continue;
                this.f_9743_.teleportTo(serverlevel, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146908_(), entity.m_146909_(), PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    public void m_5938_(ServerboundPaddleBoatPacket p_9878_) {
        PacketUtils.m_131359_((Packet)p_9878_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        net.minecraft.world.entity.Entity entity = this.f_9743_.m_275832_();
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            boat.m_38339_(p_9878_.m_134218_(), p_9878_.m_134221_());
        }
    }

    @Override
    public void m_7026_(Component p_9825_) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        f_9744_.info("{} lost connection: {}", (Object)this.f_9743_.m_7755_().getString(), (Object)p_9825_.getString());
        this.m_294538_();
        super.m_7026_(p_9825_);
    }

    private void m_294538_() {
        this.f_241681_.close();
        this.f_9743_.m_9231_();
        this.f_291389_.m_6846_().m_11286_(this.f_9743_);
        String quitMessage = this.f_291389_.m_6846_().quitMessage;
        if (quitMessage != null && quitMessage.length() > 0) {
            this.f_291389_.m_6846_().broadcastMessage(CraftChatMessage.fromString((String)quitMessage));
        }
        this.f_9743_.m_8967_().m_7670_();
    }

    public void m_215201_(int p_215202_) {
        if (p_215202_ < 0) {
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.f_215200_ = Math.max(p_215202_, this.f_215200_);
    }

    public void m_7798_(ServerboundSetCarriedItemPacket p_9909_) {
        PacketUtils.m_131359_((Packet)p_9909_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        if (p_9909_.m_134498_() >= 0 && p_9909_.m_134498_() < net.minecraft.world.entity.player.Inventory.m_36059_()) {
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((org.bukkit.entity.Player)this.getCraftPlayer(), this.f_9743_.m_150109_().f_35977_, p_9909_.m_134498_());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.m_141995_((Packet<?>)new ClientboundSetCarriedItemPacket(this.f_9743_.m_150109_().f_35977_));
                this.f_9743_.m_9243_();
                return;
            }
            if (this.f_9743_.m_150109_().f_35977_ != p_9909_.m_134498_() && this.f_9743_.m_7655_() == InteractionHand.MAIN_HAND) {
                this.f_9743_.m_5810_();
            }
            this.f_9743_.m_150109_().f_35977_ = p_9909_.m_134498_();
            this.f_9743_.m_9243_();
        } else {
            f_9744_.warn("{} tried to set an invalid carried item", (Object)this.f_9743_.m_7755_().getString());
            this.disconnect("Invalid hotbar selection (Hacking?)");
        }
    }

    public void m_7388_(ServerboundChatPacket p_9841_) {
        if (this.f_291389_.m_129918_()) {
            return;
        }
        if (ServerGamePacketListenerImpl.m_215214_(p_9841_.f_133827_())) {
            this.m_294716_((Component)Component.m_237115_("multiplayer.disconnect.illegal_characters"));
        } else {
            Optional<LastSeenMessages> optional = this.m_247189_(p_9841_.f_133827_(), p_9841_.f_237950_(), p_9841_.f_241662_());
            if (optional.isPresent()) {
                PlayerChatMessage playerchatmessage;
                try {
                    playerchatmessage = this.m_247340_(p_9841_, optional.get());
                }
                catch (SignedMessageChain.DecodeException signedmessagechain$decodeexception) {
                    this.m_246889_(signedmessagechain$decodeexception);
                    return;
                }
                CompletableFuture<FilteredText> completablefuture = this.m_243132_(playerchatmessage.m_245728_());
                Component component = ForgeHooks.onServerChatSubmittedEvent((ServerPlayer)this.f_9743_, (Component)playerchatmessage.m_245692_());
                this.f_241681_.m_241849_(p_296593_ -> completablefuture.thenAcceptAsync(p_296589_ -> {
                    if (component == null) {
                        return;
                    }
                    PlayerChatMessage playerchatmessage1 = playerchatmessage.m_241956_(component).m_243072_(p_296589_.f_243010_());
                    this.m_243086_(playerchatmessage1);
                }, (Executor)this.f_291389_.chatExecutor));
            }
        }
    }

    public void m_214047_(ServerboundChatCommandPacket p_215225_) {
        if (ServerGamePacketListenerImpl.m_215214_(p_215225_.f_237922_())) {
            this.m_294716_((Component)Component.m_237115_("multiplayer.disconnect.illegal_characters"));
        } else {
            Optional<LastSeenMessages> optional = this.m_247189_(p_215225_.f_237922_(), p_215225_.f_237923_(), p_215225_.f_241638_());
            if (optional.isPresent()) {
                this.f_291389_.m_18707_(() -> {
                    if (this.f_9743_.m_9232_()) {
                        return;
                    }
                    this.m_246958_(p_215225_, (LastSeenMessages)optional.get());
                    this.s = "/" + p_215225_.f_237922_();
                    this.m_215251_();
                });
            }
        }
    }

    private void m_246958_(ServerboundChatCommandPacket p_251139_, LastSeenMessages p_250484_) {
        Map map;
        Object command = "/" + p_251139_.f_237922_();
        f_9744_.info(this.f_9743_.m_6302_() + " issued server command: " + (String)command);
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((org.bukkit.entity.Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.f_291389_));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandSourceStack> parseresults = this.m_242658_((String)command);
        try {
            map = p_251139_.f_237922_().equals(command) ? this.m_246206_(p_251139_, SignableCommand.m_246497_(parseresults), p_250484_) : Collections.emptyMap();
        }
        catch (SignedMessageChain.DecodeException signedmessagechain$decodeexception) {
            this.m_246889_(signedmessagechain$decodeexception);
            return;
        }
        CommandSigningContext.SignedArguments commandsigningcontext = new CommandSigningContext.SignedArguments(map);
        parseresults = Commands.m_242611_(parseresults, arg_0 -> this.lambda$performChatCommand$9((CommandSigningContext)commandsigningcontext, arg_0));
        this.f_291389_.m_129892_().m_242674_(parseresults, (String)command);
    }

    private void m_246889_(SignedMessageChain.DecodeException p_252068_) {
        if (p_252068_.m_246459_()) {
            this.m_294716_(p_252068_.m_237308_());
        } else {
            this.f_9743_.m_213846_((Component)p_252068_.m_237308_().m_6881_().m_130940_(ChatFormatting.RED));
        }
    }

    private Map<String, PlayerChatMessage> m_246206_(ServerboundChatCommandPacket p_249441_, SignableCommand<?> p_250039_, LastSeenMessages p_249207_) throws SignedMessageChain.DecodeException {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (SignableCommand.Argument argument : p_250039_.f_244150_()) {
            MessageSignature messagesignature = p_249441_.f_237924_().m_240943_(argument.m_246038_());
            SignedMessageBody signedmessagebody = new SignedMessageBody(argument.f_244218_(), p_249441_.f_237923_(), p_249441_.f_240858_(), p_249207_);
            map.put(argument.m_246038_(), this.f_240889_.m_240945_(messagesignature, signedmessagebody));
        }
        return map;
    }

    private ParseResults<CommandSourceStack> m_242658_(String p_242938_) {
        CommandDispatcher<CommandSourceStack> commanddispatcher = this.f_291389_.m_129892_().m_82094_();
        return commanddispatcher.parse(p_242938_, (Object)this.f_9743_.m_20203_());
    }

    private Optional<LastSeenMessages> m_247189_(String p_251364_, Instant p_248959_, LastSeenMessages.Update p_249613_) {
        if (!this.m_215236_(p_248959_)) {
            f_9744_.warn("{} sent out-of-order chat: '{}'", (Object)this.f_9743_.m_7755_().getString(), (Object)p_251364_);
            this.m_294716_((Component)Component.m_237115_("multiplayer.disconnect.out_of_order_chat"));
            return Optional.empty();
        }
        Optional<LastSeenMessages> optional = this.m_245578_(p_249613_);
        if (this.f_9743_.m_213877_() || this.f_9743_.m_9241_() == ChatVisiblity.HIDDEN) {
            this.m_141995_(new ClientboundSystemChatPacket((Component)Component.m_237115_("chat.disabled.options").m_130940_(ChatFormatting.RED), false));
            return Optional.empty();
        }
        this.f_9743_.m_9243_();
        return optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> m_245578_(LastSeenMessages.Update p_249673_) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.f_244262_;
        synchronized (lastSeenMessagesValidator) {
            Optional optional = this.f_244262_.m_247119_(p_249673_);
            if (optional.isEmpty()) {
                f_9744_.warn("Failed to validate message acknowledgements from {}", (Object)this.f_9743_.m_7755_().getString());
                this.m_294716_(f_244304_);
            }
            return optional;
        }
    }

    private boolean m_215236_(Instant p_215237_) {
        Instant instant;
        do {
            if (!p_215237_.isBefore(instant = this.f_215197_.get())) continue;
            return false;
        } while (!this.f_215197_.compareAndSet(instant, p_215237_));
        return true;
    }

    private static boolean m_215214_(String p_215215_) {
        for (int i = 0; i < p_215215_.length(); ++i) {
            if (SharedConstants.m_136188_(p_215215_.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private PlayerChatMessage m_247340_(ServerboundChatPacket p_251061_, LastSeenMessages p_250566_) throws SignedMessageChain.DecodeException {
        SignedMessageBody signedmessagebody = new SignedMessageBody(p_251061_.f_133827_(), p_251061_.f_237950_(), p_251061_.f_240906_(), p_250566_);
        return this.f_240889_.m_240945_(p_251061_.f_240898_(), signedmessagebody);
    }

    private void m_243086_(PlayerChatMessage p_243277_) {
        String s = p_243277_.m_245728_();
        if (s.isEmpty()) {
            f_9744_.warn(this.f_9743_.m_6302_() + " tried to send an empty message");
        } else if (this.getCraftPlayer().isConversing()) {
            final String conversationInput = s;
            this.f_291389_.processQueue.add(new Runnable(){

                @Override
                public void run() {
                    ServerGamePacketListenerImpl.this.getCraftPlayer().acceptConversationInput(conversationInput);
                }
            });
        } else if (this.f_9743_.m_9241_() == ChatVisiblity.SYSTEM) {
            this.m_141995_(new ClientboundSystemChatPacket((Component)Component.m_237115_("chat.cannotSend").m_130940_(ChatFormatting.RED), false));
        } else {
            this.chat(s, p_243277_, true);
        }
        this.detectRateSpam(s);
    }

    private void detectRateSpam(String string) {
        this.s = string;
        this.m_215251_();
    }

    private void m_215251_() {
        boolean counted = true;
        for (String exclude : SpigotConfig.spamExclusions) {
            if (exclude == null || this.s == null || !this.s.startsWith(exclude)) continue;
            counted = false;
            break;
        }
        if (!counted) {
            return;
        }
        this.f_9750_ += 20;
        if (this.f_9750_ > 200 && !this.f_291389_.m_6846_().m_11303_(this.f_9743_.m_36316_())) {
            this.m_294716_((Component)Component.m_237115_("disconnect.spam"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_241885_(ServerboundChatAckPacket p_242387_) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.f_244262_;
        synchronized (lastSeenMessagesValidator) {
            if (!this.f_244262_.m_245398_(p_242387_.f_244085_())) {
                f_9744_.warn("Failed to validate message acknowledgements from {}", (Object)this.f_9743_.m_7755_().getString());
                this.m_294716_(f_244304_);
            }
        }
    }

    public void m_7953_(ServerboundSwingPacket p_9926_) {
        PacketUtils.m_131359_((Packet)p_9926_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        this.f_9743_.m_9243_();
        float f1 = this.f_9743_.m_146909_();
        float f2 = this.f_9743_.m_146908_();
        double d0 = this.f_9743_.m_20185_();
        double d1 = this.f_9743_.m_20186_() + (double)this.f_9743_.m_20192_();
        double d2 = this.f_9743_.m_20189_();
        Location origin = new Location((World)this.f_9743_.f_19853_.getWorld(), d0, d1, d2, f2, f1);
        double d3 = this.f_9743_.f_8941_.m_9290_() == GameType.CREATIVE ? 5.0 : 4.5;
        RayTraceResult result = this.f_9743_.m_9236_().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.1, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.f_9743_.getBukkitEntity() && this.f_9743_.getBukkitEntity().canSee(entity) && !handle.m_5833_() && handle.m_6087_() && !handle.m_20365_(this.f_9743_);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent((Player)this.f_9743_, (Action)Action.LEFT_CLICK_AIR, (ItemStack)this.f_9743_.m_150109_().m_36056_(), (InteractionHand)InteractionHand.MAIN_HAND);
        }
        PlayerAnimationEvent event = new PlayerAnimationEvent((org.bukkit.entity.Player)this.getCraftPlayer(), p_9926_.m_134674_() == InteractionHand.MAIN_HAND ? PlayerAnimationType.ARM_SWING : PlayerAnimationType.OFF_ARM_SWING);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.f_9743_.m_6674_(p_9926_.m_134674_());
    }

    public void m_5681_(ServerboundPlayerCommandPacket p_9891_) {
        PacketUtils.m_131359_((Packet)p_9891_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_213877_()) {
            return;
        }
        switch (p_9891_.m_134320_()) {
            case PRESS_SHIFT_KEY: 
            case RELEASE_SHIFT_KEY: {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((org.bukkit.entity.Player)this.getCraftPlayer(), p_9891_.m_134320_() == ServerboundPlayerCommandPacket.Action.PRESS_SHIFT_KEY);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) break;
                return;
            }
            case START_SPRINTING: 
            case STOP_SPRINTING: {
                PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((org.bukkit.entity.Player)this.getCraftPlayer(), p_9891_.m_134320_() == ServerboundPlayerCommandPacket.Action.START_SPRINTING);
                this.cserver.getPluginManager().callEvent((Event)e2);
                if (!e2.isCancelled()) break;
                return;
            }
        }
        this.f_9743_.m_9243_();
        switch (p_9891_.m_134320_()) {
            case PRESS_SHIFT_KEY: {
                this.f_9743_.m_20260_(true);
                break;
            }
            case RELEASE_SHIFT_KEY: {
                this.f_9743_.m_20260_(false);
                break;
            }
            case START_SPRINTING: {
                this.f_9743_.m_6858_(true);
                break;
            }
            case STOP_SPRINTING: {
                this.f_9743_.m_6858_(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.f_9743_.m_5803_()) break;
                this.f_9743_.m_6145_(false, true);
                this.f_9766_ = this.f_9743_.m_20182_();
                break;
            }
            case START_RIDING_JUMP: {
                net.minecraft.world.entity.Entity entity2 = this.f_9743_.m_275832_();
                if (!(entity2 instanceof PlayerRideableJumping)) break;
                PlayerRideableJumping playerrideablejumping1 = (PlayerRideableJumping)entity2;
                int i = p_9891_.m_134321_();
                if (!playerrideablejumping1.m_7132_() || i <= 0) break;
                playerrideablejumping1.m_7199_(i);
                break;
            }
            case STOP_RIDING_JUMP: {
                net.minecraft.world.entity.Entity entity1 = this.f_9743_.m_275832_();
                if (!(entity1 instanceof PlayerRideableJumping)) break;
                PlayerRideableJumping playerrideablejumping = (PlayerRideableJumping)entity1;
                playerrideablejumping.m_8012_();
                break;
            }
            case OPEN_INVENTORY: {
                net.minecraft.world.entity.Entity $$2 = this.f_9743_.m_20202_();
                if (!($$2 instanceof HasCustomInventoryScreen)) break;
                HasCustomInventoryScreen hascustominventoryscreen = (HasCustomInventoryScreen)$$2;
                hascustominventoryscreen.m_213583_((Player)this.f_9743_);
                break;
            }
            case START_FALL_FLYING: {
                if (this.f_9743_.m_36319_()) break;
                this.f_9743_.m_36321_();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_241992_(PlayerChatMessage p_242439_) {
        MessageSignature messagesignature = p_242439_.f_244279_();
        if (messagesignature != null) {
            int i;
            this.f_243718_.m_247208_(p_242439_);
            LastSeenMessagesValidator lastSeenMessagesValidator = this.f_244262_;
            synchronized (lastSeenMessagesValidator) {
                this.f_244262_.m_247482_(messagesignature);
                i = this.f_244262_.m_245741_();
            }
            if (i > 4096) {
                this.m_294716_((Component)Component.m_237115_("multiplayer.disconnect.too_many_pending_chats"));
            }
        }
    }

    public void m_245431_(PlayerChatMessage p_250321_, ChatType.Bound p_250910_) {
        if (!this.getCraftPlayer().canSee(p_250321_.f_243882_().f_244443_())) {
            this.m_245903_(p_250321_.m_245692_(), p_250910_);
            return;
        }
        this.m_141995_((Packet<?>)new ClientboundPlayerChatPacket(p_250321_.f_243882_().f_244443_(), p_250321_.f_243882_().f_244066_(), p_250321_.f_244279_(), p_250321_.f_240885_().m_253217_(this.f_243718_), p_250321_.f_237215_(), p_250321_.f_242992_(), p_250910_.m_240987_(this.f_9743_.m_9236_().m_9598_())));
        this.m_241992_(p_250321_);
    }

    public void m_245903_(Component p_251804_, ChatType.Bound p_250040_) {
        this.m_141995_((Packet<?>)new ClientboundDisguisedChatPacket(p_251804_, p_250040_.m_240987_(this.f_9743_.m_9236_().m_9598_())));
    }

    public SocketAddress m_264262_() {
        return this.f_291338_.m_129523_();
    }

    public SocketAddress getRawAddress() {
        return this.f_291338_.f_129468_.remoteAddress();
    }

    public void m_294315_() {
        this.f_290343_ = true;
        this.m_294538_();
        this.m_141995_((Packet<?>)new ClientboundStartConfigurationPacket());
    }

    public void m_10092_(ServerboundPingRequestPacket p_300935_) {
        this.f_291338_.m_129512_((Packet<?>)new ClientboundPongResponsePacket(p_300935_.m_134998_()));
    }

    public void m_6946_(final ServerboundInteractPacket p_9866_) {
        PacketUtils.m_131359_((Packet)p_9866_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        if (BanItem.check((Player)this.f_9743_)) {
            return;
        }
        final ServerLevel serverlevel = this.f_9743_.m_284548_();
        final net.minecraft.world.entity.Entity entity = p_9866_.m_179603_(serverlevel);
        if (entity == this.f_9743_ && !this.f_9743_.m_5833_()) {
            this.disconnect("Cannot interact with self!");
            return;
        }
        this.f_9743_.m_9243_();
        this.f_9743_.m_20260_(p_9866_.m_134061_());
        if (entity != null) {
            if (!serverlevel.m_6857_().m_61937_(entity.m_20183_())) {
                return;
            }
            AABB aabb = entity.m_20191_();
            if (this.f_9743_.canReach(entity, 3.0)) {
                p_9866_.m_179617_(new ServerboundInteractPacket.Handler(){

                    private void performInteraction(InteractionHand p_143679_, EntityInteraction p_143680_, PlayerInteractEntityEvent event) {
                        ItemStack itemstack = ServerGamePacketListenerImpl.this.f_9743_.m_21120_(p_143679_);
                        if (itemstack.m_246617_(serverlevel.m_246046_())) {
                            ItemStack itemstack1 = itemstack.m_41777_();
                            ItemStack itemInHand = ServerGamePacketListenerImpl.this.f_9743_.m_21120_(p_143679_);
                            boolean triggerLeashUpdate = itemInHand != null && itemInHand.m_41720_() == Items.f_42655_ && entity instanceof Mob;
                            Item origItem = ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_() == null ? null : ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_().m_41720_();
                            ServerGamePacketListenerImpl.this.cserver.getPluginManager().callEvent((Event)event);
                            if (entity instanceof Bucketable && entity instanceof LivingEntity && origItem != null && origItem.m_5456_() == Items.f_42447_ && (event.isCancelled() || ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_() == null || ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_().m_41720_() != origItem)) {
                                ServerGamePacketListenerImpl.this.m_141995_((Packet<?>)new ClientboundAddEntityPacket(entity));
                                ServerGamePacketListenerImpl.this.f_9743_.f_36096_.m_150429_();
                            }
                            if (triggerLeashUpdate && (event.isCancelled() || ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_() == null || ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_().m_41720_() != origItem)) {
                                ServerGamePacketListenerImpl.this.m_141995_((Packet<?>)new ClientboundSetEntityLinkPacket(entity, ((Mob)entity).m_21524_()));
                            }
                            if (event.isCancelled() || ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_() == null || ServerGamePacketListenerImpl.this.f_9743_.m_150109_().m_36056_().m_41720_() != origItem) {
                                entity.m_20088_().refresh(ServerGamePacketListenerImpl.this.f_9743_);
                                if (entity instanceof Allay) {
                                    ServerGamePacketListenerImpl.this.m_141995_((Packet<?>)new ClientboundSetEquipmentPacket(entity.m_19879_(), Arrays.stream(net.minecraft.world.entity.EquipmentSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((Object)((LivingEntity)entity).m_6844_((net.minecraft.world.entity.EquipmentSlot)slot).m_41777_()))).collect(Collectors.toList())));
                                    ServerGamePacketListenerImpl.this.f_9743_.f_36096_.m_150429_();
                                }
                            }
                            if (event.isCancelled()) {
                                return;
                            }
                            InteractionResult interactionresult = p_143680_.m_143694_(ServerGamePacketListenerImpl.this.f_9743_, entity, p_143679_);
                            if (!itemInHand.m_41619_() && itemInHand.m_41613_() <= -1) {
                                ServerGamePacketListenerImpl.this.f_9743_.f_36096_.m_150429_();
                            }
                            if (interactionresult.m_19077_()) {
                                CriteriaTriggers.f_10565_.m_61494_(ServerGamePacketListenerImpl.this.f_9743_, itemstack1, entity);
                                if (interactionresult.m_19080_()) {
                                    ServerGamePacketListenerImpl.this.f_9743_.m_21011_(p_143679_, true);
                                }
                            }
                        }
                    }

                    @Override
                    public void m_142299_(InteractionHand p_143677_) {
                        this.performInteraction(p_143677_, Player::m_36157_, new PlayerInteractEntityEvent((org.bukkit.entity.Player)ServerGamePacketListenerImpl.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), p_143677_ == InteractionHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void m_142143_(InteractionHand p_143682_, Vec3 p_143683_) {
                        this.performInteraction(p_143682_, (p_143686_, p_143687_, p_143688_) -> {
                            InteractionResult onInteractEntityAtResult = ForgeHooks.onInteractEntityAt((Player)ServerGamePacketListenerImpl.this.f_9743_, (net.minecraft.world.entity.Entity)entity, (Vec3)p_143683_, (InteractionHand)p_143682_);
                            if (onInteractEntityAtResult != null) {
                                return onInteractEntityAtResult;
                            }
                            return p_143687_.m_7111_(p_143686_, p_143683_, p_143688_);
                        }, (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((org.bukkit.entity.Player)ServerGamePacketListenerImpl.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(p_143683_.f_82479_, p_143683_.f_82480_, p_143683_.f_82481_), p_143682_ == InteractionHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void m_141994_() {
                        if (!(entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity instanceof AbstractArrow || entity == ServerGamePacketListenerImpl.this.f_9743_ && !ServerGamePacketListenerImpl.this.f_9743_.m_5833_())) {
                            ItemStack itemstack = ServerGamePacketListenerImpl.this.f_9743_.m_21120_(InteractionHand.MAIN_HAND);
                            if (itemstack.m_246617_(serverlevel.m_246046_())) {
                                ServerGamePacketListenerImpl.this.f_9743_.m_5706_(entity);
                                if (!itemstack.m_41619_() && itemstack.m_41613_() <= -1) {
                                    ServerGamePacketListenerImpl.this.f_9743_.f_36096_.m_150429_();
                                }
                            }
                        } else {
                            ServerGamePacketListenerImpl.this.m_294716_((Component)Component.m_237115_("multiplayer.disconnect.invalid_entity_attacked"));
                            f_9744_.warn("Player {} tried to attack an invalid entity", (Object)ServerGamePacketListenerImpl.this.f_9743_.m_7755_().getString());
                        }
                    }
                });
            }
        } else {
            p_9866_.m_179617_(new ServerboundInteractPacket.Handler(){

                @Override
                public void m_142299_(InteractionHand hand) {
                    ServerGamePacketListenerImpl.this.callPlayerUseUnknownEntityEvent(p_9866_, hand, null);
                }

                @Override
                public void m_142143_(InteractionHand hand, Vec3 pos) {
                    ServerGamePacketListenerImpl.this.callPlayerUseUnknownEntityEvent(p_9866_, hand, pos);
                }

                @Override
                public void m_141994_() {
                    ServerGamePacketListenerImpl.this.callPlayerUseUnknownEntityEvent(p_9866_, InteractionHand.MAIN_HAND, null);
                }
            });
        }
    }

    private void callPlayerUseUnknownEntityEvent(ServerboundInteractPacket packet, InteractionHand hand, @Nullable Vec3 vector) {
        this.cserver.getPluginManager().callEvent((Event)new PlayerUseUnknownEntityEvent((org.bukkit.entity.Player)this.getCraftPlayer(), packet.getEntityId(), packet.isAttack(), hand == InteractionHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND, vector != null ? new Vector(vector.f_82479_, vector.f_82480_, vector.f_82481_) : null));
    }

    public void m_6272_(ServerboundClientCommandPacket p_9843_) {
        PacketUtils.m_131359_((Packet)p_9843_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        this.f_9743_.m_9243_();
        ServerboundClientCommandPacket.Action serverboundclientcommandpacket$action = p_9843_.m_133850_();
        switch (serverboundclientcommandpacket$action) {
            case PERFORM_RESPAWN: {
                if (this.f_9743_.f_8944_) {
                    this.f_9743_.f_8944_ = false;
                    this.f_291389_.m_6846_().mohist$reason = PlayerRespawnEvent.RespawnReason.END_PORTAL;
                    this.f_9743_ = this.f_291389_.m_6846_().m_11236_(this.f_9743_, true);
                    CriteriaTriggers.f_10588_.m_19757_(this.f_9743_, net.minecraft.world.level.Level.f_46430_, net.minecraft.world.level.Level.f_46428_);
                    break;
                }
                if (this.f_9743_.m_21223_() > 0.0f) {
                    return;
                }
                this.f_291389_.m_6846_().mohist$reason = PlayerRespawnEvent.RespawnReason.DEATH;
                this.f_9743_ = this.f_291389_.m_6846_().m_11236_(this.f_9743_, false);
                if (!this.f_291389_.m_7035_()) break;
                this.f_9743_.m_143403_(GameType.SPECTATOR);
                this.f_9743_.m_9236_().m_46469_().m_46170_(GameRules.f_46146_).m_46246_(false, this.f_291389_);
                break;
            }
            case REQUEST_STATS: {
                this.f_9743_.m_8951_().m_12819_(this.f_9743_);
            }
        }
    }

    public void m_7951_(ServerboundContainerClosePacket p_9858_) {
        PacketUtils.m_131359_((Packet)p_9858_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        this.f_9743_.m_9230_();
    }

    public void m_5914_(ServerboundContainerClickPacket p_9856_) {
        PacketUtils.m_131359_((Packet)p_9856_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        this.f_9743_.m_9243_();
        if (this.f_9743_.f_36096_.f_38840_ == p_9856_.m_133959_() && this.f_9743_.f_36096_.m_6875_(this.f_9743_)) {
            boolean cancelled = this.f_9743_.m_5833_();
            if (!this.f_9743_.f_36096_.m_6875_(this.f_9743_)) {
                f_9744_.debug("Player {} interacted with invalid menu {}", (Object)this.f_9743_, (Object)this.f_9743_.f_36096_);
            } else {
                int i = p_9856_.m_133962_();
                if (!this.f_9743_.f_36096_.m_207775_(i)) {
                    f_9744_.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.f_9743_.m_7755_(), i, this.f_9743_.f_36096_.f_38839_.size()});
                } else {
                    boolean flag = p_9856_.m_182741_() != this.f_9743_.f_36096_.m_182424_();
                    this.f_9743_.f_36096_.m_150443_();
                    if (p_9856_.m_133962_() < -1 && p_9856_.m_133962_() != -999) {
                        return;
                    }
                    InventoryView inventoryView = this.f_9743_.f_36096_.getBukkitView();
                    if (inventoryView == null) {
                        CraftInventory inventory = new CraftInventory((Container)new MohistModsInventory(this.f_9743_.f_36096_, (Player)this.f_9743_));
                        CraftInventoryView newView = new CraftInventoryView((HumanEntity)this.f_9743_.getBukkitEntity(), (Inventory)inventory, this.f_9743_.f_36096_);
                        inventoryView = newView;
                        this.f_9743_.f_36096_.bukkitView = newView;
                    }
                    InventoryType.SlotType type = inventoryView.getSlotType(p_9856_.m_133962_());
                    org.bukkit.event.inventory.ClickType click = org.bukkit.event.inventory.ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    ItemStack itemstack = ItemStack.f_41583_;
                    switch (p_9856_.m_133966_()) {
                        case PICKUP: {
                            if (p_9856_.m_133963_() == 0) {
                                click = org.bukkit.event.inventory.ClickType.LEFT;
                            } else if (p_9856_.m_133963_() == 1) {
                                click = org.bukkit.event.inventory.ClickType.RIGHT;
                            }
                            if (p_9856_.m_133963_() != 0 && p_9856_.m_133963_() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (p_9856_.m_133962_() == -999) {
                                if (this.f_9743_.f_36096_.m_142621_().m_41619_()) break;
                                action = p_9856_.m_133963_() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (p_9856_.m_133962_() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_());
                            if (slot == null) break;
                            ItemStack clickedItem = slot.m_7993_();
                            ItemStack cursor = this.f_9743_.f_36096_.m_142621_();
                            if (clickedItem.m_41619_()) {
                                if (cursor.m_41619_()) break;
                                action = p_9856_.m_133963_() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.m_8010_(this.f_9743_)) break;
                            if (cursor.m_41619_()) {
                                action = p_9856_.m_133963_() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.m_5857_(cursor)) {
                                if (ItemStack.m_150942_(clickedItem, cursor)) {
                                    int toPlace = p_9856_.m_133963_() == 0 ? cursor.m_41613_() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.m_41741_() - clickedItem.m_41613_());
                                    if ((toPlace = Math.min(toPlace, slot.f_40218_.m_6893_() - clickedItem.m_41613_())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.m_41613_()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.m_41613_() > slot.m_6641_()) break;
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!ItemStack.m_150942_(cursor, clickedItem) || clickedItem.m_41613_() < 0 || clickedItem.m_41613_() + cursor.m_41613_() > cursor.m_41741_()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case QUICK_MOVE: {
                            if (p_9856_.m_133963_() == 0) {
                                click = org.bukkit.event.inventory.ClickType.SHIFT_LEFT;
                            } else if (p_9856_.m_133963_() == 1) {
                                click = org.bukkit.event.inventory.ClickType.SHIFT_RIGHT;
                            }
                            if (p_9856_.m_133963_() != 0 && p_9856_.m_133963_() != 1) break;
                            if (p_9856_.m_133962_() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_());
                            if (slot != null && slot.m_8010_(this.f_9743_) && slot.m_6657_()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case SWAP: {
                            if ((p_9856_.m_133963_() < 0 || p_9856_.m_133963_() >= 9) && p_9856_.m_133963_() != 40) break;
                            click = p_9856_.m_133963_() == 40 ? org.bukkit.event.inventory.ClickType.SWAP_OFFHAND : org.bukkit.event.inventory.ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_());
                            if (clickedSlot.m_8010_(this.f_9743_)) {
                                boolean canCleanSwap;
                                ItemStack hotbar = this.f_9743_.m_150109_().m_8020_(p_9856_.m_133963_());
                                boolean bl = canCleanSwap = hotbar.m_41619_() || clickedSlot.f_40218_ == this.f_9743_.m_150109_() && clickedSlot.m_5857_(hotbar);
                                if (clickedSlot.m_6657_()) {
                                    if (canCleanSwap) {
                                        action = InventoryAction.HOTBAR_SWAP;
                                        break;
                                    }
                                    action = InventoryAction.HOTBAR_MOVE_AND_READD;
                                    break;
                                }
                                if (!clickedSlot.m_6657_() && !hotbar.m_41619_() && clickedSlot.m_5857_(hotbar)) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case CLONE: {
                            Slot slot;
                            if (p_9856_.m_133963_() == 2) {
                                click = org.bukkit.event.inventory.ClickType.MIDDLE;
                                if (p_9856_.m_133962_() < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_());
                                if (slot != null && slot.m_6657_() && this.f_9743_.m_150110_().f_35937_ && this.f_9743_.f_36096_.m_142621_().m_41619_()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = org.bukkit.event.inventory.ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case THROW: {
                            Slot slot;
                            if (p_9856_.m_133962_() >= 0) {
                                if (p_9856_.m_133963_() == 0) {
                                    click = org.bukkit.event.inventory.ClickType.DROP;
                                    slot = this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_());
                                    if (slot != null && slot.m_6657_() && slot.m_8010_(this.f_9743_) && !slot.m_7993_().m_41619_() && slot.m_7993_().m_41720_() != Item.m_41439_(Blocks.f_50016_)) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (p_9856_.m_133963_() != 1) break;
                                click = org.bukkit.event.inventory.ClickType.CONTROL_DROP;
                                slot = this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_());
                                if (slot != null && slot.m_6657_() && slot.m_8010_(this.f_9743_) && !slot.m_7993_().m_41619_() && slot.m_7993_().m_41720_() != Item.m_41439_(Blocks.f_50016_)) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = org.bukkit.event.inventory.ClickType.LEFT;
                            if (p_9856_.m_133963_() == 1) {
                                click = org.bukkit.event.inventory.ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case QUICK_CRAFT: {
                            this.f_9743_.f_36096_.m_150399_(p_9856_.m_133962_(), p_9856_.m_133963_(), p_9856_.m_133966_(), this.f_9743_);
                            break;
                        }
                        case PICKUP_ALL: {
                            click = org.bukkit.event.inventory.ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (p_9856_.m_133962_() < 0 || this.f_9743_.f_36096_.m_142621_().m_41619_()) break;
                            ItemStack cursor = this.f_9743_.f_36096_.m_142621_();
                            action = InventoryAction.NOTHING;
                            if (!inventoryView.getTopInventory().contains(CraftMagicNumbers.getMaterial((Item)cursor.m_41720_())) && !inventoryView.getBottomInventory().contains(CraftMagicNumbers.getMaterial((Item)cursor.m_41720_()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (p_9856_.m_133966_() != ClickType.QUICK_CRAFT) {
                        org.bukkit.inventory.ItemStack result;
                        Recipe recipe;
                        InventoryClickEvent event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new InventoryClickEvent(inventoryView, type, p_9856_.m_133962_(), click, action, p_9856_.m_133963_()) : new InventoryClickEvent(inventoryView, type, p_9856_.m_133962_(), click, action);
                        Inventory top = inventoryView.getTopInventory();
                        if (p_9856_.m_133962_() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                            event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventoryView, type, p_9856_.m_133962_(), click, action, p_9856_.m_133963_()) : new CraftItemEvent(recipe, inventoryView, type, p_9856_.m_133962_(), click, action);
                        }
                        if (p_9856_.m_133962_() == 3 && top instanceof SmithingInventory && (result = ((SmithingInventory)top).getResult()) != null) {
                            event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new SmithItemEvent(inventoryView, type, p_9856_.m_133962_(), click, action, p_9856_.m_133963_()) : new SmithItemEvent(inventoryView, type, p_9856_.m_133962_(), click, action);
                        }
                        event.setCancelled(cancelled);
                        AbstractContainerMenu oldContainer = this.f_9743_.f_36096_;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.f_9743_.f_36096_ != oldContainer) {
                            return;
                        }
                        block9 : switch (event.getResult()) {
                            case ALLOW: 
                            case DEFAULT: {
                                this.f_9743_.f_36096_.m_150399_(i, p_9856_.m_133963_(), p_9856_.m_133966_(), this.f_9743_);
                                break;
                            }
                            case DENY: {
                                switch (action) {
                                    case PICKUP_ALL: 
                                    case MOVE_TO_OTHER_INVENTORY: 
                                    case HOTBAR_MOVE_AND_READD: 
                                    case HOTBAR_SWAP: 
                                    case COLLECT_TO_CURSOR: 
                                    case UNKNOWN: {
                                        this.f_9743_.f_36096_.m_150429_();
                                        break block9;
                                    }
                                    case PICKUP_SOME: 
                                    case PICKUP_HALF: 
                                    case PICKUP_ONE: 
                                    case PLACE_ALL: 
                                    case PLACE_SOME: 
                                    case PLACE_ONE: 
                                    case SWAP_WITH_CURSOR: {
                                        this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(-1, -1, this.f_9743_.f_36095_.m_182425_(), this.f_9743_.f_36096_.m_142621_()));
                                        this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(this.f_9743_.f_36096_.f_38840_, this.f_9743_.f_36095_.m_182425_(), p_9856_.m_133962_(), this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_()).m_7993_()));
                                        break block9;
                                    }
                                    case DROP_ALL_SLOT: 
                                    case DROP_ONE_SLOT: {
                                        this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(this.f_9743_.f_36096_.f_38840_, this.f_9743_.f_36095_.m_182425_(), p_9856_.m_133962_(), this.f_9743_.f_36096_.m_38853_(p_9856_.m_133962_()).m_7993_()));
                                        break block9;
                                    }
                                    case DROP_ALL_CURSOR: 
                                    case DROP_ONE_CURSOR: 
                                    case CLONE_STACK: {
                                        this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(-1, -1, this.f_9743_.f_36095_.m_182425_(), this.f_9743_.f_36096_.m_142621_()));
                                        break block9;
                                    }
                                }
                            }
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.f_9743_.f_36096_.m_150429_();
                        }
                    }
                    for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(p_9856_.m_179582_())) {
                        this.f_9743_.f_36096_.m_182414_(entry.getIntKey(), (ItemStack)((Object)entry.getValue()));
                    }
                    this.f_9743_.f_36096_.m_150422_(p_9856_.m_179581_());
                    this.f_9743_.f_36096_.m_150444_();
                    if (flag) {
                        this.f_9743_.f_36096_.m_182423_();
                    } else {
                        this.f_9743_.f_36096_.m_38946_();
                    }
                }
            }
        }
    }

    public void m_7191_(ServerboundPlaceRecipePacket p_9882_) {
        PacketUtils.m_131359_((Packet)p_9882_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        this.f_9743_.m_9243_();
        if (!this.f_9743_.m_5833_() && this.f_9743_.f_36096_.f_38840_ == p_9882_.m_134249_() && this.f_9743_.f_36096_ instanceof RecipeBookMenu) {
            if (!this.f_9743_.f_36096_.m_6875_(this.f_9743_)) {
                f_9744_.debug("Player {} interacted with invalid menu {}", (Object)this.f_9743_, (Object)this.f_9743_.f_36096_);
            } else {
                Recipe recipe = this.cserver.getRecipe(CraftNamespacedKey.fromMinecraft((ResourceLocation)p_9882_.m_134252_()));
                if (recipe == null) {
                    return;
                }
                PlayerRecipeBookClickEvent event = CraftEventFactory.callRecipeBookClickEvent((ServerPlayer)this.f_9743_, (Recipe)recipe, (boolean)p_9882_.m_134253_());
                this.f_291389_.m_129894_().m_44043_(CraftNamespacedKey.toMinecraft((NamespacedKey)((Keyed)event.getRecipe()).getKey())).ifPresent(irecipe -> ((RecipeBookMenu)this.f_9743_.f_36096_).m_6951_(event.isShiftClick(), (RecipeHolder<?>)irecipe, this.f_9743_));
            }
        }
    }

    public void m_6557_(ServerboundContainerButtonClickPacket p_9854_) {
        PacketUtils.m_131359_((Packet)p_9854_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_6107_()) {
            return;
        }
        this.f_9743_.m_9243_();
        if (this.f_9743_.f_36096_.f_38840_ == p_9854_.m_133935_() && !this.f_9743_.m_5833_()) {
            if (!this.f_9743_.f_36096_.m_6875_(this.f_9743_)) {
                f_9744_.debug("Player {} interacted with invalid menu {}", (Object)this.f_9743_, (Object)this.f_9743_.f_36096_);
            } else {
                boolean flag = this.f_9743_.f_36096_.m_6366_(this.f_9743_, p_9854_.m_133938_());
                if (flag) {
                    this.f_9743_.f_36096_.m_38946_();
                }
            }
        }
    }

    public void m_5964_(ServerboundSetCreativeModeSlotPacket p_9915_) {
        PacketUtils.m_131359_((Packet)p_9915_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.f_8941_.m_9295_()) {
            boolean flag2;
            boolean flag = p_9915_.m_134561_() < 0;
            ItemStack itemstack = p_9915_.m_134564_();
            if (!itemstack.m_246617_(this.f_9743_.m_9236_().m_246046_())) {
                return;
            }
            CompoundTag compoundtag = BlockItem.m_186336_(itemstack);
            if (!itemstack.m_41619_() && compoundtag != null && compoundtag.m_128441_("x") && compoundtag.m_128441_("y") && compoundtag.m_128441_("z")) {
                BlockEntity blockentity;
                BlockPos blockpos = BlockEntity.m_187472_(compoundtag);
                if (this.f_9743_.m_9236_().m_46749_(blockpos) && (blockentity = this.f_9743_.m_9236_().m_7702_(blockpos)) != null) {
                    blockentity.m_187476_(itemstack);
                }
            }
            boolean flag1 = p_9915_.m_134561_() >= 1 && p_9915_.m_134561_() <= 45;
            boolean bl = flag2 = itemstack.m_41619_() || itemstack.m_41773_() >= 0 && itemstack.m_41613_() <= 64 && !itemstack.m_41619_();
            if (flag || flag1 && !ItemStack.m_41728_(this.f_9743_.f_36095_.m_38853_(p_9915_.m_134561_()).m_7993_(), p_9915_.m_134564_())) {
                CraftInventoryView inventory = this.f_9743_.f_36095_.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy((ItemStack)p_9915_.m_134564_());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (p_9915_.m_134561_() < 36) {
                    type = p_9915_.m_134561_() >= 5 && p_9915_.m_134561_() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : p_9915_.m_134561_(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (p_9915_.m_134561_() >= 0) {
                            this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(this.f_9743_.f_36095_.f_38840_, this.f_9743_.f_36095_.m_182425_(), p_9915_.m_134561_(), this.f_9743_.f_36095_.m_38853_(p_9915_.m_134561_()).m_7993_()));
                            this.f_9743_.f_8906_.m_141995_((Packet<?>)new ClientboundContainerSetSlotPacket(-1, this.f_9743_.f_36095_.m_182425_(), -1, ItemStack.f_41583_));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.f_9743_.f_36095_.m_38853_(p_9915_.m_134561_()).m_269060_(itemstack);
                this.f_9743_.f_36095_.m_38946_();
            } else if (flag && flag2 && this.f_9751_ < 200) {
                this.f_9751_ += 20;
                this.f_9743_.m_36176_(itemstack, true);
            }
        }
    }

    public void m_5527_(ServerboundSignUpdatePacket p_9921_) {
        List<String> list = Stream.of(p_9921_.m_134663_()).map(ChatFormatting::m_126649_).collect(Collectors.toList());
        this.m_243065_(list).thenAcceptAsync(p_215245_ -> this.m_9922_(p_9921_, (List<FilteredText>)p_215245_), (Executor)((Object)this.f_291389_));
    }

    private void m_9922_(ServerboundSignUpdatePacket p_9923_, List<FilteredText> p_9924_) {
        if (this.f_9743_.m_6107_()) {
            return;
        }
        this.f_9743_.m_9243_();
        ServerLevel serverlevel = this.f_9743_.m_284548_();
        BlockPos blockpos = p_9923_.m_134660_();
        if (serverlevel.m_46805_(blockpos)) {
            BlockEntity blockentity = serverlevel.m_7702_(blockpos);
            if (!(blockentity instanceof SignBlockEntity)) {
                return;
            }
            SignBlockEntity signblockentity = (SignBlockEntity)blockentity;
            signblockentity.m_277134_(this.f_9743_, p_9923_.m_276788_(), p_9924_);
        }
    }

    public void m_6828_(ServerboundPlayerAbilitiesPacket p_9887_) {
        PacketUtils.m_131359_((Packet)p_9887_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        boolean bl = this.f_9743_.m_150110_().f_35935_ = p_9887_.m_134264_() && this.f_9743_.m_150110_().f_35936_;
        if (this.f_9743_.m_150110_().f_35936_ && this.f_9743_.m_150110_().f_35935_ != p_9887_.m_134264_()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((org.bukkit.entity.Player)this.f_9743_.getBukkitEntity(), p_9887_.m_134264_());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.f_9743_.m_150110_().f_35935_ = p_9887_.m_134264_();
            } else {
                this.f_9743_.m_6885_();
            }
        }
    }

    public void m_9844_(ServerboundClientInformationPacket p_298714_) {
        PacketUtils.m_131359_((Packet)p_298714_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        this.f_9743_.m_9156_(p_298714_.f_291402_());
    }

    public void m_7477_(ServerboundChangeDifficultyPacket p_9839_) {
        PacketUtils.m_131359_((Packet)p_9839_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_20310_(2) || this.m_293330_()) {
            this.f_291389_.m_129827_(p_9839_.m_133824_(), false);
        }
    }

    public void m_7728_(ServerboundLockDifficultyPacket p_9872_) {
        PacketUtils.m_131359_((Packet)p_9872_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        if (this.f_9743_.m_20310_(2) || this.m_293330_()) {
            this.f_291389_.m_129958_(p_9872_.m_134115_());
        }
    }

    public void m_252797_(ServerboundChatSessionUpdatePacket p_253950_) {
    }

    public void m_294045_(ServerboundConfigurationAcknowledgedPacket p_299199_) {
        if (!this.f_290343_) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        this.f_291338_.m_129505_((PacketListener)new ServerConfigurationPacketListenerImpl(this.f_291389_, this.f_291338_, this.m_295477_(this.f_9743_.m_294559_()), this.f_9743_));
    }

    public void m_292755_(ServerboundChunkBatchReceivedPacket p_298310_) {
        PacketUtils.m_131359_((Packet)p_298310_, (PacketListener)this, (ServerLevel)this.f_9743_.m_284548_());
        this.f_290664_.m_293508_(p_298310_.f_291279_());
    }

    private void m_253005_(RemoteChatSession p_253823_) {
        this.f_252494_ = p_253823_;
        this.f_240889_ = p_253823_.m_245959_(this.f_9743_.m_20148_());
        this.f_241681_.m_241849_(p_253488_ -> {
            this.f_9743_.m_252981_(p_253823_);
            this.f_291389_.m_6846_().m_11268_((Packet<?>)new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.INITIALIZE_CHAT), List.of(this.f_9743_)));
            return CompletableFuture.completedFuture(null);
        });
    }

    public ServerPlayer m_142253_() {
        return this.f_9743_;
    }

    private void handleCommand(String s) {
        if (SpigotConfig.logCommands) {
            f_9744_.info(this.f_9743_.m_6302_() + " issued server command: " + s);
        }
        CraftPlayer player = this.getCraftPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((org.bukkit.entity.Player)player, s, (Set)new LazyPlayerSet(this.f_291389_));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        try {
            if (this.cserver.dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
                return;
            }
        }
        catch (CommandException ex) {
            player.sendMessage(ChatColor.RED + "An internal error occurred while attempting to perform this command");
            java.util.logging.Logger.getLogger(ServerGamePacketListenerImpl.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
    }

    public void chat(String s, final PlayerChatMessage original, boolean async) {
        if (s.isEmpty() || this.f_9743_.m_9241_() == ChatVisiblity.HIDDEN) {
            return;
        }
        OutgoingChatMessage outgoing = OutgoingChatMessage.m_247282_((PlayerChatMessage)original);
        if (!async && s.startsWith("/")) {
            this.handleCommand(s);
        } else if (this.f_9743_.m_9241_() != ChatVisiblity.SYSTEM) {
            CraftPlayer player = this.getCraftPlayer();
            AsyncPlayerChatEvent event = new AsyncPlayerChatEvent(async, (org.bukkit.entity.Player)player, s, (Set)new LazyPlayerSet(this.f_291389_));
            final String originalFormat = event.getFormat();
            final String originalMessage = event.getMessage();
            Bukkit.getPluginManager().callEvent((Event)event);
            if (PlayerChatEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerChatEvent queueEvent = new PlayerChatEvent((org.bukkit.entity.Player)player, event.getMessage(), event.getFormat(), event.getRecipients());
                queueEvent.setCancelled(event.isCancelled());
                Waitable waitable = new Waitable(){

                    protected Object evaluate() {
                        Bukkit.getPluginManager().callEvent((Event)queueEvent);
                        if (queueEvent.isCancelled()) {
                            return null;
                        }
                        String message = String.format(queueEvent.getFormat(), queueEvent.getPlayer().getDisplayName(), queueEvent.getMessage());
                        if (((LazyPlayerSet)queueEvent.getRecipients()).isLazy()) {
                            if (!SpigotConfig.bungee && originalFormat.equals(queueEvent.getFormat()) && originalMessage.equals(queueEvent.getMessage()) && queueEvent.getPlayer().getName().equalsIgnoreCase(queueEvent.getPlayer().getDisplayName())) {
                                ServerGamePacketListenerImpl.this.f_291389_.m_6846_().m_243049_(original, ServerGamePacketListenerImpl.this.f_9743_, ChatType.m_240980_((ResourceKey)ChatType.f_130598_, (net.minecraft.world.entity.Entity)ServerGamePacketListenerImpl.this.f_9743_));
                                return null;
                            }
                            for (ServerPlayer recipient : ServerGamePacketListenerImpl.this.f_291389_.m_6846_().f_11196_) {
                                recipient.getBukkitEntity().sendMessage(ServerGamePacketListenerImpl.this.f_9743_.m_20148_(), message);
                            }
                        } else {
                            for (org.bukkit.entity.Player player : queueEvent.getRecipients()) {
                                player.sendMessage(ServerGamePacketListenerImpl.this.f_9743_.m_20148_(), message);
                            }
                        }
                        ServerGamePacketListenerImpl.this.f_291389_.console.sendMessage(message);
                        return null;
                    }
                };
                if (async) {
                    this.f_291389_.processQueue.add((Runnable)waitable);
                } else {
                    waitable.run();
                }
                try {
                    waitable.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Exception processing chat event", e.getCause());
                }
            } else {
                if (event.isCancelled()) {
                    return;
                }
                s = String.format(event.getFormat(), event.getPlayer().getDisplayName(), event.getMessage());
                if (((LazyPlayerSet)event.getRecipients()).isLazy()) {
                    if (!SpigotConfig.bungee && originalFormat.equals(event.getFormat()) && originalMessage.equals(event.getMessage()) && event.getPlayer().getName().equalsIgnoreCase(event.getPlayer().getDisplayName())) {
                        this.f_291389_.m_6846_().m_243049_(original, this.f_9743_, ChatType.m_240980_((ResourceKey)ChatType.f_130598_, (net.minecraft.world.entity.Entity)this.f_9743_));
                        return;
                    }
                    for (ServerPlayer recipient : this.f_291389_.m_6846_().f_11196_) {
                        recipient.getBukkitEntity().sendMessage(this.f_9743_.m_20148_(), s);
                    }
                } else {
                    for (org.bukkit.entity.Player recipient : event.getRecipients()) {
                        recipient.sendMessage(this.f_9743_.m_20148_(), s);
                    }
                }
                this.f_291389_.console.sendMessage(s);
            }
        }
    }

    private /* synthetic */ CommandSourceStack lambda$performChatCommand$9(CommandSigningContext commandsigningcontext, CommandSourceStack p_296586_) {
        return p_296586_.m_230893_(commandsigningcontext, (TaskChainer)this.f_241681_);
    }

    @FunctionalInterface
    static interface EntityInteraction {
        public InteractionResult m_143694_(ServerPlayer var1, net.minecraft.world.entity.Entity var2, InteractionHand var3);
    }
}

