/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.proxy.VelocityProxy;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mohistmc.MohistConfig;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ClientboundGameProfilePacket;
import net.minecraft.network.protocol.login.ClientboundHelloPacket;
import net.minecraft.network.protocol.login.ClientboundLoginCompressionPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.ServerLoginPacketListener;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.network.protocol.login.ServerboundKeyPacket;
import net.minecraft.network.protocol.login.ServerboundLoginAcknowledgedPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerHandshakePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.util.RandomSource;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.ICustomPacket;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.slf4j.Logger;

public class ServerLoginPacketListenerImpl
implements ServerLoginPacketListener,
TickablePacketListener {
    private static final AtomicInteger f_10014_ = new AtomicInteger(0);
    static final Logger f_10015_ = LogUtils.getLogger();
    private static final int f_143698_ = 600;
    private static final Component f_291075_ = Component.m_237115_("multiplayer.disconnect.unexpected_query_response");
    private final byte[] f_252396_;
    final MinecraftServer f_10018_;
    public final Connection f_10013_;
    private volatile State f_10019_ = State.HELLO;
    private int f_10020_;
    @Nullable
    String f_291165_;
    @Nullable
    private GameProfile f_291112_;
    private final String f_10022_ = "";
    private ServerPlayer player;
    private int velocityLoginMessageId = -1;
    private static final ExecutorService authenticatorPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("User Authenticator #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(f_10015_)).build());

    public ServerLoginPacketListenerImpl(MinecraftServer p_10027_, Connection p_10028_) {
        this.f_10018_ = p_10027_;
        this.f_10013_ = p_10028_;
        this.f_252396_ = Ints.toByteArray((int)RandomSource.m_216327_().m_188502_());
    }

    public void m_9933_() {
        if (this.f_10019_ == State.VERIFYING) {
            this.m_294778_(Objects.requireNonNull(this.f_291112_));
        }
        if (this.f_10019_ == State.WAITING_FOR_DUPE_DISCONNECT && !this.m_294137_(Objects.requireNonNull(this.f_291112_))) {
            this.m_293203_(this.f_291112_);
        }
        if (this.f_10020_++ == 600) {
            this.m_10053_((Component)Component.m_237115_("multiplayer.disconnect.slow_login"));
        }
    }

    public boolean m_6198_() {
        return this.f_10013_.m_129536_();
    }

    @Deprecated
    public void disconnect(String s) {
        this.m_10053_((Component)Component.m_237113_(s));
    }

    public void m_10053_(Component p_10054_) {
        try {
            f_10015_.info("Disconnecting {}: {}", (Object)this.m_10056_(), (Object)p_10054_.getString());
            this.f_10013_.m_129512_((Packet<?>)new ClientboundLoginDisconnectPacket(p_10054_));
            this.f_10013_.m_129507_(p_10054_);
        }
        catch (Exception exception) {
            f_10015_.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    private boolean m_294137_(GameProfile p_298499_) {
        return this.f_10018_.m_6846_().m_11259_(p_298499_.getId()) != null;
    }

    public void m_7026_(Component p_10043_) {
        f_10015_.info("{} lost connection: {}", (Object)this.m_10056_(), (Object)p_10043_.getString());
    }

    public String m_10056_() {
        String s = this.f_10013_.m_295656_(this.f_10018_.m_292975_());
        return this.f_291165_ != null ? this.f_291165_ + " (" + s + ")" : s;
    }

    public void m_5990_(ServerboundHelloPacket p_10047_) {
        Validate.validState((this.f_10019_ == State.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        this.f_291165_ = p_10047_.f_238040_();
        GameProfile gameprofile = this.f_10018_.m_236731_();
        if (gameprofile != null && this.f_291165_.equalsIgnoreCase(gameprofile.getName())) {
            this.m_294008_(gameprofile);
        } else if (this.f_10018_.m_129797_() && !this.f_10013_.m_129531_()) {
            this.f_10019_ = State.KEY;
            this.f_10013_.m_129512_((Packet<?>)new ClientboundHelloPacket("", this.f_10018_.m_129790_().getPublic().getEncoded(), this.f_252396_));
        } else {
            if (MohistConfig.velocity_enabled) {
                this.velocityLoginMessageId = ThreadLocalRandom.current().nextInt();
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.writeByte(4);
                ClientboundCustomQueryPacket packet1 = new ClientboundCustomQueryPacket(this.velocityLoginMessageId, new ClientboundCustomQueryPacket.PlayerInfoChannelPayload(VelocityProxy.PLAYER_INFO_CHANNEL, buf));
                this.f_10013_.m_129512_(packet1);
                return;
            }
            authenticatorPool.execute(() -> {
                try {
                    new LoginHandler().fireEvents(this.m_295545_(this.f_291165_));
                }
                catch (Exception ex) {
                    this.disconnect("Failed to verify username!");
                    this.f_10018_.server.getLogger().log(Level.WARNING, "Exception verifying " + this.f_291165_, ex);
                }
            });
        }
    }

    void m_294008_(GameProfile p_301095_) {
        this.f_291112_ = p_301095_;
        this.f_10019_ = State.VERIFYING;
    }

    private void m_294778_(GameProfile p_299507_) {
        PlayerList playerlist = this.f_10018_.m_6846_();
        this.player = playerlist.canPlayerLogin(this, p_299507_);
        if (this.player != null) {
            boolean flag;
            if (this.f_10018_.m_6328_() >= 0 && !this.f_10013_.m_129531_()) {
                this.f_10013_.m_243124_((Packet<?>)new ClientboundLoginCompressionPacket(this.f_10018_.m_6328_()), PacketSendListener.m_243092_(() -> this.f_10013_.m_129484_(this.f_10018_.m_6328_(), true)));
            }
            if (flag = playerlist.m_292966_(p_299507_)) {
                this.f_10019_ = State.WAITING_FOR_DUPE_DISCONNECT;
            } else {
                this.m_293203_(p_299507_);
            }
        }
    }

    private void m_293203_(GameProfile p_300150_) {
        this.f_10019_ = State.PROTOCOL_SWITCHING;
        this.f_10013_.m_129512_((Packet<?>)new ClientboundGameProfilePacket(p_300150_));
    }

    public static boolean m_203792_(String p_203793_) {
        return p_203793_.chars().filter(p_203791_ -> p_203791_ <= 32 || p_203791_ >= 127).findAny().isEmpty();
    }

    public void m_8072_(ServerboundKeyPacket p_10049_) {
        String s;
        Validate.validState((this.f_10019_ == State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.f_10018_.m_129790_().getPrivate();
            if (!p_10049_.m_253194_(this.f_252396_, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretkey = p_10049_.m_134859_(privatekey);
            Cipher cipher = Crypt.m_13583_((int)2, (Key)secretkey);
            Cipher cipher1 = Crypt.m_13583_((int)1, (Key)secretkey);
            s = new BigInteger(Crypt.m_13590_((String)"", (PublicKey)this.f_10018_.m_129790_().getPublic(), (SecretKey)secretkey)).toString(16);
            this.f_10019_ = State.AUTHENTICATING;
            this.f_10013_.m_129495_(cipher, cipher1);
        }
        catch (CryptException cryptexception) {
            throw new IllegalStateException("Protocol error", cryptexception);
        }
        Thread thread = new Thread((ThreadGroup)SidedThreadGroups.SERVER, "User Authenticator #" + f_10014_.incrementAndGet()){

            @Override
            public void run() {
                String s1 = Objects.requireNonNull(ServerLoginPacketListenerImpl.this.f_291165_, "Player name not initialized");
                try {
                    ProfileResult profileresult = ServerLoginPacketListenerImpl.this.f_10018_.m_129925_().hasJoinedServer(s1, s, this.m_10064_());
                    if (profileresult != null) {
                        GameProfile gameprofile = profileresult.profile();
                        if (!ServerLoginPacketListenerImpl.this.f_10013_.m_129536_()) {
                            return;
                        }
                        new LoginHandler().fireEvents(gameprofile);
                    } else if (ServerLoginPacketListenerImpl.this.f_10018_.m_129792_()) {
                        f_10015_.warn("Failed to verify username but will let them in anyway!");
                        ServerLoginPacketListenerImpl.this.m_294008_(ServerLoginPacketListenerImpl.this.m_295545_(s1));
                    } else {
                        ServerLoginPacketListenerImpl.this.m_10053_((Component)Component.m_237115_("multiplayer.disconnect.unverified_username"));
                        f_10015_.error("Username '{}' tried to join with an invalid session", (Object)s1);
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (ServerLoginPacketListenerImpl.this.f_10018_.m_129792_()) {
                        f_10015_.warn("Authentication servers are down but will let them in anyway!");
                        ServerLoginPacketListenerImpl.this.m_294008_(ServerLoginPacketListenerImpl.this.m_295545_(s1));
                    } else {
                        ServerLoginPacketListenerImpl.this.m_10053_((Component)Component.m_237115_("multiplayer.disconnect.authservers_down"));
                        f_10015_.error("Couldn't verify username because servers are unavailable");
                    }
                }
                catch (Exception exception) {
                    ServerLoginPacketListenerImpl.this.disconnect("Failed to verify username!");
                    ServerLoginPacketListenerImpl.this.f_10018_.server.getLogger().log(Level.WARNING, "Exception verifying " + s1, exception);
                }
            }

            @Nullable
            private InetAddress m_10064_() {
                SocketAddress socketaddress = ServerLoginPacketListenerImpl.this.f_10013_.m_129523_();
                return ServerLoginPacketListenerImpl.this.f_10018_.m_129798_() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        };
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(f_10015_));
        thread.start();
    }

    public void m_10044_(ServerboundCustomQueryAnswerPacket p_297965_) {
        if (MohistConfig.velocity_enabled && p_297965_.f_290801_() == this.velocityLoginMessageId) {
            ServerboundCustomQueryAnswerPacket.QueryAnswerPayload payload = (ServerboundCustomQueryAnswerPacket.QueryAnswerPayload)p_297965_.f_290461_();
            if (payload == null) {
                this.disconnect("This server requires you to connect with Velocity.");
                return;
            }
            FriendlyByteBuf buf = payload.buffer;
            if (!VelocityProxy.checkIntegrity((FriendlyByteBuf)buf)) {
                this.disconnect("Unable to verify player details");
                return;
            }
            int version = buf.m_130242_();
            if (version > 4) {
                throw new IllegalStateException("Unsupported forwarding version " + version + ", wanted upto 4");
            }
            SocketAddress listening = this.f_10013_.m_129523_();
            int port = 0;
            if (listening instanceof InetSocketAddress) {
                port = ((InetSocketAddress)listening).getPort();
            }
            this.f_10013_.f_129469_ = new InetSocketAddress(VelocityProxy.readAddress((FriendlyByteBuf)buf), port);
            this.f_291112_ = VelocityProxy.createProfile((FriendlyByteBuf)buf);
            authenticatorPool.execute(() -> {
                try {
                    new LoginHandler().fireEvents(this.f_291112_);
                }
                catch (Exception ex) {
                    this.disconnect("Failed to verify username!");
                    this.f_10018_.server.getLogger().log(Level.WARNING, "Exception verifying " + this.f_291112_.getName(), ex);
                }
            });
            return;
        }
        if (!ForgeHooks.onCustomPayload((ICustomPacket)p_297965_, (Connection)this.f_10013_)) {
            this.m_10053_(f_291075_);
        }
    }

    public void m_7223_(ServerboundLoginAcknowledgedPacket p_298815_) {
        Validate.validState((this.f_10019_ == State.PROTOCOL_SWITCHING ? 1 : 0) != 0, (String)"Unexpected login acknowledgement packet", (Object[])new Object[0]);
        CommonListenerCookie commonlistenercookie = CommonListenerCookie.m_294081_((GameProfile)Objects.requireNonNull(this.f_291112_));
        ServerConfigurationPacketListenerImpl serverconfigurationpacketlistenerimpl = new ServerConfigurationPacketListenerImpl(this.f_10018_, this.f_10013_, commonlistenercookie, this.player);
        this.f_10013_.m_129505_((PacketListener)serverconfigurationpacketlistenerimpl);
        serverconfigurationpacketlistenerimpl.m_294295_();
        this.f_10019_ = State.ACCEPTED;
    }

    protected GameProfile m_295545_(String p_297551_) {
        UUID uuid = this.f_10013_.spoofedUUID != null ? this.f_10013_.spoofedUUID : UUIDUtil.m_235879_((String)p_297551_);
        GameProfile gameProfile = new GameProfile(uuid, p_297551_);
        if (this.f_10013_.spoofedProfile != null) {
            for (Property property : this.f_10013_.spoofedProfile) {
                if (!ServerHandshakePacketListenerImpl.PROP_PATTERN.matcher(property.name()).matches()) continue;
                gameProfile.getProperties().put((Object)property.name(), (Object)property);
            }
        }
        return gameProfile;
    }

    static final class State
    extends Enum<State> {
        public static final /* enum */ State HELLO = new State();
        public static final /* enum */ State KEY = new State();
        public static final /* enum */ State AUTHENTICATING = new State();
        public static final /* enum */ State NEGOTIATING = new State();
        public static final /* enum */ State VERIFYING = new State();
        public static final /* enum */ State WAITING_FOR_DUPE_DISCONNECT = new State();
        public static final /* enum */ State PROTOCOL_SWITCHING = new State();
        public static final /* enum */ State ACCEPTED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String p_10079_) {
            return Enum.valueOf(State.class, p_10079_);
        }

        private static /* synthetic */ State[] m_143701_() {
            return new State[]{HELLO, KEY, AUTHENTICATING, NEGOTIATING, VERIFYING, WAITING_FOR_DUPE_DISCONNECT, PROTOCOL_SWITCHING, ACCEPTED};
        }

        static {
            $VALUES = State.m_143701_();
        }
    }

    public class LoginHandler {
        public void fireEvents(GameProfile gameprofile) throws Exception {
            if (ServerLoginPacketListenerImpl.this.velocityLoginMessageId == -1 && MohistConfig.velocity_enabled) {
                ServerLoginPacketListenerImpl.this.disconnect("This server requires you to connect with Velocity.");
                return;
            }
            String playerName = gameprofile.getName();
            InetAddress address = ((InetSocketAddress)ServerLoginPacketListenerImpl.this.f_10013_.m_129523_()).getAddress();
            UUID uniqueId = gameprofile.getId();
            final CraftServer server = ServerLoginPacketListenerImpl.this.f_10018_.server;
            AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId);
            server.getPluginManager().callEvent((Event)asyncEvent);
            if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
                if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                    event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
                }
                Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(){

                    protected PlayerPreLoginEvent.Result evaluate() {
                        server.getPluginManager().callEvent((Event)event);
                        return event.getResult();
                    }
                };
                ServerLoginPacketListenerImpl.this.f_10018_.processQueue.add((Runnable)waitable);
                if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                    ServerLoginPacketListenerImpl.this.disconnect(event.getKickMessage());
                    return;
                }
            } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
                ServerLoginPacketListenerImpl.this.disconnect(asyncEvent.getKickMessage());
                return;
            }
            f_10015_.info("UUID of player {} is {}", (Object)gameprofile.getName(), (Object)gameprofile.getId());
            ServerLoginPacketListenerImpl.this.f_10013_.player = gameprofile;
            ServerLoginPacketListenerImpl.this.m_294008_(gameprofile);
        }
    }
}

