/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.OverlayMetadataSection;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.flag.FeatureFlagSet;
import org.slf4j.Logger;

public class Pack {
    private static final Logger f_10399_ = LogUtils.getLogger();
    private final String f_10401_;
    public final ResourcesSupplier f_244124_;
    private final Component f_10403_;
    private final Info f_291887_;
    private final Position f_10406_;
    private final boolean f_10407_;
    private final boolean f_10408_;
    private final boolean hidden;
    private final PackSource f_10409_;

    @Nullable
    public static Pack m_245429_(String p_249649_, Component p_248632_, boolean p_251594_, ResourcesSupplier p_252210_, PackType p_250595_, Position p_248706_, PackSource p_251233_) {
        int i = SharedConstants.m_183709_().m_264084_(p_250595_);
        Info pack$info = Pack.m_246334_(p_249649_, p_252210_, i);
        return pack$info != null ? Pack.m_245512_(p_249649_, p_248632_, p_251594_, p_252210_, pack$info, p_248706_, false, p_251233_) : null;
    }

    public static Pack m_245512_(String p_252257_, Component p_248717_, boolean p_248811_, ResourcesSupplier p_248969_, Info p_251314_, Position p_252110_, boolean p_250237_, PackSource p_248524_) {
        return new Pack(p_252257_, p_248811_, p_248969_, p_248717_, p_251314_, p_252110_, p_250237_, p_248524_);
    }

    private Pack(String p_252218_, boolean p_248829_, ResourcesSupplier p_249377_, Component p_251718_, Info p_250162_, Position p_251298_, boolean p_249753_, PackSource p_251608_) {
        this.f_10401_ = p_252218_;
        this.f_244124_ = p_249377_;
        this.f_10403_ = p_251718_;
        this.f_291887_ = p_250162_;
        this.f_10407_ = p_248829_;
        this.f_10406_ = p_251298_;
        this.f_10408_ = p_249753_;
        this.f_10409_ = p_251608_;
        this.hidden = p_250162_.hidden();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Info m_246334_(String p_250591_, ResourcesSupplier p_250739_, int p_299232_) {
        try (PackResources packresources = p_250739_.m_293078_(p_250591_);){
            PackMetadataSection packmetadatasection = (PackMetadataSection)packresources.m_5550_(PackMetadataSection.f_243696_);
            if (packmetadatasection == null) {
                f_10399_.warn("Missing metadata in pack {}", (Object)p_250591_);
                Info info = null;
                return info;
            }
            FeatureFlagsMetadataSection featureflagsmetadatasection = (FeatureFlagsMetadataSection)packresources.m_5550_(FeatureFlagsMetadataSection.f_244642_);
            FeatureFlagSet featureflagset = featureflagsmetadatasection != null ? featureflagsmetadatasection.f_244197_() : FeatureFlagSet.m_246902_();
            InclusiveRange<Integer> inclusiverange = Pack.m_295425_(p_250591_, packmetadatasection);
            PackCompatibility packcompatibility = PackCompatibility.m_295204_(inclusiverange, (int)p_299232_);
            OverlayMetadataSection overlaymetadatasection = (OverlayMetadataSection)packresources.m_5550_(OverlayMetadataSection.f_290597_);
            List list = overlaymetadatasection != null ? overlaymetadatasection.m_293385_(p_299232_) : List.of();
            Info info = new Info(packmetadatasection.f_10367_(), packcompatibility, featureflagset, list, packresources.isHidden());
            return info;
        }
        catch (Exception exception) {
            f_10399_.warn("Failed to read pack {} metadata", (Object)p_250591_, (Object)exception);
            return null;
        }
    }

    private static InclusiveRange<Integer> m_295425_(String p_299045_, PackMetadataSection p_298414_) {
        int i = p_298414_.f_10368_();
        if (p_298414_.f_290577_().isEmpty()) {
            return new InclusiveRange((Comparable)Integer.valueOf(i));
        }
        InclusiveRange inclusiverange = (InclusiveRange)p_298414_.f_290577_().get();
        if (!inclusiverange.m_184578_((Comparable)Integer.valueOf(i))) {
            f_10399_.warn("Pack {} declared support for versions {} but declared main format is {}, defaulting to {}", new Object[]{p_299045_, inclusiverange, i, i});
            return new InclusiveRange((Comparable)Integer.valueOf(i));
        }
        return inclusiverange;
    }

    public Component m_10429_() {
        return this.f_10403_;
    }

    public Component m_10442_() {
        return this.f_291887_.f_244592_();
    }

    public Component m_10437_(boolean p_10438_) {
        return ComponentUtils.m_130748_(this.f_10409_.m_10540_((Component)Component.m_237113_(this.f_10401_))).m_130938_(p_296599_ -> p_296599_.m_131140_(p_10438_ ? ChatFormatting.GREEN : ChatFormatting.RED).m_131138_(StringArgumentType.escapeIfRequired((String)this.f_10401_)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237119_().m_7220_(this.f_10403_).m_130946_("\n").m_7220_(this.f_291887_.f_244592_))));
    }

    public PackCompatibility m_10443_() {
        return this.f_291887_.f_290856_();
    }

    public FeatureFlagSet m_245532_() {
        return this.f_291887_.f_244041_();
    }

    public PackResources m_10445_() {
        return this.f_244124_.m_247679_(this.f_10401_, this.f_291887_);
    }

    public String m_10446_() {
        return this.f_10401_;
    }

    public boolean m_10449_() {
        return this.f_10407_;
    }

    public boolean m_10450_() {
        return this.f_10408_;
    }

    public Position m_10451_() {
        return this.f_10406_;
    }

    public PackSource m_10453_() {
        return this.f_10409_;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean equals(Object p_10448_) {
        if (this == p_10448_) {
            return true;
        }
        if (!(p_10448_ instanceof Pack)) {
            return false;
        }
        Pack pack = (Pack)p_10448_;
        return this.f_10401_.equals(pack.f_10401_);
    }

    public int hashCode() {
        return this.f_10401_.hashCode();
    }

    public static interface ResourcesSupplier {
        public PackResources m_293078_(String var1);

        public PackResources m_247679_(String var1, Info var2);
    }

    public record Info(Component f_244592_, PackCompatibility f_290856_, FeatureFlagSet f_244041_, List<String> f_291122_, boolean hidden) {
        public Info(Component f_244592_, PackCompatibility f_290856_, FeatureFlagSet f_244041_, List<String> f_291122_) {
            this(f_244592_, f_290856_, f_244041_, f_291122_, false);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Info.class, "description;compatibility;requestedFeatures;overlays;hidden", "f_244592_", "f_290856_", "f_244041_", "f_291122_", "hidden"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Info.class, "description;compatibility;requestedFeatures;overlays;hidden", "f_244592_", "f_290856_", "f_244041_", "f_291122_", "hidden"}, this);
        }

        @Override
        public final boolean equals(Object p_248947_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Info.class, "description;compatibility;requestedFeatures;overlays;hidden", "f_244592_", "f_290856_", "f_244041_", "f_291122_", "hidden"}, this, p_248947_);
        }
    }

    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position TOP = new Position();
        public static final /* enum */ Position BOTTOM = new Position();
        private static final /* synthetic */ Position[] $VALUES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String p_10476_) {
            return Enum.valueOf(Position.class, p_10476_);
        }

        public <T> int m_10470_(List<T> p_10471_, T p_10472_, Function<T, Pack> p_10473_, boolean p_10474_) {
            Pack pack;
            int i;
            Position pack$position;
            Position position = pack$position = p_10474_ ? this.m_10469_() : this;
            if (pack$position == BOTTOM) {
                Pack pack1;
                int j;
                for (j = 0; j < p_10471_.size() && (pack1 = p_10473_.apply(p_10471_.get(j))).m_10450_() && pack1.m_10451_() == this; ++j) {
                }
                p_10471_.add(j, p_10472_);
                return j;
            }
            for (i = p_10471_.size() - 1; i >= 0 && (pack = p_10473_.apply(p_10471_.get(i))).m_10450_() && pack.m_10451_() == this; --i) {
            }
            p_10471_.add(i + 1, p_10472_);
            return i + 1;
        }

        public Position m_10469_() {
            return this == TOP ? BOTTOM : TOP;
        }

        private static /* synthetic */ Position[] m_143881_() {
            return new Position[]{TOP, BOTTOM};
        }

        static {
            $VALUES = Position.m_143881_();
        }
    }
}

