/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SpawnUtil {
    public static <T extends Mob> Optional<T> m_216403_(EntityType<T> p_216404_, MobSpawnType p_216405_, ServerLevel p_216406_, BlockPos p_216407_, int p_216408_, int p_216409_, int p_216410_, Strategy p_216411_) {
        return SpawnUtil.trySpawnMob(p_216404_, p_216405_, p_216406_, p_216407_, p_216408_, p_216409_, p_216410_, p_216411_, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public static <T extends Mob> Optional<T> trySpawnMob(EntityType<T> pEntityType, MobSpawnType pSpawnType, ServerLevel pLevel, BlockPos pPos, int pAttempts, int p_216409_, int pYOffset, Strategy pStrategy, CreatureSpawnEvent.SpawnReason reason) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        for (int i = 0; i < pAttempts; ++i) {
            Mob t;
            int j = Mth.m_216287_((RandomSource)pLevel.f_46441_, (int)(-p_216409_), (int)p_216409_);
            int k = Mth.m_216287_((RandomSource)pLevel.f_46441_, (int)(-p_216409_), (int)p_216409_);
            blockpos$mutableblockpos.m_122154_((Vec3i)pPos, j, pYOffset, k);
            if (!pLevel.m_6857_().m_61937_((BlockPos)blockpos$mutableblockpos) || !SpawnUtil.m_216398_(pLevel, pYOffset, blockpos$mutableblockpos, pStrategy) || (t = (Mob)pEntityType.m_262451_(pLevel, null, null, (BlockPos)blockpos$mutableblockpos, pSpawnType, false, false)) == null) continue;
            if (ForgeEventFactory.checkSpawnPosition((Mob)t, (ServerLevelAccessor)((Object)pLevel), (MobSpawnType)pSpawnType)) {
                pLevel.addFreshEntityWithPassengers(t, reason);
                return Optional.of(t);
            }
            t.m_146870_();
        }
        return Optional.empty();
    }

    private static boolean m_216398_(ServerLevel p_216399_, int p_216400_, BlockPos.MutableBlockPos p_216401_, Strategy p_216402_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)p_216401_);
        BlockState blockstate = p_216399_.m_8055_((BlockPos)blockpos$mutableblockpos);
        for (int i = p_216400_; i >= -p_216400_; --i) {
            p_216401_.m_122173_(Direction.DOWN);
            blockpos$mutableblockpos.m_122159_((Vec3i)p_216401_, Direction.UP);
            BlockState blockstate1 = p_216399_.m_8055_((BlockPos)p_216401_);
            if (p_216402_.m_216427_(p_216399_, (BlockPos)p_216401_, blockstate1, (BlockPos)blockpos$mutableblockpos, blockstate)) {
                p_216401_.m_122173_(Direction.UP);
                return true;
            }
            blockstate = blockstate1;
        }
        return false;
    }

    public static interface Strategy {
        @Deprecated
        public static final Strategy f_216412_ = (p_289751_, p_289752_, p_289753_, p_289754_, p_289755_) -> {
            if (!(p_289753_.m_60713_(Blocks.f_50033_) || p_289753_.m_60713_(Blocks.f_50128_) || p_289753_.m_60713_(Blocks.f_50185_) || p_289753_.m_60734_() instanceof StainedGlassPaneBlock || p_289753_.m_60734_() instanceof StainedGlassBlock || p_289753_.m_60734_() instanceof LeavesBlock || p_289753_.m_60713_(Blocks.f_50569_) || p_289753_.m_60713_(Blocks.f_50126_) || p_289753_.m_60713_(Blocks.f_50077_) || p_289753_.m_60713_(Blocks.f_50141_) || p_289753_.m_60713_(Blocks.f_50273_) || p_289753_.m_60713_(Blocks.f_50386_) || p_289753_.m_60713_(Blocks.f_50449_) || p_289753_.m_60713_(Blocks.f_152498_) || p_289753_.m_60713_(Blocks.f_50058_))) {
                return !(!p_289755_.m_60795_() && !p_289755_.m_278721_() || !p_289753_.m_280296_() && !p_289753_.m_60713_(Blocks.f_152499_));
            }
            return false;
        };
        public static final Strategy f_216413_ = (p_216416_, p_216417_, p_216418_, p_216419_, p_216420_) -> p_216420_.m_60812_(p_216416_, p_216419_).m_83281_() && Block.m_49918_(p_216418_.m_60812_(p_216416_, p_216417_), Direction.UP);

        public boolean m_216427_(ServerLevel var1, BlockPos var2, BlockState var3, BlockPos var4, BlockState var5);
    }
}

