/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityInteractEvent;

public class InteractWithDoor {
    private static final int f_147585_ = 20;
    private static final double f_147586_ = 3.0;
    private static final double f_147587_ = 2.0;

    public static BehaviorControl<LivingEntity> m_257893_() {
        MutableObject mutableobject = new MutableObject((Object)null);
        MutableInt mutableint = new MutableInt(0);
        return BehaviorBuilder.m_258034_(p_258474_ -> p_258474_.group((App)p_258474_.m_257495_(MemoryModuleType.f_26377_), (App)p_258474_.m_257492_(MemoryModuleType.f_26379_), (App)p_258474_.m_257492_(MemoryModuleType.f_148204_)).apply((Applicative)p_258474_, (p_258460_, p_258461_, p_258462_) -> (p_258469_, p_258470_, p_258471_) -> {
            Path path = (Path)p_258474_.m_258051_(p_258460_);
            Optional<Set<GlobalPos>> optional = p_258474_.m_257828_(p_258461_);
            if (!path.m_77387_() && !path.m_77392_()) {
                DoorBlock doorblock1;
                BlockPos blockpos1;
                BlockState blockstate1;
                if (Objects.equals(mutableobject.getValue(), path.m_77401_())) {
                    mutableint.setValue(20);
                } else if (mutableint.decrementAndGet() > 0) {
                    return false;
                }
                mutableobject.setValue((Object)path.m_77401_());
                Node node = path.m_77402_();
                Node node1 = path.m_77401_();
                BlockPos blockpos = node.m_77288_();
                BlockState blockstate = p_258469_.m_8055_(blockpos);
                if (blockstate.m_204338_(BlockTags.f_13095_, p_201959_ -> p_201959_.m_60734_() instanceof DoorBlock)) {
                    DoorBlock doorblock = (DoorBlock)blockstate.m_60734_();
                    if (!doorblock.m_52815_(blockstate)) {
                        EntityInteractEvent event = new EntityInteractEvent((Entity)p_258470_.getBukkitEntity(), (Block)CraftBlock.at((LevelAccessor)p_258470_.f_19853_, (BlockPos)blockpos));
                        p_258470_.f_19853_.getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return false;
                        }
                        doorblock.m_153165_(p_258470_, p_258469_, blockstate, blockpos, true);
                    }
                    optional = InteractWithDoor.m_261108_((MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>>)p_258461_, optional, p_258469_, blockpos);
                }
                if ((blockstate1 = p_258469_.m_8055_(blockpos1 = node1.m_77288_())).m_204338_(BlockTags.f_13095_, p_201957_ -> p_201957_.m_60734_() instanceof DoorBlock) && !(doorblock1 = (DoorBlock)blockstate1.m_60734_()).m_52815_(blockstate1)) {
                    EntityInteractEvent event = new EntityInteractEvent((Entity)p_258470_.getBukkitEntity(), (Block)CraftBlock.at((LevelAccessor)p_258470_.f_19853_, (BlockPos)blockpos));
                    p_258470_.f_19853_.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return false;
                    }
                    doorblock1.m_153165_(p_258470_, p_258469_, blockstate1, blockpos1, true);
                    optional = InteractWithDoor.m_261108_((MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>>)p_258461_, optional, p_258469_, blockpos1);
                }
                optional.ifPresent(p_258452_ -> InteractWithDoor.m_258036_(p_258469_, p_258470_, node, node1, p_258452_, p_258474_.m_257828_(p_258462_)));
                return true;
            }
            return false;
        }));
    }

    public static void m_258036_(ServerLevel p_260343_, LivingEntity p_259371_, @Nullable Node p_259408_, @Nullable Node p_260013_, Set<GlobalPos> p_259401_, Optional<List<LivingEntity>> p_260015_) {
        Iterator<GlobalPos> iterator = p_259401_.iterator();
        while (iterator.hasNext()) {
            GlobalPos globalpos = iterator.next();
            BlockPos blockpos = globalpos.m_122646_();
            if (p_259408_ != null && p_259408_.m_77288_().equals((Object)blockpos) || p_260013_ != null && p_260013_.m_77288_().equals((Object)blockpos)) continue;
            if (InteractWithDoor.m_23307_(p_260343_, p_259371_, globalpos)) {
                iterator.remove();
                continue;
            }
            BlockState blockstate = p_260343_.m_8055_(blockpos);
            if (!blockstate.m_204338_(BlockTags.f_13095_, p_201952_ -> p_201952_.m_60734_() instanceof DoorBlock)) {
                iterator.remove();
                continue;
            }
            DoorBlock doorblock = (DoorBlock)blockstate.m_60734_();
            if (!doorblock.m_52815_(blockstate)) {
                iterator.remove();
                continue;
            }
            if (InteractWithDoor.m_257369_(p_259371_, blockpos, p_260015_)) {
                iterator.remove();
                continue;
            }
            doorblock.m_153165_(p_259371_, p_260343_, blockstate, blockpos, false);
            iterator.remove();
        }
    }

    private static boolean m_257369_(LivingEntity p_260091_, BlockPos p_259764_, Optional<List<LivingEntity>> p_259365_) {
        return p_259365_.isEmpty() ? false : p_259365_.get().stream().filter(p_296684_ -> p_296684_.m_6095_() == p_260091_.m_6095_()).filter(p_296682_ -> p_259764_.m_203195_((Position)p_296682_.m_20182_(), 2.0)).anyMatch(p_258454_ -> InteractWithDoor.m_257446_(p_258454_.m_6274_(), p_259764_));
    }

    private static boolean m_257446_(Brain<?> p_259548_, BlockPos p_259146_) {
        if (!p_259548_.m_21874_(MemoryModuleType.f_26377_)) {
            return false;
        }
        Path path = (Path)p_259548_.m_21952_(MemoryModuleType.f_26377_).get();
        if (path.m_77392_()) {
            return false;
        }
        Node node = path.m_77402_();
        if (node == null) {
            return false;
        }
        Node node1 = path.m_77401_();
        return p_259146_.equals((Object)node.m_77288_()) || p_259146_.equals((Object)node1.m_77288_());
    }

    private static boolean m_23307_(ServerLevel p_23308_, LivingEntity p_23309_, GlobalPos p_23310_) {
        return p_23310_.m_122640_() != p_23308_.m_46472_() || !p_23310_.m_122646_().m_203195_((Position)p_23309_.m_20182_(), 3.0);
    }

    private static Optional<Set<GlobalPos>> m_261108_(MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>> p_262178_, Optional<Set<GlobalPos>> p_261639_, ServerLevel p_261528_, BlockPos p_261874_) {
        GlobalPos globalpos = GlobalPos.m_122643_(p_261528_.m_46472_(), (BlockPos)p_261874_);
        return Optional.of(p_261639_.map(p_261437_ -> {
            p_261437_.add(globalpos);
            return p_261437_;
        }).orElseGet(() -> {
            HashSet set = Sets.newHashSet((Object[])new GlobalPos[]{globalpos});
            p_262178_.m_257512_((Object)set);
            return set;
        }));
    }
}

