/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;

public class LeashFenceKnotEntity
extends HangingEntity {
    public static final double f_149638_ = 0.375;

    public LeashFenceKnotEntity(EntityType<? extends LeashFenceKnotEntity> p_31828_, Level p_31829_) {
        super((EntityType<? extends HangingEntity>)p_31828_, p_31829_);
    }

    public LeashFenceKnotEntity(Level p_31831_, BlockPos p_31832_) {
        super(EntityType.f_20464_, p_31831_, p_31832_);
        this.m_6034_(p_31832_.m_123341_(), p_31832_.m_123342_(), p_31832_.m_123343_());
    }

    @Override
    protected void m_7087_() {
        this.m_20343_((double)this.f_31698_.m_123341_() + 0.5, (double)this.f_31698_.m_123342_() + 0.375, (double)this.f_31698_.m_123343_() + 0.5);
        double d0 = (double)this.m_6095_().m_20678_() / 2.0;
        double d1 = this.m_6095_().m_20679_();
        this.m_20011_(new AABB(this.m_20185_() - d0, this.m_20186_(), this.m_20189_() - d0, this.m_20185_() + d0, this.m_20186_() + d1, this.m_20189_() + d0));
    }

    @Override
    public void m_6022_(Direction p_31848_) {
    }

    @Override
    public int m_7076_() {
        return 9;
    }

    @Override
    public int m_7068_() {
        return 9;
    }

    @Override
    protected float m_6380_(Pose p_31839_, EntityDimensions p_31840_) {
        return 0.0625f;
    }

    @Override
    public boolean m_6783_(double p_31835_) {
        return p_31835_ < 1024.0;
    }

    @Override
    public void m_5553_(@Nullable Entity p_31837_) {
        this.m_5496_(SoundEvents.f_12033_, 1.0f, 1.0f);
    }

    @Override
    public void m_7380_(CompoundTag p_31852_) {
    }

    @Override
    public void m_7378_(CompoundTag p_31850_) {
    }

    @Override
    public InteractionResult m_6096_(Player p_31842_, InteractionHand p_31843_) {
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        boolean flag = false;
        double d0 = 7.0;
        List list = this.m_9236_().m_45976_(Mob.class, new AABB(this.m_20185_() - 7.0, this.m_20186_() - 7.0, this.m_20189_() - 7.0, this.m_20185_() + 7.0, this.m_20186_() + 7.0, this.m_20189_() + 7.0));
        for (Mob mob : list) {
            if (mob.m_21524_() != p_31842_) continue;
            if (CraftEventFactory.callPlayerLeashEntityEvent((Mob)mob, (Entity)this, (Player)p_31842_, (InteractionHand)p_31843_).isCancelled()) {
                ((ServerPlayer)p_31842_).f_8906_.m_141995_((Packet<?>)new ClientboundSetEntityLinkPacket((Entity)mob, mob.m_21524_()));
                continue;
            }
            mob.m_21463_(this, true);
            flag = true;
        }
        boolean flag1 = false;
        if (!flag) {
            boolean die = true;
            for (Mob mob1 : list) {
                if (!mob1.m_21523_() || mob1.m_21524_() != this) continue;
                if (CraftEventFactory.callPlayerUnleashEntityEvent((Mob)mob1, (Player)p_31842_, (InteractionHand)p_31843_).isCancelled()) {
                    die = false;
                    continue;
                }
                mob1.m_21455_(true, !p_31842_.m_150110_().f_35937_);
                flag1 = true;
            }
            if (die) {
                this.m_146870_();
            }
        }
        if (flag || flag1) {
            this.m_146852_(GameEvent.f_157791_, p_31842_);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public boolean m_7088_() {
        return this.m_9236_().m_8055_(this.f_31698_).m_204336_(BlockTags.f_13039_);
    }

    public static LeashFenceKnotEntity m_31844_(Level p_31845_, BlockPos p_31846_) {
        int i = p_31846_.m_123341_();
        int j = p_31846_.m_123342_();
        int k = p_31846_.m_123343_();
        for (LeashFenceKnotEntity leashfenceknotentity : p_31845_.m_45976_(LeashFenceKnotEntity.class, new AABB((double)i - 1.0, (double)j - 1.0, (double)k - 1.0, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0))) {
            if (!leashfenceknotentity.m_31748_().equals((Object)p_31846_)) continue;
            return leashfenceknotentity;
        }
        LeashFenceKnotEntity leashfenceknotentity1 = new LeashFenceKnotEntity(p_31845_, p_31846_);
        p_31845_.m_7967_(leashfenceknotentity1);
        return leashfenceknotentity1;
    }

    @Override
    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12087_, 1.0f, 1.0f);
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, 0, this.m_31748_());
    }

    @Override
    public Vec3 m_7398_(float p_31863_) {
        return this.m_20318_(p_31863_).m_82520_(0.0, 0.2, 0.0);
    }

    @Override
    public ItemStack m_142340_() {
        return new ItemStack(Items.f_42655_);
    }
}

