/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.slf4j.Logger;

public class BrushableBlockEntity
extends BlockEntity {
    private static final Logger f_276497_ = LogUtils.getLogger();
    private static final String f_276647_ = "LootTable";
    private static final String f_276481_ = "LootTableSeed";
    private static final String f_276606_ = "hit_direction";
    private static final String f_276577_ = "item";
    private static final int f_276551_ = 10;
    private static final int f_276499_ = 40;
    private static final int f_276583_ = 10;
    private int f_276531_;
    private long f_276679_;
    private long f_276557_;
    public ItemStack f_276563_ = ItemStack.f_41583_;
    @Nullable
    private Direction f_276638_;
    @Nullable
    public ResourceLocation f_276466_;
    public long f_276487_;

    public BrushableBlockEntity(BlockPos p_277558_, net.minecraft.world.level.block.state.BlockState p_278093_) {
        super(BlockEntityType.f_271323_, p_277558_, p_278093_);
    }

    public boolean m_276923_(long p_277786_, Player p_277520_, Direction p_277424_) {
        if (this.f_276638_ == null) {
            this.f_276638_ = p_277424_;
        }
        this.f_276679_ = p_277786_ + 40L;
        if (p_277786_ >= this.f_276557_ && this.f_58857_ instanceof ServerLevel) {
            this.f_276557_ = p_277786_ + 10L;
            this.m_276797_(p_277520_);
            int i = this.m_276942_();
            if (++this.f_276531_ >= 10) {
                this.m_276980_(p_277520_);
                return true;
            }
            this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 40);
            int j = this.m_276942_();
            if (i != j) {
                net.minecraft.world.level.block.state.BlockState blockstate = this.m_58900_();
                net.minecraft.world.level.block.state.BlockState blockstate1 = (net.minecraft.world.level.block.state.BlockState)((Object)blockstate.m_61124_((Property)BlockStateProperties.f_271112_, Integer.valueOf(j)));
                this.f_58857_.m_7731_(this.m_58899_(), blockstate1, 3);
            }
            return false;
        }
        return false;
    }

    public void m_276797_(Player p_277940_) {
        if (this.f_276466_ != null && this.f_58857_ != null && !this.f_58857_.m_5776_() && this.f_58857_.m_7654_() != null) {
            LootTable loottable = this.f_58857_.m_7654_().m_278653_().m_278676_(this.f_276466_);
            if (p_277940_ instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)p_277940_;
                CriteriaTriggers.f_10563_.m_54597_(serverplayer, this.f_276466_);
            }
            LootParams lootparams = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, Vec3.m_82512_((Vec3i)this.f_58858_)).m_287239_(p_277940_.m_36336_()).m_287286_(LootContextParams.f_81455_, p_277940_).m_287235_(LootContextParamSets.f_81411_);
            ObjectArrayList<ItemStack> objectarraylist = loottable.m_287214_(lootparams, this.f_276487_);
            this.f_276563_ = switch (objectarraylist.size()) {
                case 0 -> ItemStack.f_41583_;
                case 1 -> (ItemStack)((Object)objectarraylist.get(0));
                default -> {
                    f_276497_.warn("Expected max 1 loot from loot table " + this.f_276466_ + " got " + objectarraylist.size());
                    yield (ItemStack)((Object)objectarraylist.get(0));
                }
            };
            this.f_276466_ = null;
            this.m_6596_();
        }
    }

    private void m_276980_(Player p_277549_) {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            Block block1;
            this.m_276934_(p_277549_);
            net.minecraft.world.level.block.state.BlockState blockstate = this.m_58900_();
            this.f_58857_.m_46796_(3008, this.m_58899_(), Block.m_49956_(blockstate));
            Block block = this.m_58900_().m_60734_();
            if (block instanceof BrushableBlock) {
                BrushableBlock brushableblock = (BrushableBlock)block;
                block1 = brushableblock.m_277074_();
            } else {
                block1 = Blocks.f_50016_;
            }
            this.f_58857_.m_7731_(this.f_58858_, block1.m_49966_(), 3);
        }
    }

    private void m_276934_(Player p_278006_) {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            this.m_276797_(p_278006_);
            if (!this.f_276563_.m_41619_()) {
                double d0 = EntityType.f_20461_.m_20678_();
                double d1 = 1.0 - d0;
                double d2 = d0 / 2.0;
                Direction direction = Objects.requireNonNullElse(this.f_276638_, Direction.UP);
                BlockPos blockpos = this.f_58858_.m_5484_(direction, 1);
                double d3 = (double)blockpos.m_123341_() + 0.5 * d1 + d2;
                double d4 = (double)blockpos.m_123342_() + 0.5 + (double)(EntityType.f_20461_.m_20679_() / 2.0f);
                double d5 = (double)blockpos.m_123343_() + 0.5 * d1 + d2;
                ItemEntity itementity = new ItemEntity(this.f_58857_, d3, d4, d5, this.f_276563_.m_41620_(this.f_58857_.f_46441_.m_188503_(21) + 10));
                itementity.m_20256_(Vec3.f_82478_);
                CraftBlock bblock = CraftBlock.at((LevelAccessor)this.f_58857_, (BlockPos)this.f_58858_);
                CraftEventFactory.handleBlockDropItemEvent((org.bukkit.block.Block)bblock, (BlockState)bblock.getState(), (ServerPlayer)((ServerPlayer)p_278006_), Arrays.asList(itementity));
                this.f_276563_ = ItemStack.f_41583_;
            }
        }
    }

    public void m_277175_() {
        if (this.f_58857_ != null) {
            if (this.f_276531_ != 0 && this.f_58857_.m_46467_() >= this.f_276679_) {
                int i = this.m_276942_();
                this.f_276531_ = Math.max(0, this.f_276531_ - 2);
                int j = this.m_276942_();
                if (i != j) {
                    this.f_58857_.m_7731_(this.m_58899_(), (net.minecraft.world.level.block.state.BlockState)((Object)this.m_58900_().m_61124_((Property)BlockStateProperties.f_271112_, Integer.valueOf(j))), 3);
                }
                int k = 4;
                this.f_276679_ = this.f_58857_.m_46467_() + 4L;
            }
            if (this.f_276531_ == 0) {
                this.f_276638_ = null;
                this.f_276679_ = 0L;
                this.f_276557_ = 0L;
            } else {
                this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), (int)(this.f_276679_ - this.f_58857_.m_46467_()));
            }
        }
    }

    private boolean m_276996_(CompoundTag p_277740_) {
        if (p_277740_.m_128425_(f_276647_, 8)) {
            this.f_276466_ = new ResourceLocation(p_277740_.m_128461_(f_276647_));
            this.f_276487_ = p_277740_.m_128454_(f_276481_);
            return true;
        }
        return false;
    }

    private boolean m_277014_(CompoundTag p_277591_) {
        if (this.f_276466_ == null) {
            return false;
        }
        p_277591_.m_128359_(f_276647_, this.f_276466_.toString());
        if (this.f_276487_ != 0L) {
            p_277591_.m_128356_(f_276481_, this.f_276487_);
        }
        return true;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag compoundtag = super.m_5995_();
        if (this.f_276638_ != null) {
            compoundtag.m_128405_(f_276606_, this.f_276638_.ordinal());
        }
        compoundtag.m_128365_(f_276577_, this.f_276563_.m_41739_(new CompoundTag()));
        return compoundtag;
    }

    public ClientboundBlockEntityDataPacket m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void m_142466_(CompoundTag p_277597_) {
        super.m_142466_(p_277597_);
        if (!this.m_276996_(p_277597_) && p_277597_.m_128441_(f_276577_)) {
            this.f_276563_ = ItemStack.m_41712_(p_277597_.m_128469_(f_276577_));
        }
        if (p_277597_.m_128441_(f_276606_)) {
            this.f_276638_ = Direction.values()[p_277597_.m_128451_(f_276606_)];
        }
    }

    @Override
    protected void m_183515_(CompoundTag p_277339_) {
        if (!this.m_277014_(p_277339_)) {
            p_277339_.m_128365_(f_276577_, this.f_276563_.m_41739_(new CompoundTag()));
        }
    }

    public void m_277049_(ResourceLocation p_277611_, long p_277991_) {
        this.f_276466_ = p_277611_;
        this.f_276487_ = p_277991_;
    }

    private int m_276942_() {
        if (this.f_276531_ == 0) {
            return 0;
        }
        if (this.f_276531_ < 3) {
            return 1;
        }
        return this.f_276531_ < 6 ? 2 : 3;
    }

    @Nullable
    public Direction m_277042_() {
        return this.f_276638_;
    }

    public ItemStack m_277047_() {
        return this.f_276563_;
    }
}

