/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSelector;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R2.CraftGameEvent;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockReceiveGameEvent;

public interface VibrationSystem {
    public static final GameEvent[] f_279664_ = new GameEvent[]{GameEvent.f_276553_, GameEvent.f_276530_, GameEvent.f_276691_, GameEvent.f_276533_, GameEvent.f_276695_, GameEvent.f_276518_, GameEvent.f_276655_, GameEvent.f_276494_, GameEvent.f_276419_, GameEvent.f_276431_, GameEvent.f_276621_, GameEvent.f_276548_, GameEvent.f_276569_, GameEvent.f_276454_, GameEvent.f_276436_};
    public static final ToIntFunction<GameEvent> f_279561_ = (ToIntFunction)Util.m_137469_(new Object2IntOpenHashMap(), p_282267_ -> {
        p_282267_.defaultReturnValue(0);
        p_282267_.put((Object)GameEvent.f_157785_, 1);
        p_282267_.put((Object)GameEvent.f_157786_, 1);
        p_282267_.put((Object)GameEvent.f_157815_, 1);
        p_282267_.put((Object)GameEvent.f_157777_, 2);
        p_282267_.put((Object)GameEvent.f_157770_, 2);
        p_282267_.put((Object)GameEvent.f_157784_, 2);
        p_282267_.put((Object)GameEvent.f_223697_, 3);
        p_282267_.put((Object)GameEvent.f_157778_, 3);
        p_282267_.put((Object)GameEvent.f_223696_, 3);
        p_282267_.put((Object)GameEvent.f_290971_, 4);
        p_282267_.put((Object)GameEvent.f_223705_, 4);
        p_282267_.put((Object)GameEvent.f_291275_, 4);
        p_282267_.put((Object)GameEvent.f_268533_, 5);
        p_282267_.put((Object)GameEvent.f_157811_, 5);
        p_282267_.put((Object)GameEvent.f_223708_, 6);
        p_282267_.put((Object)GameEvent.f_157781_, 6);
        p_282267_.put((Object)GameEvent.f_268500_, 6);
        p_282267_.put((Object)GameEvent.f_223706_, 7);
        p_282267_.put((Object)GameEvent.f_223704_, 8);
        p_282267_.put((Object)GameEvent.f_157806_, 8);
        p_282267_.put((Object)GameEvent.f_157802_, 9);
        p_282267_.put((Object)GameEvent.f_157793_, 9);
        p_282267_.put((Object)GameEvent.f_223703_, 9);
        p_282267_.put((Object)GameEvent.f_157795_, 9);
        p_282267_.put((Object)GameEvent.f_157803_, 10);
        p_282267_.put((Object)GameEvent.f_157796_, 10);
        p_282267_.put((Object)GameEvent.f_223702_, 10);
        p_282267_.put((Object)GameEvent.f_157791_, 10);
        p_282267_.put((Object)GameEvent.f_157776_, 10);
        p_282267_.put((Object)GameEvent.f_223699_, 10);
        p_282267_.put((Object)GameEvent.f_157792_, 11);
        p_282267_.put((Object)GameEvent.f_157794_, 12);
        p_282267_.put((Object)GameEvent.f_157816_, 12);
        p_282267_.put((Object)GameEvent.f_157797_, 13);
        p_282267_.put((Object)GameEvent.f_157769_, 13);
        p_282267_.put((Object)GameEvent.f_157810_, 14);
        p_282267_.put((Object)GameEvent.f_157772_, 14);
        p_282267_.put((Object)GameEvent.f_238175_, 14);
        p_282267_.put((Object)GameEvent.f_223707_, 15);
        p_282267_.put((Object)GameEvent.f_157812_, 15);
        for (int i = 1; i <= 15; ++i) {
            p_282267_.put((Object)VibrationSystem.m_280393_(i), i);
        }
    });

    public Data m_280002_();

    public User m_280445_();

    public static int m_280122_(GameEvent p_281355_) {
        return f_279561_.applyAsInt(p_281355_);
    }

    public static GameEvent m_280393_(int p_282105_) {
        return f_279664_[p_282105_ - 1];
    }

    public static int m_280007_(float p_282483_, int p_282722_) {
        double d0 = 15.0 / (double)p_282722_;
        return Math.max(1, 15 - Mth.m_14107_((double)(d0 * (double)p_282483_)));
    }

    public static interface User {
        public int m_280351_();

        public PositionSource m_280010_();

        public boolean m_280080_(ServerLevel var1, BlockPos var2, GameEvent var3, GameEvent.Context var4);

        public void m_280271_(ServerLevel var1, BlockPos var2, GameEvent var3, @Nullable net.minecraft.world.entity.Entity var4, @Nullable net.minecraft.world.entity.Entity var5, float var6);

        default public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_144302_;
        }

        default public boolean m_280076_() {
            return false;
        }

        default public boolean m_280215_() {
            return false;
        }

        default public int m_280576_(float p_281658_) {
            return Mth.m_14143_((float)p_281658_);
        }

        default public boolean m_280612_(GameEvent p_282750_, GameEvent.Context p_283373_) {
            if (!p_282750_.m_204528_(this.m_280028_())) {
                return false;
            }
            net.minecraft.world.entity.Entity entity = p_283373_.f_223711_();
            if (entity != null) {
                if (entity.m_5833_()) {
                    return false;
                }
                if (entity.m_20161_() && p_282750_.m_204528_(GameEventTags.f_144303_)) {
                    if (this.m_280076_() && entity instanceof ServerPlayer) {
                        ServerPlayer serverplayer = (ServerPlayer)entity;
                        CriteriaTriggers.f_215658_.m_222618_(serverplayer);
                    }
                    return false;
                }
                if (entity.m_213854_()) {
                    return false;
                }
            }
            if (p_283373_.f_223712_() != null) {
                return !p_283373_.f_223712_().m_204336_(BlockTags.f_215836_);
            }
            return true;
        }

        default public void m_280022_() {
        }
    }

    public static interface Ticker {
        public static void m_280259_(Level p_281704_, Data p_282633_, User p_281564_) {
            if (p_281704_ instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)p_281704_;
                if (p_282633_.f_279652_ == null) {
                    Ticker.m_280634_(serverlevel, p_282633_, p_281564_);
                }
                if (p_282633_.f_279652_ != null) {
                    boolean flag = p_282633_.m_280274_() > 0;
                    Ticker.m_280404_(serverlevel, p_282633_, p_281564_);
                    p_282633_.m_280502_();
                    if (p_282633_.m_280274_() <= 0) {
                        flag = Ticker.m_280174_(serverlevel, p_282633_, p_281564_, p_282633_.f_279652_);
                    }
                    if (flag) {
                        p_281564_.m_280022_();
                    }
                }
            }
        }

        private static void m_280634_(ServerLevel p_282775_, Data p_282792_, User p_281845_) {
            p_282792_.m_280457_().m_245156_(p_282775_.m_46467_()).ifPresent(p_282059_ -> {
                p_282792_.m_280036_((VibrationInfo)p_282059_);
                Vec3 vec3 = p_282059_.f_243906_();
                p_282792_.m_280178_(p_281845_.m_280576_(p_282059_.f_243776_()));
                p_282775_.m_8767_(new VibrationParticleOption(p_281845_.m_280010_(), p_282792_.m_280274_()), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                p_281845_.m_280022_();
                p_282792_.m_280457_().m_246080_();
            });
        }

        private static void m_280404_(ServerLevel p_282010_, Data p_282354_, User p_282958_) {
            if (p_282354_.m_280616_()) {
                if (p_282354_.f_279652_ == null) {
                    p_282354_.m_280671_(false);
                } else {
                    double d3;
                    double d2;
                    int j;
                    double d0;
                    double d1;
                    boolean flag;
                    Vec3 vec3 = p_282354_.f_279652_.f_243906_();
                    PositionSource positionsource = p_282958_.m_280010_();
                    Vec3 vec31 = positionsource.m_142502_((Level)p_282010_).orElse(vec3);
                    int i = p_282354_.m_280274_();
                    boolean bl = flag = p_282010_.m_8767_(new VibrationParticleOption(positionsource, i), d1 = Mth.m_14139_((double)(d0 = 1.0 - (double)i / (double)(j = p_282958_.m_280576_(p_282354_.f_279652_.f_243776_()))), (double)vec3.f_82479_, (double)vec31.f_82479_), d2 = Mth.m_14139_((double)d0, (double)vec3.f_82480_, (double)vec31.f_82480_), d3 = Mth.m_14139_((double)d0, (double)vec3.f_82481_, (double)vec31.f_82481_), 1, 0.0, 0.0, 0.0, 0.0) > 0;
                    if (flag) {
                        p_282354_.m_280671_(false);
                    }
                }
            }
        }

        private static boolean m_280174_(ServerLevel p_282967_, Data p_283447_, User p_282301_, VibrationInfo p_281498_) {
            BlockPos blockpos = BlockPos.m_274446_((Position)p_281498_.f_243906_());
            BlockPos blockpos1 = p_282301_.m_280010_().m_142502_((Level)p_282967_).map(BlockPos::m_274446_).orElse(blockpos);
            if (p_282301_.m_280215_() && !Ticker.m_280446_(p_282967_, blockpos1)) {
                return false;
            }
            p_282301_.m_280271_(p_282967_, blockpos, p_281498_.f_243709_(), p_281498_.m_246794_(p_282967_).orElse(null), p_281498_.m_247126_(p_282967_).orElse(null), Listener.m_280659_(blockpos, blockpos1));
            p_283447_.m_280036_(null);
            return true;
        }

        private static boolean m_280446_(Level p_282735_, BlockPos p_281722_) {
            ChunkPos chunkpos = new ChunkPos(p_281722_);
            for (int i = chunkpos.f_45578_ - 1; i <= chunkpos.f_45578_ + 1; ++i) {
                for (int j = chunkpos.f_45579_ - 1; j <= chunkpos.f_45579_ + 1; ++j) {
                    if (p_282735_.m_183438_(ChunkPos.m_45589_((int)i, (int)j)) && p_282735_.m_7726_().m_7131_(i, j) != null) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class Listener
    implements GameEventListener {
        private final VibrationSystem f_279547_;

        public Listener(VibrationSystem p_281843_) {
            this.f_279547_ = p_281843_;
        }

        public PositionSource m_142460_() {
            return this.f_279547_.m_280445_().m_280010_();
        }

        public int m_142078_() {
            return this.f_279547_.m_280445_().m_280351_();
        }

        public boolean m_214068_(ServerLevel p_282254_, GameEvent p_283599_, GameEvent.Context p_283664_, Vec3 p_282426_) {
            Data vibrationsystem$data = this.f_279547_.m_280002_();
            User vibrationsystem$user = this.f_279547_.m_280445_();
            if (vibrationsystem$data.m_280602_() != null) {
                return false;
            }
            if (!vibrationsystem$user.m_280612_(p_283599_, p_283664_)) {
                return false;
            }
            Optional optional = vibrationsystem$user.m_280010_().m_142502_((Level)p_282254_);
            if (optional.isEmpty()) {
                return false;
            }
            Vec3 vec3 = (Vec3)optional.get();
            boolean defaultCancel = !vibrationsystem$user.m_280080_(p_282254_, BlockPos.m_274446_((Position)p_282426_), p_283599_, p_283664_);
            net.minecraft.world.entity.Entity entity = p_283664_.f_223711_();
            BlockReceiveGameEvent event = new BlockReceiveGameEvent(CraftGameEvent.minecraftToBukkit((GameEvent)p_283599_), (Block)CraftBlock.at((LevelAccessor)p_282254_, (BlockPos)BlockPos.m_274446_((Position)vec3)), (Entity)(entity == null ? null : entity.getBukkitEntity()));
            event.setCancelled(defaultCancel);
            p_282254_.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            if (Listener.m_280258_(p_282254_, p_282426_, vec3)) {
                return false;
            }
            this.m_280099_(p_282254_, vibrationsystem$data, p_283599_, p_283664_, p_282426_, vec3);
            return true;
        }

        public void m_280275_(ServerLevel p_282808_, GameEvent p_281875_, GameEvent.Context p_281652_, Vec3 p_281530_) {
            this.f_279547_.m_280445_().m_280010_().m_142502_((Level)p_282808_).ifPresent(p_281936_ -> this.m_280099_(p_282808_, this.f_279547_.m_280002_(), p_281875_, p_281652_, p_281530_, (Vec3)p_281936_));
        }

        private void m_280099_(ServerLevel p_282037_, Data p_283229_, GameEvent p_281778_, GameEvent.Context p_283344_, Vec3 p_281758_, Vec3 p_282990_) {
            p_283229_.f_279593_.m_247691_(new VibrationInfo(p_281778_, (float)p_281758_.m_82554_(p_282990_), p_281758_, p_283344_.f_223711_()), p_282037_.m_46467_());
        }

        public static float m_280659_(BlockPos p_282413_, BlockPos p_281960_) {
            return (float)Math.sqrt(p_282413_.m_123331_((Vec3i)p_281960_));
        }

        private static boolean m_280258_(Level p_283225_, Vec3 p_283328_, Vec3 p_283163_) {
            Vec3 vec3 = new Vec3((double)Mth.m_14107_((double)p_283328_.f_82479_) + 0.5, (double)Mth.m_14107_((double)p_283328_.f_82480_) + 0.5, (double)Mth.m_14107_((double)p_283328_.f_82481_) + 0.5);
            Vec3 vec31 = new Vec3((double)Mth.m_14107_((double)p_283163_.f_82479_) + 0.5, (double)Mth.m_14107_((double)p_283163_.f_82480_) + 0.5, (double)Mth.m_14107_((double)p_283163_.f_82481_) + 0.5);
            for (Direction direction : Direction.values()) {
                Vec3 vec32 = vec3.m_231075_(direction, (double)1.0E-5f);
                if (p_283225_.m_151353_(new ClipBlockStateContext(vec32, vec31, p_283608_ -> p_283608_.m_204336_(BlockTags.f_144272_))).m_6662_() == HitResult.Type.BLOCK) continue;
                return false;
            }
            return true;
        }
    }

    public static final class Data {
        public static Codec<Data> f_279637_ = RecordCodecBuilder.create(p_283387_ -> p_283387_.group((App)VibrationInfo.f_244481_.optionalFieldOf("event").forGetter(p_281665_ -> Optional.ofNullable(p_281665_.f_279652_)), (App)VibrationSelector.f_244309_.fieldOf("selector").forGetter(Data::m_280457_), (App)ExtraCodecs.f_144628_.fieldOf("event_delay").orElse((Object)0).forGetter(Data::m_280274_)).apply((Applicative)p_283387_, (p_281934_, p_282381_, p_282931_) -> new Data(p_281934_.orElse(null), (VibrationSelector)p_282381_, (int)p_282931_, true)));
        public static final String f_279525_ = "listener";
        @Nullable
        VibrationInfo f_279652_;
        private int f_279638_;
        final VibrationSelector f_279593_;
        private boolean f_279613_;

        private Data(@Nullable VibrationInfo p_281967_, VibrationSelector p_283036_, int p_283607_, boolean p_282438_) {
            this.f_279652_ = p_281967_;
            this.f_279638_ = p_283607_;
            this.f_279593_ = p_283036_;
            this.f_279613_ = p_282438_;
        }

        public Data() {
            this(null, new VibrationSelector(), 0, false);
        }

        public VibrationSelector m_280457_() {
            return this.f_279593_;
        }

        @Nullable
        public VibrationInfo m_280602_() {
            return this.f_279652_;
        }

        public void m_280036_(@Nullable VibrationInfo p_282049_) {
            this.f_279652_ = p_282049_;
        }

        public int m_280274_() {
            return this.f_279638_;
        }

        public void m_280178_(int p_282973_) {
            this.f_279638_ = p_282973_;
        }

        public void m_280502_() {
            this.f_279638_ = Math.max(0, this.f_279638_ - 1);
        }

        public boolean m_280616_() {
            return this.f_279613_;
        }

        public void m_280671_(boolean p_281702_) {
            this.f_279613_ = p_281702_;
        }
    }
}

