/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import org.bukkit.event.world.AsyncStructureGenerateEvent;
import org.slf4j.Logger;

public final class StructureStart {
    public static final String f_163590_ = "INVALID";
    public static final StructureStart f_73561_ = new StructureStart(null, new ChunkPos(0, 0), 0, new PiecesContainer(List.of()));
    private static final Logger f_226843_ = LogUtils.getLogger();
    private final Structure f_226844_;
    private final PiecesContainer f_192654_;
    private final ChunkPos f_163592_;
    private int f_73568_;
    @Nullable
    private volatile BoundingBox f_163593_;
    public AsyncStructureGenerateEvent.Cause generationEventCause = AsyncStructureGenerateEvent.Cause.WORLD_GENERATION;

    public StructureStart(Structure p_226846_, ChunkPos p_226847_, int p_226848_, PiecesContainer p_226849_) {
        this.f_226844_ = p_226846_;
        this.f_163592_ = p_226847_;
        this.f_73568_ = p_226848_;
        this.f_192654_ = p_226849_;
    }

    @Nullable
    public static StructureStart m_226857_(StructurePieceSerializationContext p_226858_, CompoundTag p_226859_, long p_226860_) {
        String s = p_226859_.m_128461_("id");
        if (f_163590_.equals(s)) {
            return f_73561_;
        }
        Registry registry = p_226858_.f_192763_().m_175515_(Registries.f_256944_);
        Structure structure = (Structure)registry.m_7745_(new ResourceLocation(s));
        if (structure == null) {
            f_226843_.error("Unknown stucture id: {}", (Object)s);
            return null;
        }
        ChunkPos chunkpos = new ChunkPos(p_226859_.m_128451_("ChunkX"), p_226859_.m_128451_("ChunkZ"));
        int i = p_226859_.m_128451_("references");
        ListTag listtag = p_226859_.m_128437_("Children", 10);
        try {
            PiecesContainer piecescontainer = PiecesContainer.m_192753_((ListTag)listtag, (StructurePieceSerializationContext)p_226858_);
            if (structure instanceof OceanMonumentStructure) {
                piecescontainer = OceanMonumentStructure.m_228956_((ChunkPos)chunkpos, (long)p_226860_, (PiecesContainer)piecescontainer);
            }
            return new StructureStart(structure, chunkpos, i, piecescontainer);
        }
        catch (Exception exception) {
            f_226843_.error("Failed Start with id {}", (Object)s, (Object)exception);
            return null;
        }
    }

    public BoundingBox m_73601_() {
        BoundingBox boundingbox = this.f_163593_;
        if (boundingbox == null) {
            this.f_163593_ = boundingbox = this.f_226844_.m_226569_(this.f_192654_.m_192756_());
        }
        return boundingbox;
    }

    public void m_226850_(WorldGenLevel p_226851_, StructureManager p_226852_, ChunkGenerator p_226853_, RandomSource p_226854_, BoundingBox p_226855_, ChunkPos p_226856_) {
        List list = this.f_192654_.f_192741_();
        if (!list.isEmpty()) {
            BoundingBox boundingbox = ((StructurePiece)list.get((int)0)).f_73383_;
            BlockPos blockpos = boundingbox.m_162394_();
            BlockPos blockpos1 = new BlockPos(blockpos.m_123341_(), boundingbox.m_162396_(), blockpos.m_123343_());
            for (StructurePiece structurepiece : list) {
                if (!structurepiece.m_73547_().m_71049_(p_226855_)) continue;
                structurepiece.m_213694_(p_226851_, p_226852_, p_226853_, p_226854_, p_226855_, p_226856_, blockpos1);
            }
            this.f_226844_.m_214110_(p_226851_, p_226852_, p_226853_, p_226854_, p_226855_, p_226856_, this.f_192654_);
        }
    }

    public CompoundTag m_192660_(StructurePieceSerializationContext p_192661_, ChunkPos p_192662_) {
        CompoundTag compoundtag = new CompoundTag();
        if (this.m_73603_()) {
            if (p_192661_.f_192763_().m_175515_(Registries.f_256944_).m_7981_((Object)this.m_226861_()) == null) {
                throw new RuntimeException("StructureStart \"" + this.getClass().getName() + "\": \"" + this.m_226861_() + "\" unregistered, serializing impossible.");
            }
            compoundtag.m_128359_("id", p_192661_.f_192763_().m_175515_(Registries.f_256944_).m_7981_((Object)this.f_226844_).toString());
            compoundtag.m_128405_("ChunkX", p_192662_.f_45578_);
            compoundtag.m_128405_("ChunkZ", p_192662_.f_45579_);
            compoundtag.m_128405_("references", this.f_73568_);
            compoundtag.m_128365_("Children", this.f_192654_.m_192749_(p_192661_));
            return compoundtag;
        }
        compoundtag.m_128359_("id", f_163590_);
        return compoundtag;
    }

    public boolean m_73603_() {
        return !this.f_192654_.m_192748_();
    }

    public ChunkPos m_163625_() {
        return this.f_163592_;
    }

    public boolean m_73606_() {
        return this.f_73568_ < this.m_73609_();
    }

    public void m_73607_() {
        ++this.f_73568_;
    }

    public int m_73608_() {
        return this.f_73568_;
    }

    protected int m_73609_() {
        return 1;
    }

    public Structure m_226861_() {
        return this.f_226844_;
    }

    public List<StructurePiece> m_73602_() {
        return this.f_192654_.f_192741_();
    }
}

