/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraftforge.event.ForgeEventFactory;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class PlayerDataStorage {
    private static final Logger f_78426_ = LogUtils.getLogger();
    private final File f_78427_;
    protected final DataFixer f_78425_;

    public PlayerDataStorage(LevelStorageSource.LevelStorageAccess p_78430_, DataFixer p_78431_) {
        this.f_78425_ = p_78431_;
        this.f_78427_ = p_78430_.m_78283_(LevelResource.f_78176_).toFile();
        this.f_78427_.mkdirs();
    }

    public void m_78433_(Player p_78434_) {
        if (SpigotConfig.disablePlayerDataSaving) {
            return;
        }
        try {
            CompoundTag compoundtag = p_78434_.m_20240_(new CompoundTag());
            File file1 = File.createTempFile(p_78434_.m_20149_() + "-", ".dat", this.f_78427_);
            NbtIo.m_128944_(compoundtag, file1);
            File file2 = new File(this.f_78427_, p_78434_.m_20149_() + ".dat");
            File file3 = new File(this.f_78427_, p_78434_.m_20149_() + ".dat_old");
            Util.m_137462_(file2, file1, file3);
            ForgeEventFactory.firePlayerSavingEvent((Player)p_78434_, (File)this.f_78427_, (String)p_78434_.m_20149_());
        }
        catch (Exception exception) {
            f_78426_.warn("Failed to save player data for {}", (Object)p_78434_.m_7755_().getString());
        }
    }

    @Nullable
    public CompoundTag m_78435_(Player p_78436_) {
        CompoundTag compoundtag = null;
        try {
            File file1 = new File(this.f_78427_, p_78436_.m_20149_() + ".dat");
            boolean usingWrongFile = false;
            if (!file1.exists() && (file1 = new File(this.f_78427_, UUID.nameUUIDFromBytes(("OfflinePlayer:" + p_78436_.m_6302_()).getBytes("UTF-8")).toString() + ".dat")).exists()) {
                usingWrongFile = true;
                Bukkit.getServer().getLogger().warning("Using offline mode UUID file for player " + p_78436_.m_6302_() + " as it is the only copy we can find.");
            }
            if (file1.exists() && file1.isFile()) {
                compoundtag = NbtIo.m_128937_(file1);
            }
            if (usingWrongFile) {
                file1.renameTo(new File(file1.getPath() + ".offline-read"));
            }
        }
        catch (Exception exception) {
            f_78426_.warn("Failed to load player data for {}", (Object)p_78436_.m_7755_().getString());
        }
        if (compoundtag != null) {
            if (p_78436_ instanceof ServerPlayer) {
                CraftPlayer player = (CraftPlayer)p_78436_.getBukkitEntity();
                long modified = new File(this.f_78427_, p_78436_.m_20148_().toString() + ".dat").lastModified();
                if (modified < player.getFirstPlayed()) {
                    player.setFirstPlayed(modified);
                }
            }
            int i = NbtUtils.m_264487_(compoundtag, (int)-1);
            p_78436_.m_20258_(DataFixTypes.PLAYER.m_264218_(this.f_78425_, compoundtag, i));
        }
        ForgeEventFactory.firePlayerLoadingEvent((Player)p_78436_, (File)this.f_78427_, (String)p_78436_.m_20149_());
        return compoundtag;
    }

    public String[] m_78432_() {
        String[] astring = this.f_78427_.list();
        if (astring == null) {
            astring = new String[]{};
        }
        for (int i = 0; i < astring.length; ++i) {
            if (!astring[i].endsWith(".dat")) continue;
            astring[i] = astring[i].substring(0, astring[i].length() - 4);
        }
        return astring;
    }

    public File getPlayerDataFolder() {
        return this.f_78427_;
    }

    public CompoundTag getPlayerData(String s) {
        try {
            File file1 = new File(this.f_78427_, s + ".dat");
            if (file1.exists()) {
                return NbtIo.m_128939_(new FileInputStream(file1));
            }
        }
        catch (Exception exception) {
            f_78426_.warn("Failed to load player data for " + s);
        }
        return null;
    }

    public File getPlayerDir() {
        return this.getPlayerDataFolder();
    }
}

