/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.bukkit.craftbukkit.v1_20_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.slf4j.Logger;

public class LootDataManager
implements PreparableReloadListener,
LootDataResolver {
    private static final Logger f_278476_ = LogUtils.getLogger();
    private static final Gson f_290375_ = new GsonBuilder().create();
    public static final LootDataId<LootTable> f_278474_ = new LootDataId(LootDataType.f_278413_, BuiltInLootTables.f_78712_);
    private Map<LootDataId<?>, ?> f_278415_ = Map.of();
    private Multimap<LootDataType<?>, ResourceLocation> f_278404_ = ImmutableMultimap.of();
    public Map<?, ResourceLocation> lootTableToKey = ImmutableMap.of();

    public final CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier p_279240_, ResourceManager p_279377_, ProfilerFiller p_279135_, ProfilerFiller p_279088_, Executor p_279148_, Executor p_279169_) {
        HashMap map = new HashMap();
        CompletableFuture[] completablefuture = (CompletableFuture[])LootDataType.m_278779_().map(p_279242_ -> LootDataManager.m_278800_(p_279242_, p_279377_, p_279148_, map)).toArray(CompletableFuture[]::new);
        return ((CompletableFuture)CompletableFuture.allOf(completablefuture).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)p_279240_).m_6769_(arg_0))).thenAcceptAsync(p_279096_ -> this.m_278787_(map), p_279169_);
    }

    private static <T> CompletableFuture<?> m_278800_(LootDataType<T> p_279205_, ResourceManager p_279441_, Executor p_279233_, Map<LootDataType<?>, Map<ResourceLocation, ?>> p_279241_) {
        HashMap map = new HashMap();
        p_279241_.put(p_279205_, map);
        return CompletableFuture.runAsync(() -> {
            HashMap<ResourceLocation, JsonElement> map1 = new HashMap<ResourceLocation, JsonElement>();
            SimpleJsonResourceReloadListener.m_278771_(p_279441_, p_279205_.m_278624_(), f_290375_, map1);
            map1.forEach((p_279416_, p_279151_) -> p_279205_.m_278763_((ResourceLocation)p_279416_, (JsonElement)p_279151_).ifPresent(p_279295_ -> map.put(p_279416_, p_279295_)));
        }, p_279233_);
    }

    private void m_278787_(Map<LootDataType<?>, Map<ResourceLocation, ?>> p_279426_) {
        Object object = p_279426_.get(LootDataType.f_278413_).remove(BuiltInLootTables.f_78712_);
        if (object != null) {
            f_278476_.warn("Datapack tried to redefine {} loot table, ignoring", (Object)BuiltInLootTables.f_78712_);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMultimap.Builder builder1 = ImmutableMultimap.builder();
        p_279426_.forEach((p_279449_, p_279262_) -> p_279262_.forEach((p_279130_, p_279313_) -> {
            builder.put((Object)new LootDataId(p_279449_, p_279130_), p_279313_);
            builder1.put(p_279449_, p_279130_);
        }));
        builder.put(f_278474_, (Object)LootTable.f_79105_);
        ImmutableMap map = builder.build();
        ValidationContext validationcontext = new ValidationContext(LootContextParamSets.f_81420_, new LootDataResolver(){
            final /* synthetic */ Map val$map;
            {
                this.val$map = map;
            }

            @Nullable
            public <T> T m_278667_(LootDataId<T> p_279194_) {
                return (T)this.val$map.get(p_279194_);
            }
        });
        map.forEach((p_279387_, p_279087_) -> LootDataManager.m_278621_(validationcontext, p_279387_, p_279087_));
        validationcontext.m_79352_().forEach((p_279487_, p_279312_) -> f_278476_.warn("Found loot table element validation problem in {}: {}", p_279487_, p_279312_));
        map.forEach((key, lootTable) -> {
            if (object instanceof LootTable) {
                LootTable table = (LootTable)object;
                table.craftLootTable = new CraftLootTable(CraftNamespacedKey.fromMinecraft((ResourceLocation)key.f_278500_()), table);
            }
        });
        this.f_278415_ = map;
        this.f_278404_ = builder1.build();
    }

    private static <T> void m_278621_(ValidationContext p_279270_, LootDataId<T> p_279249_, Object p_279342_) {
        p_279249_.f_278383_().m_278701_(p_279270_, p_279249_, p_279342_);
    }

    @Nullable
    public <T> T m_278667_(LootDataId<T> p_279467_) {
        return (T)this.f_278415_.get(p_279467_);
    }

    public Collection<ResourceLocation> m_278706_(LootDataType<?> p_279455_) {
        return this.f_278404_.get(p_279455_);
    }
}

