/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootingEnchantFunction
extends LootItemConditionalFunction {
    public static final int f_165224_ = 0;
    public static final Codec<LootingEnchantFunction> f_290533_ = RecordCodecBuilder.create(p_298785_ -> LootingEnchantFunction.m_294820_((RecordCodecBuilder.Instance)p_298785_).and(p_298785_.group((App)NumberProviders.f_291751_.fieldOf("count").forGetter(p_300767_ -> p_300767_.f_80776_), (App)ExtraCodecs.m_295827_((Codec)Codec.INT, (String)"limit", (Object)0).forGetter(p_301305_ -> p_301305_.f_80777_))).apply((Applicative)p_298785_, LootingEnchantFunction::new));
    private final NumberProvider f_80776_;
    private final int f_80777_;

    LootingEnchantFunction(List<LootItemCondition> p_299292_, NumberProvider p_165227_, int p_165228_) {
        super(p_299292_);
        this.f_80776_ = p_165227_;
        this.f_80777_ = p_165228_;
    }

    public LootItemFunctionType m_7162_() {
        return LootItemFunctions.f_80741_;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return Sets.union((Set)ImmutableSet.of(LootContextParams.f_81458_), (Set)this.f_80776_.m_6231_());
    }

    boolean m_80798_() {
        return this.f_80777_ > 0;
    }

    public ItemStack m_7372_(ItemStack p_80789_, LootContext p_80790_) {
        Entity entity = p_80790_.m_78953_(LootContextParams.f_81458_);
        if (entity instanceof LivingEntity) {
            int i = p_80790_.getLootingModifier();
            if (p_80790_.m_78936_(LootContextParams.LOOTING_MOD)) {
                i = p_80790_.m_78953_(LootContextParams.LOOTING_MOD);
            }
            if (i <= 0) {
                return p_80789_;
            }
            float f = (float)i * this.f_80776_.m_142688_(p_80790_);
            p_80789_.m_41769_(Math.round(f));
            if (this.m_80798_() && p_80789_.m_41613_() > this.f_80777_) {
                p_80789_.m_41764_(this.f_80777_);
            }
        }
        return p_80789_;
    }

    public static Builder m_165229_(NumberProvider p_165230_) {
        return new Builder(p_165230_);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final NumberProvider f_80801_;
        private int f_80802_ = 0;

        public Builder(NumberProvider p_165232_) {
            this.f_80801_ = p_165232_;
        }

        protected Builder m_6477_() {
            return this;
        }

        public Builder m_80806_(int p_80807_) {
            this.f_80802_ = p_80807_;
            return this;
        }

        public LootItemFunction m_7453_() {
            return new LootingEnchantFunction(this.m_80699_(), this.f_80801_, this.f_80802_);
        }
    }
}

