/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.proxy;

import com.google.common.net.InetAddresses;
import com.mohistmc.MohistConfig;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.ProfilePublicKey;

public class VelocityProxy {
    private static final int SUPPORTED_FORWARDING_VERSION = 1;
    public static final int MODERN_FORWARDING_WITH_KEY = 2;
    public static final int MODERN_FORWARDING_WITH_KEY_V2 = 3;
    public static final int MODERN_LAZY_SESSION = 4;
    public static final byte MAX_SUPPORTED_FORWARDING_VERSION = 4;
    public static final ResourceLocation PLAYER_INFO_CHANNEL = new ResourceLocation("velocity", "player_info");

    public static boolean checkIntegrity(FriendlyByteBuf buf) {
        byte[] signature = new byte[32];
        buf.readBytes(signature);
        byte[] data = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), data);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(MohistConfig.velocity_secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] mySignature = mac.doFinal(data);
            if (!MessageDigest.isEqual(signature, mySignature)) {
                return false;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        return true;
    }

    public static InetAddress readAddress(FriendlyByteBuf buf) {
        return InetAddresses.forString((String)buf.m_130136_(Short.MAX_VALUE));
    }

    public static GameProfile createProfile(FriendlyByteBuf buf) {
        GameProfile profile = new GameProfile(buf.m_130259_(), buf.m_130136_(16));
        VelocityProxy.readProperties(buf, profile);
        return profile;
    }

    private static void readProperties(FriendlyByteBuf buf, GameProfile profile) {
        int properties = buf.m_130242_();
        for (int i1 = 0; i1 < properties; ++i1) {
            String name = buf.m_130136_(Short.MAX_VALUE);
            String value = buf.m_130136_(Short.MAX_VALUE);
            String signature = buf.readBoolean() ? buf.m_130136_(Short.MAX_VALUE) : null;
            profile.getProperties().put((Object)name, (Object)new Property(name, value, signature));
        }
    }

    public static ProfilePublicKey.Data readForwardedKey(FriendlyByteBuf buf) {
        return new ProfilePublicKey.Data(buf);
    }

    public static UUID readSignerUuidOrElse(FriendlyByteBuf buf, UUID orElse) {
        return buf.readBoolean() ? buf.m_130259_() : orElse;
    }
}

