/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.api.color;

import com.mohistmc.api.color.GradientPattern;
import com.mohistmc.api.color.IPattern;
import com.mohistmc.api.color.RainbowPattern;
import com.mohistmc.api.color.SolidPattern;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.ChatColor;

public class ColorsAPI {
    private static final List<String> SPECIAL_COLORS = Arrays.asList("&l", "&n", "&o", "&k", "&m", "\u00a7l", "\u00a7n", "\u00a7o", "\u00a7k", "\u00a7m");
    private static final List<IPattern> PATTERNS = Arrays.asList(new GradientPattern(), new SolidPattern(), new RainbowPattern());

    @Nonnull
    public static String of(@Nonnull String string) {
        for (IPattern pattern : PATTERNS) {
            string = pattern.process(string);
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return string;
    }

    @Nonnull
    public static List<String> of(@Nonnull Collection<String> strings) {
        return strings.stream().map(ColorsAPI::of).collect(Collectors.toList());
    }

    @Nonnull
    public static String color(@Nonnull String string, @Nonnull Color color) {
        return ChatColor.of((Color)color) + string;
    }

    @Nonnull
    public static String color(@Nonnull String string, @Nonnull Color start, @Nonnull Color end) {
        ChatColor[] colors = ColorsAPI.createGradient(start, end, ColorsAPI.withoutSpecialChar(string).length());
        return ColorsAPI.apply(string, colors);
    }

    @Nonnull
    public static String rainbow(@Nonnull String string, float saturation) {
        ChatColor[] colors = ColorsAPI.createRainbow(ColorsAPI.withoutSpecialChar(string).length(), saturation);
        return ColorsAPI.apply(string, colors);
    }

    @Nonnull
    public static ChatColor getColor(@Nonnull String string) {
        return ChatColor.of((Color)new Color(Integer.parseInt(string, 16)));
    }

    @Nonnull
    public static String stripColorFormatting(@Nonnull String string) {
        return string.replaceAll("<#[0-9A-F]{6}>|[&\u00a7][a-f0-9lnokm]|<[/]?[A-Z]{5,8}(:[0-9A-F]{6})?[0-9]*>", "");
    }

    @Nonnull
    private static String apply(@Nonnull String source, ChatColor[] colors) {
        StringBuilder specialColors = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        String[] characters = source.split("");
        int outIndex = 0;
        for (int i = 0; i < characters.length; ++i) {
            if (characters[i].equals("&") || characters[i].equals("\u00a7")) {
                if (i + 1 < characters.length) {
                    if (characters[i + 1].equals("r")) {
                        specialColors.setLength(0);
                    } else {
                        specialColors.append(characters[i]);
                        specialColors.append(characters[i + 1]);
                    }
                    ++i;
                    continue;
                }
                stringBuilder.append(colors[outIndex++]).append((CharSequence)specialColors).append(characters[i]);
                continue;
            }
            stringBuilder.append(colors[outIndex++]).append((CharSequence)specialColors).append(characters[i]);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    private static String withoutSpecialChar(@Nonnull String source) {
        String workingString = source;
        for (String color : SPECIAL_COLORS) {
            if (!workingString.contains(color)) continue;
            workingString = workingString.replace(color, "");
        }
        return workingString;
    }

    @Nonnull
    private static ChatColor[] createRainbow(int step, float saturation) {
        ChatColor[] colors = new ChatColor[step];
        double colorStep = 1.0 / (double)step;
        for (int i = 0; i < step; ++i) {
            Color color = Color.getHSBColor((float)(colorStep * (double)i), saturation, saturation);
            colors[i] = ChatColor.of((Color)color);
        }
        return colors;
    }

    @Nonnull
    private static ChatColor[] createGradient(@Nonnull Color start, @Nonnull Color end, int step) {
        ChatColor[] colors = new ChatColor[step];
        int stepR = Math.abs(start.getRed() - end.getRed()) / (step - 1);
        int stepG = Math.abs(start.getGreen() - end.getGreen()) / (step - 1);
        int stepB = Math.abs(start.getBlue() - end.getBlue()) / (step - 1);
        int[] direction = new int[]{start.getRed() < end.getRed() ? 1 : -1, start.getGreen() < end.getGreen() ? 1 : -1, start.getBlue() < end.getBlue() ? 1 : -1};
        for (int i = 0; i < step; ++i) {
            Color color = new Color(start.getRed() + stepR * i * direction[0], start.getGreen() + stepG * i * direction[1], start.getBlue() + stepB * i * direction[2]);
            colors[i] = ChatColor.of((Color)color);
        }
        return colors;
    }
}

