/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.bukkit.inventory;

import java.util.Objects;
import net.minecraft.world.item.crafting.Ingredient;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.jetbrains.annotations.NotNull;

public record MohistSpecialIngredient(Ingredient ingredient) implements RecipeChoice
{
    @Override
    @NotNull
    public ItemStack getItemStack() {
        net.minecraft.world.item.ItemStack[] items = this.ingredient.m_43908_();
        return items.length > 0 ? CraftItemStack.asCraftMirror(items[0]) : new ItemStack(Material.AIR, 0);
    }

    @Override
    @NotNull
    public RecipeChoice clone() {
        try {
            return (RecipeChoice)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean test(@NotNull ItemStack itemStack) {
        return this.ingredient.test(CraftItemStack.asNMSCopy(itemStack));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MohistSpecialIngredient that = (MohistSpecialIngredient)o;
        return Objects.equals(this.ingredient, that.ingredient);
    }
}

