/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.commands;

import com.mohistmc.api.ItemAPI;
import com.mohistmc.api.gui.GUIItem;
import com.mohistmc.api.gui.ItemStackFactory;
import com.mohistmc.api.gui.Warehouse;
import com.mohistmc.util.I18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ShowsCommand
extends Command {
    private final List<String> params = List.of("sound", "entitys", "blockentitys");

    public ShowsCommand(String name) {
        super(name);
        this.description = "Mohist shows commands";
        this.usageMessage = "/shows [sound|entitys|blockentitys]";
        this.setPermission("mohist.command.shows");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1 && (sender.isOp() || this.testPermission(sender))) {
            for (String param : this.params) {
                if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(param);
            }
        }
        return list;
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + I18n.as("error.notplayer"));
            return false;
        }
        final Player player = (Player)sender;
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "sound": {
                Warehouse wh = new Warehouse("Sounds");
                wh.getGUI().setItem(47, new GUIItem(new ItemStackFactory(Material.REDSTONE).setDisplayName("\u00a7cStop all sounds").toItemStack()){

                    @Override
                    public void ClickAction(ClickType type, Player u, ItemStack itemStack) {
                        u.stopAllSounds();
                    }
                });
                for (final Sound s : Sound.values()) {
                    wh.addItem(new GUIItem(new ItemStackFactory(Material.NOTE_BLOCK).setDisplayName(s.name()).toItemStack()){

                        @Override
                        public void ClickAction(ClickType type, Player u, ItemStack itemStack) {
                            player.playSound(player.getLocation(), s, 1.0f, 1.0f);
                        }
                    });
                }
                wh.openGUI(player);
                return true;
            }
            case "entitys": {
                Map<EntityType, Integer> collect = player.getWorld().getEntities().stream().collect(Collectors.toMap(Entity::getType, entity -> 1, Integer::sum));
                ArrayList<Map.Entry<EntityType, Integer>> infoIds = new ArrayList<Map.Entry<EntityType, Integer>>(collect.entrySet());
                infoIds.sort((o1, o2) -> {
                    Integer p1 = (Integer)o1.getValue();
                    Integer p2 = (Integer)o2.getValue();
                    return p2 - p1;
                });
                LinkedHashMap<EntityType, Integer> newMap = new LinkedHashMap<EntityType, Integer>();
                AtomicInteger allSize = new AtomicInteger(0);
                for (Map.Entry entry : infoIds) {
                    newMap.put((EntityType)entry.getKey(), (Integer)entry.getValue());
                    allSize.addAndGet((Integer)entry.getValue());
                }
                Warehouse wh = new Warehouse("Entitys: " + allSize.getAndSet(0));
                for (Map.Entry entry : newMap.entrySet()) {
                    wh.addItem(new GUIItem(new ItemStackFactory(ItemAPI.getEggMaterial((EntityType)entry.getKey())).setDisplayName("\u00a76Size: \u00a74" + entry.getValue()).setLore(List.of("\u00a77EntityType: \u00a72" + ((EntityType)entry.getKey()).name())).toItemStack()));
                }
                wh.openGUI(player);
                return true;
            }
            case "blockentitys": {
                Map<Material, Integer> collect = Arrays.stream(player.getWorld().getLoadedChunks()).flatMap(chunk -> Arrays.stream(chunk.getTileEntities())).map(BlockState::getBlock).collect(Collectors.toMap(Block::getType, block -> 1, Integer::sum));
                ArrayList<Map.Entry<Material, Integer>> infoIds = new ArrayList<Map.Entry<Material, Integer>>(collect.entrySet());
                infoIds.sort((o1, o2) -> {
                    Integer p1 = (Integer)o1.getValue();
                    Integer p2 = (Integer)o2.getValue();
                    return p2 - p1;
                });
                LinkedHashMap<Material, Integer> newMap = new LinkedHashMap<Material, Integer>();
                AtomicInteger allSize = new AtomicInteger(0);
                for (Map.Entry entry : infoIds) {
                    newMap.put((Material)entry.getKey(), (Integer)entry.getValue());
                    allSize.addAndGet((Integer)entry.getValue());
                }
                Warehouse wh = new Warehouse("BlockEntitys: " + allSize.getAndSet(0));
                for (Map.Entry entry : newMap.entrySet()) {
                    Material material = ((Material)entry.getKey()).name().contains("_WALL") ? Material.getMaterial(((Material)entry.getKey()).name().replace("_WALL", "")) : (Material)entry.getKey();
                    wh.addItem(new GUIItem(new ItemStackFactory(material).setDisplayName("\u00a76Size: \u00a74" + entry.getValue()).setLore(List.of("\u00a77BlockEntity: \u00a72" + entry.getKey())).toItemStack()));
                }
                wh.openGUI(player);
                return true;
            }
        }
        sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
        return false;
    }
}

