/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.eventhandler.dispatcher;

import io.izzel.tools.collection.XmapList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.inventory.ItemStack;

public class EntityEventDispatcher {
    @SubscribeEvent(receiveCanceled=true)
    public void changeTargetEvent(LivingChangeTargetEvent event) {
        EntityTargetEvent.TargetReason reason = event.getReason();
        LivingEntity entityliving = event.getNewTarget();
        if (entityliving instanceof Mob) {
            Mob mob = (Mob)entityliving;
            if (event.isFireCBEvent()) {
                if (reason == EntityTargetEvent.TargetReason.UNKNOWN && mob.m_5448_() != null && entityliving == null) {
                    reason = mob.m_5448_().m_6084_() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
                }
                CraftLivingEntity ctarget = null;
                if (entityliving != null) {
                    ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
                }
                EntityTargetLivingEntityEvent CBevent = new EntityTargetLivingEntityEvent((Entity)event.getEntity().getBukkitEntity(), ctarget, reason);
                Bukkit.getPluginManager().callEvent(CBevent);
                if (CBevent.isCancelled()) {
                    event.setCanceled(true);
                } else if (CBevent.getTarget() != null) {
                    event.setNewTarget(((CraftLivingEntity)CBevent.getTarget()).getHandle());
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onLivingDeath(LivingDropsEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        Collection<ItemEntity> drops = event.getDrops();
        if (!(drops instanceof ArrayList)) {
            drops = new ArrayList<ItemEntity>(drops);
        }
        XmapList itemStackList = XmapList.create((List)((List)drops), ItemStack.class, entity -> CraftItemStack.asCraftMirror(entity.m_32055_()), itemStack -> {
            ItemEntity itemEntity = new ItemEntity(livingEntity.m_9236_(), livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), CraftItemStack.asNMSCopy(itemStack));
            itemEntity.m_32060_();
            return itemEntity;
        });
        CraftLivingEntity craftLivingEntity = livingEntity.getBukkitLivingEntity();
        EntityDeathEvent eventCB = new EntityDeathEvent(craftLivingEntity, (List<ItemStack>)itemStackList, livingEntity.m_213860_());
        Bukkit.getPluginManager().callEvent(eventCB);
        if (drops.isEmpty()) {
            event.setCanceled(true);
        }
    }
}

