/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.Map;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.Nullable;

public class ForgeEventFactoryClient {
    private static boolean post(Event e) {
        return MinecraftForge.EVENT_BUS.post(e);
    }

    private static <E extends Event> E fire(E e) {
        MinecraftForge.EVENT_BUS.post(e);
        return e;
    }

    public static void gatherLayers(Map<EntityType<?>, EntityRenderer<?>> renderers, Map<PlayerSkin.Model, EntityRenderer<? extends Player>> playerRenderers, EntityRendererProvider.Context context) {
        ModLoader.get().postEvent((Event)new EntityRenderersEvent.AddLayers(renderers, playerRenderers, context));
    }

    public static boolean onScreenMouseReleasedPre(Screen guiScreen, double mouseX, double mouseY, int button) {
        return ForgeEventFactoryClient.post(new ScreenEvent.MouseButtonReleased.Pre(guiScreen, mouseX, mouseY, button));
    }

    public static boolean onScreenMouseReleasedPost(Screen guiScreen, double mouseX, double mouseY, int button, boolean handled) {
        Event.Result result = ForgeEventFactoryClient.fire(new ScreenEvent.MouseButtonReleased.Post(guiScreen, mouseX, mouseY, button, handled)).getResult();
        return result == Event.Result.DEFAULT ? handled : result == Event.Result.ALLOW;
    }

    public static boolean onScreenMouseClickedPre(Screen guiScreen, double mouseX, double mouseY, int button) {
        return ForgeEventFactoryClient.post(new ScreenEvent.MouseButtonPressed.Pre(guiScreen, mouseX, mouseY, button));
    }

    public static boolean onScreenMouseClickedPost(Screen guiScreen, double mouseX, double mouseY, int button, boolean handled) {
        Event.Result result = ForgeEventFactoryClient.fire(new ScreenEvent.MouseButtonPressed.Post(guiScreen, mouseX, mouseY, button, handled)).getResult();
        return result == Event.Result.DEFAULT ? handled : result == Event.Result.ALLOW;
    }

    public static boolean onMouseButtonPre(int button, int action, int mods) {
        return ForgeEventFactoryClient.post(new InputEvent.MouseButton.Pre(button, action, mods));
    }

    public static void onMouseButtonPost(int button, int action, int mods) {
        ForgeEventFactoryClient.post(new InputEvent.MouseButton.Post(button, action, mods));
    }

    public static boolean onScreenMouseScrollPre(Screen guiScreen, double mouseX, double mouseY, double deltaX, double deltaY) {
        return ForgeEventFactoryClient.post(new ScreenEvent.MouseScrolled.Pre(guiScreen, mouseX, mouseY, deltaX, deltaY));
    }

    public static void onScreenMouseScrollPost(Screen guiScreen, double mouseX, double mouseY, double deltaX, double deltaY) {
        ForgeEventFactoryClient.post(new ScreenEvent.MouseScrolled.Post(guiScreen, mouseX, mouseY, deltaX, deltaY));
    }

    public static boolean onMouseScroll(MouseHandler mouseHelper, double deltaX, double deltaY) {
        return ForgeEventFactoryClient.post(new InputEvent.MouseScrollingEvent(deltaX, deltaY, mouseHelper.m_91560_(), mouseHelper.m_168090_(), mouseHelper.m_91584_(), mouseHelper.m_91589_(), mouseHelper.m_91594_()));
    }

    public static boolean onScreenMouseDragPre(Screen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        return ForgeEventFactoryClient.post(new ScreenEvent.MouseDragged.Pre(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY));
    }

    public static void onScreenMouseDragPost(Screen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        ForgeEventFactoryClient.post(new ScreenEvent.MouseDragged.Post(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY));
    }

    @Nullable
    public static Screen onScreenOpening(Screen old, Screen screen) {
        ScreenEvent.Opening event = new ScreenEvent.Opening(old, screen);
        if (ForgeEventFactoryClient.post(event)) {
            return null;
        }
        return event.getNewScreen();
    }

    public static void onScreenClose(Screen screen) {
        ForgeEventFactoryClient.post(new ScreenEvent.Closing(screen));
    }
}

