/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.decoration.PaintingVariant;
import org.bukkit.Art;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_20_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;

public class CraftArt {
    public static Art minecraftToBukkit(PaintingVariant minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.f_256836_);
        Art bukkit = Registry.ART.get(CraftNamespacedKey.fromMinecraft(((ResourceKey)registry.m_7854_((Object)minecraft).orElseThrow()).m_135782_()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static Art minecraftHolderToBukkit(Holder<PaintingVariant> minecraft) {
        return CraftArt.minecraftToBukkit((PaintingVariant)minecraft.m_203334_());
    }

    public static PaintingVariant bukkitToMinecraft(Art bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (PaintingVariant)CraftRegistry.getMinecraftRegistry(Registries.f_256836_).m_6612_(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static Holder<PaintingVariant> bukkitToMinecraftHolder(Art bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.f_256836_);
        Holder holder = registry.m_263177_((Object)CraftArt.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.Reference) {
            Holder.Reference holder2 = (Holder.Reference)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + bukkit + ", this can happen if a plugin creates its own painting variant with out properly registering it.");
    }
}

