/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.craftbukkit.v1_20_R2.block.data.CraftBlockData;

public final class CraftVine
extends CraftBlockData
implements MultipleFacing {
    private static final BooleanProperty[] FACES = new BooleanProperty[]{CraftVine.getBoolean(VineBlock.class, "north", true), CraftVine.getBoolean(VineBlock.class, "east", true), CraftVine.getBoolean(VineBlock.class, "south", true), CraftVine.getBoolean(VineBlock.class, "west", true), CraftVine.getBoolean(VineBlock.class, "up", true), CraftVine.getBoolean(VineBlock.class, "down", true)};

    public CraftVine() {
    }

    public CraftVine(BlockState state) {
        super(state);
    }

    @Override
    public boolean hasFace(BlockFace face) {
        BooleanProperty state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + face + ". Check MultipleFacing.getAllowedFaces.");
        }
        return (Boolean)this.get(state);
    }

    @Override
    public void setFace(BlockFace face, boolean has) {
        BooleanProperty state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + face + ". Check MultipleFacing.getAllowedFaces.");
        }
        this.set(state, has);
    }

    @Override
    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i = 0; i < FACES.length; ++i) {
            if (FACES[i] == null || !((Boolean)this.get(FACES[i])).booleanValue()) continue;
            faces.add((Object)BlockFace.values()[i]);
        }
        return faces.build();
    }

    @Override
    public Set<BlockFace> getAllowedFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i = 0; i < FACES.length; ++i) {
            if (FACES[i] == null) continue;
            faces.add((Object)BlockFace.values()[i]);
        }
        return faces.build();
    }
}

