/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.javafmlmod;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraftforge.eventbus.EventBusErrorMessage;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.javafmlmod.AutomaticEventSubscriber;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;

public class FMLModContainer
extends ModContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker LOADING = MarkerManager.getMarker((String)"LOADING");
    private final ModFileScanData scanResults;
    private final IEventBus eventBus;
    private Object modInstance;
    private final Class<?> modClass;

    public FMLModContainer(IModInfo info, String className, ModFileScanData modFileScanResults, ModuleLayer gameLayer) {
        super(info);
        LOGGER.debug(LOADING, "Creating FMLModContainer instance for {}", (Object)className);
        this.scanResults = modFileScanResults;
        this.activityMap.put(ModLoadingStage.CONSTRUCT, this::constructMod);
        this.eventBus = BusBuilder.builder().setExceptionHandler(this::onEventFailed).setTrackPhases(false).markerType(IModBusEvent.class).build();
        this.configHandler = Optional.of(ce -> this.eventBus.post(ce.self()));
        FMLJavaModLoadingContext contextExtension = new FMLJavaModLoadingContext(this);
        this.contextExtension = () -> contextExtension;
        try {
            Module layer = gameLayer.findModule(info.getOwningFile().moduleName()).orElseThrow();
            this.modClass = Class.forName(layer, className);
            LOGGER.trace(LOADING, "Loaded modclass {} with {}", (Object)this.modClass.getName(), (Object)this.modClass.getClassLoader());
        }
        catch (Throwable e) {
            LOGGER.error(LOADING, "Failed to load class {}", (Object)className, (Object)e);
            throw new ModLoadingException(info, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmodclass", e, new Object[0]);
        }
    }

    private void onEventFailed(IEventBus iEventBus, Event event, IEventListener[] iEventListeners, int i, Throwable throwable) {
        LOGGER.error((Message)new EventBusErrorMessage(event, i, iEventListeners, throwable));
    }

    private void constructMod() {
        try {
            block10: {
                LOGGER.trace(LOADING, "Loading mod instance {} of type {}", (Object)this.getModId(), (Object)this.modClass.getName());
                try {
                    this.modInstance = this.modClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException ignored) {
                    Map<Class<FMLModContainer>, FMLModContainer> allowedConstructorArgs = Map.of(IEventBus.class, this.eventBus, ModContainer.class, this, FMLModContainer.class, this);
                    block6: for (Constructor<?> constructor : this.modClass.getDeclaredConstructors()) {
                        Class<?>[] parameterTypes = constructor.getParameterTypes();
                        Object[] constructorArgs = new Object[parameterTypes.length];
                        HashSet foundArgs = new HashSet();
                        for (int i = 0; i < parameterTypes.length; ++i) {
                            FMLModContainer argInstance = allowedConstructorArgs.get(parameterTypes[i]);
                            if (argInstance == null) continue block6;
                            if (foundArgs.contains(parameterTypes[i])) {
                                throw new RuntimeException("Duplicate constructor argument type: " + parameterTypes[i]);
                            }
                            foundArgs.add(parameterTypes[i]);
                            constructorArgs[i] = argInstance;
                        }
                        this.modInstance = constructor.newInstance(constructorArgs);
                    }
                    if (this.modInstance != null) break block10;
                    throw new RuntimeException("Could not find mod constructor. Allowed optional argument classes: " + allowedConstructorArgs.keySet().stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
                }
            }
            LOGGER.trace(LOADING, "Loaded mod instance {} of type {}", (Object)this.getModId(), (Object)this.modClass.getName());
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException wrapped = (InvocationTargetException)e;
                e = Objects.requireNonNullElse(wrapped.getCause(), e);
            }
            LOGGER.error(LOADING, "Failed to create mod instance. ModID: {}, class {}", (Object)this.getModId(), (Object)this.modClass.getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", e, new Object[]{this.modClass});
        }
        try {
            LOGGER.trace(LOADING, "Injecting Automatic event subscribers for {}", (Object)this.getModId());
            AutomaticEventSubscriber.inject(this, this.scanResults, this.modClass.getClassLoader());
            LOGGER.trace(LOADING, "Completed Automatic event subscribers for {}", (Object)this.getModId());
        }
        catch (Throwable e) {
            LOGGER.error(LOADING, "Failed to register automatic subscribers. ModID: {}, class {}", (Object)this.getModId(), (Object)this.modClass.getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", e, new Object[]{this.modClass});
        }
    }

    public boolean matches(Object mod) {
        return mod == this.modInstance;
    }

    public Object getMod() {
        return this.modInstance;
    }

    public IEventBus getEventBus() {
        return this.eventBus;
    }

    protected <T extends Event> void acceptEvent(T e) {
        try {
            LOGGER.trace(LOADING, "Firing event for modid {} : {}", (Object)this.getModId(), e);
            this.eventBus.post(e);
            LOGGER.trace(LOADING, "Fired event for modid {} : {}", (Object)this.getModId(), e);
        }
        catch (Throwable t) {
            LOGGER.error(LOADING, "Caught exception during event {} dispatch for modid {}", e, (Object)this.getModId(), (Object)t);
            throw new ModLoadingException(this.modInfo, this.modLoadingStage, "fml.modloading.errorduringevent", t, new Object[0]);
        }
    }
}

