/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.asm;

import com.mohistmc.asm.Implementer;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class EnumDefinalizer
implements Implementer {
    static final Set<String> ENUM = Set.of("org/bukkit/Material", "org/bukkit/potion/PotionType", "org/bukkit/entity/EntityType", "org/bukkit/entity/Villager$Profession", "org/bukkit/block/Biome", "org/bukkit/Art", "org/bukkit/Statistic", "org/bukkit/inventory/CreativeCategory", "org/bukkit/entity/SpawnCategory", "org/bukkit/entity/EnderDragon$Phase", "org/bukkit/inventory/recipe/CookingBookCategory", "org/bukkit/Fluid");

    @Override
    public boolean processClass(ClassNode node, ILaunchPluginService.ITransformerLoader transformerLoader) {
        if (ENUM.contains(node.name)) {
            boolean find = false;
            for (FieldNode field : node.fields) {
                if (!Modifier.isStatic(field.access) || !Modifier.isFinal(field.access) || !field.name.equals("ENUM$VALUES") && !field.name.equals("$VALUES")) continue;
                field.access &= 0xFFFFFFEF;
                if (find) {
                    throw new IllegalStateException("Duplicate static final field found for " + node.name + ": " + field.name);
                }
                find = true;
            }
            if (!find) {
                throw new IllegalStateException("No static final field found for " + node.name);
            }
            return true;
        }
        return false;
    }
}

