/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.ClasspathLocatorUtils;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileModLocator;
import org.slf4j.Logger;

public class ClasspathLocator
extends AbstractJarFileModLocator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Path> legacyClasspath = Arrays.stream(System.getProperty("legacyClassPath", "").split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).toList();
    private boolean enabled = false;

    public String name() {
        return "userdev classpath";
    }

    @Override
    public Stream<Path> scanCandidates() {
        if (!this.enabled) {
            return Stream.of(new Path[0]);
        }
        try {
            ArrayList<Path> claimed = new ArrayList<Path>(this.legacyClasspath);
            Stream.Builder paths = Stream.builder();
            this.findPaths(claimed, "META-INF/mods.toml").forEach(paths::add);
            this.findPaths(claimed, "META-INF/MANIFEST.MF").forEach(paths::add);
            return paths.build();
        }
        catch (IOException e) {
            LOGGER.error(LogMarkers.SCAN, "Error trying to find resources", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<Path> findPaths(List<Path> claimed, String resource) throws IOException {
        ArrayList<Path> ret = new ArrayList<Path>();
        Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources(resource);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            Path path = ClasspathLocatorUtils.findJarPathFor(resource, resource, url);
            if (claimed.stream().anyMatch(path::equals) || !Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) continue;
            ret.add(path);
        }
        return ret;
    }

    public void initArguments(Map<String, ?> arguments) {
        String launchTarget = (String)arguments.get("launchTarget");
        this.enabled = launchTarget != null && launchTarget.contains("dev");
    }
}

