/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalDoubleCharMapOps;
import com.koloboke.collect.map.DoubleCharMap;
import com.koloboke.function.DoubleCharConsumer;
import com.koloboke.function.DoubleCharPredicate;
import java.util.Map;

public final class CommonDoubleCharMapOps {
    public static boolean containsAllEntries(final InternalDoubleCharMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof DoubleCharMap) {
            DoubleCharMap m2 = (DoubleCharMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalDoubleCharMapOps) {
                return ((InternalDoubleCharMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new DoubleCharPredicate(){

                public boolean test(double a, char b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Double)e.getKey(), ((Character)e.getValue()).charValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalDoubleCharMapOps map, Map<? extends Double, ? extends Character> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof DoubleCharMap) {
            if (another instanceof InternalDoubleCharMapOps) {
                ((InternalDoubleCharMapOps)another).reversePutAllTo(map);
            } else {
                ((DoubleCharMap)another).forEach(new DoubleCharConsumer(){

                    public void accept(double key, char value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Double, ? extends Character> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue().charValue());
            }
        }
    }

    private CommonDoubleCharMapOps() {
    }
}

