/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalIntObjMapOps;
import com.koloboke.collect.map.IntObjMap;
import com.koloboke.function.IntObjConsumer;
import com.koloboke.function.IntObjPredicate;
import java.util.Map;

public final class CommonIntObjMapOps {
    public static boolean containsAllEntries(final InternalIntObjMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof IntObjMap) {
            IntObjMap m2 = (IntObjMap)another;
            if (m2.valueEquivalence().equals((Object)map.valueEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalIntObjMapOps) {
                    return ((InternalIntObjMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new IntObjPredicate(){

                public boolean test(int a, Object b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Integer)e.getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <V> void putAll(final InternalIntObjMapOps<V> map, Map<? extends Integer, ? extends V> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof IntObjMap) {
            if (another instanceof InternalIntObjMapOps) {
                ((InternalIntObjMapOps)another).reversePutAllTo(map);
            } else {
                ((IntObjMap)another).forEach(new IntObjConsumer<V>(){

                    public void accept(int key, V value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<Integer, V> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonIntObjMapOps() {
    }
}

