/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalLongDoubleMapOps;
import com.koloboke.collect.map.LongDoubleMap;
import com.koloboke.function.LongDoubleConsumer;
import com.koloboke.function.LongDoublePredicate;
import java.util.Map;

public final class CommonLongDoubleMapOps {
    public static boolean containsAllEntries(final InternalLongDoubleMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof LongDoubleMap) {
            LongDoubleMap m2 = (LongDoubleMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalLongDoubleMapOps) {
                return ((InternalLongDoubleMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new LongDoublePredicate(){

                public boolean test(long a, double b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((long)((Long)e.getKey()), (Double)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalLongDoubleMapOps map, Map<? extends Long, ? extends Double> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof LongDoubleMap) {
            if (another instanceof InternalLongDoubleMapOps) {
                ((InternalLongDoubleMapOps)another).reversePutAllTo(map);
            } else {
                ((LongDoubleMap)another).forEach(new LongDoubleConsumer(){

                    public void accept(long key, double value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Long, ? extends Double> e : another.entrySet()) {
                map.justPut((long)e.getKey(), e.getValue());
            }
        }
    }

    private CommonLongDoubleMapOps() {
    }
}

