/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalShortDoubleMapOps;
import com.koloboke.collect.map.ShortDoubleMap;
import com.koloboke.function.ShortDoubleConsumer;
import com.koloboke.function.ShortDoublePredicate;
import java.util.Map;

public final class CommonShortDoubleMapOps {
    public static boolean containsAllEntries(final InternalShortDoubleMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ShortDoubleMap) {
            ShortDoubleMap m2 = (ShortDoubleMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalShortDoubleMapOps) {
                return ((InternalShortDoubleMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ShortDoublePredicate(){

                public boolean test(short a, double b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((short)((Short)e.getKey()), (Double)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalShortDoubleMapOps map, Map<? extends Short, ? extends Double> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ShortDoubleMap) {
            if (another instanceof InternalShortDoubleMapOps) {
                ((InternalShortDoubleMapOps)another).reversePutAllTo(map);
            } else {
                ((ShortDoubleMap)another).forEach(new ShortDoubleConsumer(){

                    public void accept(short key, double value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Short, ? extends Double> e : another.entrySet()) {
                map.justPut((short)e.getKey(), e.getValue());
            }
        }
    }

    private CommonShortDoubleMapOps() {
    }
}

