/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalShortLongMapOps;
import com.koloboke.collect.map.ShortLongMap;
import com.koloboke.function.ShortLongConsumer;
import com.koloboke.function.ShortLongPredicate;
import java.util.Map;

public final class CommonShortLongMapOps {
    public static boolean containsAllEntries(final InternalShortLongMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ShortLongMap) {
            ShortLongMap m2 = (ShortLongMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalShortLongMapOps) {
                return ((InternalShortLongMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ShortLongPredicate(){

                public boolean test(short a, long b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Short)e.getKey(), (Long)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalShortLongMapOps map, Map<? extends Short, ? extends Long> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ShortLongMap) {
            if (another instanceof InternalShortLongMapOps) {
                ((InternalShortLongMapOps)another).reversePutAllTo(map);
            } else {
                ((ShortLongMap)another).forEach(new ShortLongConsumer(){

                    public void accept(short key, long value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Short, ? extends Long> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonShortLongMapOps() {
    }
}

