/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.hash.HashConfigWrapper;

final class Capacities {
    static int chooseBetter(HashConfigWrapper conf, int size, int desiredCapacity, int lesserCapacity, int greaterCapacity, int onFail) {
        assert (0 <= size);
        assert (size < lesserCapacity && lesserCapacity < desiredCapacity);
        assert (desiredCapacity < greaterCapacity);
        if (greaterCapacity - desiredCapacity <= desiredCapacity - lesserCapacity && greaterCapacity <= conf.maxCapacity(size)) {
            return greaterCapacity;
        }
        return lesserCapacity >= conf.minCapacity(size) ? lesserCapacity : onFail;
    }

    static long chooseBetter(HashConfigWrapper conf, long size, long desiredCapacity, long lesserCapacity, long greaterCapacity, long onFail) {
        assert (0L <= size);
        assert (size < lesserCapacity && lesserCapacity < desiredCapacity);
        assert (desiredCapacity < greaterCapacity);
        if (greaterCapacity - desiredCapacity <= desiredCapacity - lesserCapacity && greaterCapacity <= conf.maxCapacity(size)) {
            return greaterCapacity;
        }
        return lesserCapacity >= conf.minCapacity(size) ? lesserCapacity : onFail;
    }

    private Capacities() {
    }
}

