/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ByteCollection;
import com.koloboke.collect.ByteCursor;
import com.koloboke.collect.ByteIterator;
import com.koloboke.collect.impl.hash.ImmutableParallelKVByteLHashSO;
import com.koloboke.collect.set.ByteSet;
import com.koloboke.collect.set.hash.HashByteSet;
import com.koloboke.function.ByteConsumer;
import com.koloboke.function.BytePredicate;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public abstract class ImmutableParallelKVByteLHashGO
extends ImmutableParallelKVByteLHashSO {
    @Override
    @Nonnull
    public char[] table() {
        return this.table;
    }

    public int capacity() {
        return this.table.length;
    }

    public void forEach(Consumer<? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            action.accept((Byte)key);
        }
    }

    public void forEach(ByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            action.accept(key);
        }
    }

    public boolean forEachWhile(BytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    public boolean allContainingIn(ByteCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(ByteCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            changed |= c.add(key);
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(ByteSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            changed |= s.removeByte(key);
        }
        return changed;
    }

    public ByteIterator iterator() {
        return new NoRemovedIterator();
    }

    public ByteCursor setCursor() {
        return new NoRemovedCursor();
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public byte[] toByteArray() {
        int size = this.size();
        byte[] result = new byte[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        return result;
    }

    @Nonnull
    public byte[] toArray(byte[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new byte[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0;
            }
            return a;
        }
        int resultIndex = 0;
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            hashCode += key;
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            sb.append(' ').append(key).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(byte var1);

    public boolean removeIf(Predicate<? super Byte> filter) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(BytePredicate filter) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashByteSet thisC, @Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashByteSet thisC, @Nonnull ByteCollection c) {
        throw new UnsupportedOperationException();
    }

    boolean retainAll(@Nonnull HashByteSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof ByteCollection) {
            return this.retainAll(thisC, (ByteCollection)c);
        }
        throw new UnsupportedOperationException();
    }

    private boolean retainAll(@Nonnull HashByteSet thisC, @Nonnull ByteCollection c) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedCursor
    implements ByteCursor {
        final char[] tab;
        final byte free;
        int index;
        byte curKey;

        NoRemovedCursor() {
            byte free;
            this.tab = ImmutableParallelKVByteLHashGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableParallelKVByteLHashGO.this.freeValue);
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedIterator
    implements ByteIterator {
        final char[] tab;
        final byte free;
        int nextIndex;
        byte next;

        NoRemovedIterator() {
            this.tab = ImmutableParallelKVByteLHashGO.this.table;
            char[] tab = ImmutableParallelKVByteLHashGO.this.table;
            byte free = this.free = ImmutableParallelKVByteLHashGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                byte key = (byte)entry;
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] tab = this.tab;
                byte free = this.free;
                byte prev = this.next;
                while (--nextI >= 0) {
                    char entry = tab[nextI];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.next = key;
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Byte)key);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

