/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.CharCollection;
import com.koloboke.collect.CharCursor;
import com.koloboke.collect.CharIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractCharValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCharMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCharMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableQHashSeparateKVObjCharMapSO;
import com.koloboke.collect.impl.hash.ObjHash;
import com.koloboke.collect.impl.hash.SeparateKVObjCharQHash;
import com.koloboke.collect.map.ObjCharCursor;
import com.koloboke.collect.set.CharSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.CharBinaryOperator;
import com.koloboke.function.CharConsumer;
import com.koloboke.function.CharPredicate;
import com.koloboke.function.ObjCharConsumer;
import com.koloboke.function.ObjCharPredicate;
import com.koloboke.function.ObjCharToCharFunction;
import com.koloboke.function.ToCharFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableQHashSeparateKVObjCharMapGO<K>
extends ImmutableQHashSeparateKVObjCharMapSO<K> {
    @Override
    final void copy(SeparateKVObjCharQHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjCharQHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    public boolean containsEntry(Object key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Character get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return null;
    }

    public char getChar(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Character getOrDefault(Object key, Character defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return defaultValue;
    }

    public char getOrDefault(Object key, char defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super K, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, Character.valueOf(vals[i]));
        }
    }

    @Override
    public void forEach(ObjCharConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, vals[i]);
        }
    }

    @Override
    public boolean forEachWhile(ObjCharPredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ObjCharCursor<K> cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjCharMapOps.containsAllEntries((InternalObjCharMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalObjCharMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalObjCharMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<K, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            hashCode += this.nullableKeyHashCode(key) ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Character put(K key, Character value) {
        throw new UnsupportedOperationException();
    }

    public char put(K key, char value) {
        throw new UnsupportedOperationException();
    }

    public Character putIfAbsent(K key, Character value) {
        throw new UnsupportedOperationException();
    }

    public char putIfAbsent(K key, char value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(K key, char value) {
        throw new UnsupportedOperationException();
    }

    public Character compute(K key, BiFunction<? super K, ? super Character, ? extends Character> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    Character computeNullKey(BiFunction<? super K, ? super Character, ? extends Character> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char compute(K key, ObjCharToCharFunction<? super K> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    char computeNullKey(ObjCharToCharFunction<? super K> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Character computeIfAbsent(K key, Function<? super K, ? extends Character> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    Character computeIfAbsentNullKey(Function<? super K, ? extends Character> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char computeIfAbsent(K key, ToCharFunction<? super K> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    char computeIfAbsentNullKey(ToCharFunction<? super K> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Character computeIfPresent(K key, BiFunction<? super K, ? super Character, ? extends Character> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char computeIfPresent(K key, ObjCharToCharFunction<? super K> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Character merge(K key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    Character mergeNullKey(Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char merge(K key, char value, CharBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    char mergeNullKey(char value, CharBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char addValue(K key, char value) {
        throw new UnsupportedOperationException();
    }

    char addValueNullKey(char value) {
        throw new UnsupportedOperationException();
    }

    public char addValue(K key, char addition, char initialValue) {
        throw new UnsupportedOperationException();
    }

    char addValueWithInitialNullKey(char addition, char initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends K, ? extends Character> m) {
        CommonObjCharMapOps.putAll((InternalObjCharMapOps)this, m);
    }

    public Character replace(K key, Character value) {
        throw new UnsupportedOperationException();
    }

    public char replace(K key, char value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(K key, Character oldValue, Character newValue) {
        return this.replace(key, oldValue.charValue(), newValue.charValue());
    }

    public boolean replace(K key, char oldValue, char newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super K, ? super Character, ? extends Character> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ObjCharToCharFunction<? super K> function) {
        throw new UnsupportedOperationException();
    }

    public Character remove(Object key) {
        throw new UnsupportedOperationException();
    }

    Character removeNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(Object key) {
        throw new UnsupportedOperationException();
    }

    boolean justRemoveNullKey() {
        throw new UnsupportedOperationException();
    }

    public char removeAsChar(Object key) {
        throw new UnsupportedOperationException();
    }

    char removeAsCharNullKey() {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove(key, ((Character)value).charValue());
    }

    public boolean remove(Object key, char value) {
        throw new UnsupportedOperationException();
    }

    boolean removeEntryNullKey(char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(ObjCharPredicate<? super K> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ObjCharCursor<K> {
        final Object[] keys;
        final char[] vals;
        int index;
        Object curKey;
        char curValue;

        NoRemovedMapCursor() {
            this.keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjCharConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey == ObjHash.FREE) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            Object[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        final Object[] keys;
        final char[] vals;
        int index;
        Object curKey;
        char curValue;

        NoRemovedValueCursor() {
            this.keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public char elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            Object[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        final Object[] keys;
        final char[] vals;
        int nextIndex;
        char next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                Object[] keys = this.keys;
                char prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == ObjHash.FREE) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Character>> {
        final Object[] keys;
        final char[] vals;
        int index;
        Object curKey;
        char curValue;

        NoRemovedEntryCursor() {
            this.keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Character> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            Object[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Character>> {
        final Object[] keys;
        final char[] vals;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Character> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                Object[] keys = this.keys;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    Object key = keys[nextI];
                    if (key == ObjHash.FREE) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableQHashSeparateKVObjCharMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVObjCharMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVObjCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return ImmutableQHashSeparateKVObjCharMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Character.valueOf(vals[i]));
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeChar(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public CharCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = Character.valueOf(vals[i]);
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = Character.valueOf(vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return ImmutableQHashSeparateKVObjCharMapGO.this.removeValue(v);
        }

        public void clear() {
            ImmutableQHashSeparateKVObjCharMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Character> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(CharPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ObjCharEntry {
        private K key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ObjCharEntry {
        private final K key;
        private final char value;

        ImmutableEntry(K key, char value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    abstract class ObjCharEntry
    extends AbstractEntry<K, Character> {
        ObjCharEntry() {
        }

        abstract K key();

        public final K getKey() {
            return this.key();
        }

        abstract char value();

        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                char v2 = ((Character)e2.getValue()).charValue();
                return ImmutableQHashSeparateKVObjCharMapGO.this.nullableKeyEquals(k2, this.key()) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return ImmutableQHashSeparateKVObjCharMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode((char)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Character>>
    implements HashObjSet<Map.Entry<K, Character>>,
    InternalObjCollectionOps<Map.Entry<K, Character>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<K, Character>> equivalence() {
            return Equivalence.entryEquivalence(ImmutableQHashSeparateKVObjCharMapGO.this.keyEquivalence(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVObjCharMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableQHashSeparateKVObjCharMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVObjCharMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVObjCharMapGO.this.containsEntry(e.getKey(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, vals[i])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || predicate.test((Map.Entry)((Object)new ImmutableEntry(key, vals[i])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<K, Character>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Character>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableQHashSeparateKVObjCharMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            Object[] keys = ImmutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = ImmutableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Collection)");
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVObjCharMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                char value = ((Character)e.getValue()).charValue();
                return ImmutableQHashSeparateKVObjCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Character>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

