/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.ImmutableLHash;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.SeparateKVShortLHash;

public abstract class ImmutableSeparateKVShortLHashSO
extends ImmutableLHash
implements SeparateKVShortLHash,
PrimitiveConstants,
UnsafeConstants {
    short freeValue;
    short[] set;

    void copy(SeparateKVShortLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (short[])hash.keys().clone();
    }

    void move(SeparateKVShortLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, short freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public short freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public short removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Short)key);
    }

    public boolean contains(short key) {
        return this.index(key) >= 0;
    }

    int index(short key) {
        short free = this.freeValue;
        if (key != free) {
            short[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVShortKeyMixing.mix((short)key) & capacityMask;
            short cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }
}

