/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.LongCollection;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.hash.ImmutableLHashLongSet;
import com.koloboke.collect.impl.hash.ImmutableLHashLongSetGO;
import com.koloboke.collect.impl.hash.LongLHashFactory;
import com.koloboke.collect.impl.hash.MutableLHashLongSet;
import com.koloboke.collect.impl.hash.MutableLHashLongSetGO;
import com.koloboke.collect.impl.hash.SeparateKVLongLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashLongSet;
import com.koloboke.collect.impl.hash.UpdatableLHashLongSetGO;
import com.koloboke.collect.set.hash.HashLongSetFactory;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class LHashLongSetFactorySO
extends LongLHashFactory
implements HashLongSetFactory {
    LHashLongSetFactorySO(HashConfig hashConf, int defaultExpectedSize, long lower, long upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    MutableLHashLongSetGO uninitializedMutableSet() {
        return new MutableLHashLongSet();
    }

    UpdatableLHashLongSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashLongSet();
    }

    ImmutableLHashLongSetGO uninitializedImmutableSet() {
        return new ImmutableLHashLongSet();
    }

    @Nonnull
    public MutableLHashLongSetGO newMutableSet(int expectedSize) {
        MutableLHashLongSet set = new MutableLHashLongSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableLHashLongSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashLongSet set = new UpdatableLHashLongSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableLHashLongSetGO newUpdatableSet(Iterable<Long> elements, int expectedSize) {
        if (elements instanceof LongCollection) {
            SeparateKVLongLHash hash;
            if (elements instanceof SeparateKVLongLHash && (hash = (SeparateKVLongLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashLongSet set = new UpdatableLHashLongSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashLongSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashLongSetGO set = this.newUpdatableSet(size);
        for (long e : elements) {
            set.add(e);
        }
        return set;
    }
}

