/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.IntCollection;
import com.koloboke.collect.IntCursor;
import com.koloboke.collect.impl.CommonIntCollectionOps;
import com.koloboke.collect.impl.CommonSetOps;
import com.koloboke.collect.impl.InternalIntCollectionOps;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableIntLHashSetSO;
import com.koloboke.collect.impl.hash.SeparateKVIntLHash;
import com.koloboke.collect.set.IntSet;
import com.koloboke.collect.set.hash.HashIntSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Set;
import javax.annotation.Nonnull;

public class MutableLHashIntSetGO
extends MutableIntLHashSetSO
implements HashIntSet,
InternalIntCollectionOps {
    @Override
    final void copy(SeparateKVIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals((Set)((Object)this), (Object)obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonIntCollectionOps.containsAll((IntCollection)this, c);
    }

    @Nonnull
    public IntCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Integer e) {
        return this.add((int)e);
    }

    public boolean add(int key) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVIntKeyMixing.mix((int)key) & capacityMask;
        int cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != free) {
                if (cur != key) continue;
                return false;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Integer> c) {
        return CommonIntCollectionOps.addAll((IntCollection)this, c);
    }

    public boolean remove(Object key) {
        return this.removeInt((Integer)key);
    }

    @Override
    boolean justRemove(int key) {
        return this.removeInt(key);
    }

    public boolean removeInt(int key) {
        int free = this.freeValue;
        if (key != free) {
            int keyToShift;
            int indexToRemove;
            int[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVIntKeyMixing.mix((int)key) & capacityMask;
            int cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        if (c instanceof IntCollection) {
            InternalIntCollectionOps c2;
            if (c instanceof InternalIntCollectionOps && (c2 = (InternalIntCollectionOps)c).size() < this.size()) {
                return c2.reverseRemoveAllFrom((IntSet)this);
            }
            return this.removeAll((HashIntSet)this, (IntCollection)c);
        }
        return this.removeAll((HashIntSet)this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

