/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.InternalIntFloatMapOps;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHashParallelKVIntKeyMap;
import com.koloboke.collect.impl.hash.ParallelKVIntFloatLHash;
import com.koloboke.collect.map.hash.HashIntFloatMap;
import java.util.ConcurrentModificationException;

public abstract class MutableLHashParallelKVIntFloatMapSO
extends MutableLHashParallelKVIntKeyMap
implements HashIntFloatMap,
InternalIntFloatMapOps,
ParallelKVIntFloatLHash {
    int valueIndex(int value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            if ((int)entry == free || value != (int)(entry >>> 32)) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(int value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(int value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int valueIndex(float value) {
        if (this.isEmpty()) {
            return -1;
        }
        int val = Float.floatToIntBits(value);
        int index = -1;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            if ((int)entry == free || val != (int)(entry >>> 32)) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(float value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(float value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.containsValue(((Float)value).floatValue());
    }

    int insert(int key, int value) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != free) {
            if (cur == key) {
                return index;
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != free) {
                if (cur != key) continue;
                return index;
            }
        }
        this.incrementModCount();
        tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
        this.postInsertHook();
        return -1;
    }
}

