/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.DoubleCollection;
import com.koloboke.collect.DoubleCursor;
import com.koloboke.collect.DoubleIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.LongCollection;
import com.koloboke.collect.LongCursor;
import com.koloboke.collect.LongIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractDoubleValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonLongDoubleMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalDoubleCollectionOps;
import com.koloboke.collect.impl.InternalLongDoubleMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHashParallelKVLongDoubleMapSO;
import com.koloboke.collect.impl.hash.MutableParallelKVLongLHashGO;
import com.koloboke.collect.impl.hash.ParallelKVLongDoubleLHash;
import com.koloboke.collect.map.LongDoubleCursor;
import com.koloboke.collect.set.DoubleSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashLongSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.LongDoubleConsumer;
import com.koloboke.function.LongDoublePredicate;
import com.koloboke.function.LongDoubleToDoubleFunction;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableLHashParallelKVLongDoubleMapGO
extends MutableLHashParallelKVLongDoubleMapSO {
    final void copy(ParallelKVLongDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVLongDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    public boolean containsEntry(long key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == Double.doubleToLongBits(value);
        }
        return false;
    }

    public boolean containsEntry(long key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    public Double get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return null;
    }

    public double get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return this.defaultValue();
    }

    public Double getOrDefault(Object key, Double defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return defaultValue;
    }

    public double getOrDefault(long key, double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Long, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            action.accept((Long)key, (Double)Double.longBitsToDouble(tab[i + 1]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongDoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            action.accept(key, Double.longBitsToDouble(tab[i + 1]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongDoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free || predicate.test(key, Double.longBitsToDouble(tab[i + 1]))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public LongDoubleCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongDoubleMapOps.containsAllEntries((InternalLongDoubleMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalLongDoubleMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free || m.containsEntry(key, tab[i + 1])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalLongDoubleMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            m.justPut(key, tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Long, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            long val = tab[i + 1];
            hashCode += (int)(key ^ key >>> 32) ^ (int)(val ^ val >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(Double.longBitsToDouble(tab[i + 1]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacityMask = newTab.length - 2;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            int index = LHash.ParallelKVLongKeyMixing.mix((long)key) & capacityMask;
            if (newTab[index] != free) {
                while (newTab[index = index - 2 & capacityMask] != free) {
                }
            }
            newTab[index] = key;
            newTab[index + 1] = tab[i + 1];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Double put(Long key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        long[] tab = this.table;
        double prevValue = Double.longBitsToDouble(tab[index + 1]);
        tab[index + 1] = Double.doubleToLongBits(value);
        return prevValue;
    }

    public double put(long key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        long[] tab = this.table;
        double prevValue = Double.longBitsToDouble(tab[index + 1]);
        tab[index + 1] = Double.doubleToLongBits(value);
        return prevValue;
    }

    public Double putIfAbsent(Long key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        return Double.longBitsToDouble(this.table[index + 1]);
    }

    public double putIfAbsent(long key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Double.longBitsToDouble(this.table[index + 1]);
    }

    public void justPut(long key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return;
        }
        this.table[index + 1] = Double.doubleToLongBits(value);
    }

    public void justPut(long key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.table[index + 1] = value;
    }

    /*
     * Unable to fully structure code
     */
    public Double compute(Long key, BiFunction<? super Long, ? super Double, ? extends Double> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVLongKeyMixing.mix((long)k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl15
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                if ((newValue = remappingFunction.apply((Long)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = k;
                    tab[index + 1] = Double.doubleToLongBits(newValue);
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Long)k, (Double)Double.longBitsToDouble(tab[index + 1]))) != null) {
            tab[index + 1] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public double compute(long key, LongDoubleToDoubleFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVLongKeyMixing.mix((long)key) & capacityMask;
            cur = tab[index];
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl14
            while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                if (cur != free) continue;
lbl14:
                // 2 sources

                newValue = remappingFunction.applyAsDouble(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(tab[index + 1]));
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public Double computeIfAbsent(Long key, Function<? super Long, ? extends Double> mappingFunction) {
        Double value;
        long k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVLongKeyMixing.mix((long)k) & capacityMask;
        long cur = tab[index];
        if (cur == k) {
            return Double.longBitsToDouble(tab[index + 1]);
        }
        if (cur != free) {
            do {
                if ((cur = tab[index = index - 2 & capacityMask]) != k) continue;
                return Double.longBitsToDouble(tab[index + 1]);
            } while (cur != free);
        }
        if ((value = mappingFunction.apply((Long)k)) != null) {
            this.incrementModCount();
            tab[index] = k;
            tab[index + 1] = Double.doubleToLongBits(value);
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public double computeIfAbsent(long key, LongToDoubleFunction mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVLongKeyMixing.mix((long)key) & capacityMask;
        long cur = tab[index];
        if (cur == key) {
            return Double.longBitsToDouble(tab[index + 1]);
        }
        if (cur != free) {
            do {
                if ((cur = tab[index = index - 2 & capacityMask]) != key) continue;
                return Double.longBitsToDouble(tab[index + 1]);
            } while (cur != free);
        }
        double value = mappingFunction.applyAsDouble(key);
        this.incrementModCount();
        tab[index] = key;
        tab[index + 1] = Double.doubleToLongBits(value);
        this.postInsertHook();
        return value;
    }

    public Double computeIfPresent(Long key, BiFunction<? super Long, ? super Double, ? extends Double> remappingFunction) {
        long k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            Double newValue = remappingFunction.apply((Long)k, (Double)Double.longBitsToDouble(tab[index + 1]));
            if (newValue != null) {
                tab[index + 1] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public double computeIfPresent(long key, LongDoubleToDoubleFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            double newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(tab[index + 1]));
            tab[index + 1] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    public Double merge(Long key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        block5: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVLongKeyMixing.mix((long)k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl17
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != free) continue;
lbl17:
                // 2 sources

                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(tab[index + 1]), value)) != null) {
            tab[index + 1] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public double merge(long key, double value, DoubleBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVLongKeyMixing.mix((long)key) & capacityMask;
            cur = tab[index];
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl14
            while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                if (cur != free) continue;
lbl14:
                // 2 sources

                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(tab[index + 1]), value);
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public double addValue(long key, double value) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVLongKeyMixing.mix((long)key) & capacityMask;
            cur = tab[index];
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl12
            while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                if (cur != free) continue;
lbl12:
                // 2 sources

                newValue = this.defaultValue() + value;
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = Double.longBitsToDouble(tab[index + 1]) + value;
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public double addValue(long key, double addition, double initialValue) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVLongKeyMixing.mix((long)key) & capacityMask;
            cur = tab[index];
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl12
            while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                if (cur != free) continue;
lbl12:
                // 2 sources

                newValue = initialValue + addition;
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = Double.longBitsToDouble(tab[index + 1]) + addition;
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Long, ? extends Double> m) {
        CommonLongDoubleMapOps.putAll((InternalLongDoubleMapOps)this, m);
    }

    public Double replace(Long key, Double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            double oldValue = Double.longBitsToDouble(tab[index + 1]);
            tab[index + 1] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return null;
    }

    public double replace(long key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            double oldValue = Double.longBitsToDouble(tab[index + 1]);
            tab[index + 1] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Long key, Double oldValue, Double newValue) {
        return this.replace((long)key, (double)oldValue, (double)newValue);
    }

    public boolean replace(long key, double oldValue, double newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            if (tab[index + 1] == Double.doubleToLongBits(oldValue)) {
                tab[index + 1] = Double.doubleToLongBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Long, ? super Double, ? extends Double> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            tab[i + 1] = Double.doubleToLongBits(function.apply((Long)key, (Double)Double.longBitsToDouble(tab[i + 1])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(LongDoubleToDoubleFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            tab[i + 1] = Double.doubleToLongBits(function.applyAsDouble(key, Double.longBitsToDouble(tab[i + 1])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        long keyToShift;
        int indexToRemove;
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 2;
        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
            if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = keyToShift;
                tab[indexToRemove + 1] = tab[indexToShift + 1];
                indexToRemove = indexToShift;
                shiftDistance = 2;
                continue;
            }
            shiftDistance += 2;
            if (indexToShift != 2 + index) continue;
            throw new ConcurrentModificationException();
        }
        tab[indexToRemove] = free;
        this.postRemoveHook();
    }

    public Double remove(Object key) {
        long free;
        long k = (Long)key;
        if (k != (free = this.freeValue)) {
            long keyToShift;
            int indexToRemove;
            long[] tab = this.table;
            int capacityMask = tab.length - 2;
            int index = LHash.ParallelKVLongKeyMixing.mix((long)k) & capacityMask;
            long cur = tab[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            double val = Double.longBitsToDouble(tab[index + 1]);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 2;
            while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = keyToShift;
                    tab[indexToRemove + 1] = tab[indexToShift + 1];
                    indexToRemove = indexToShift;
                    shiftDistance = 2;
                    continue;
                }
                shiftDistance += 2;
                if (indexToShift != 2 + index) continue;
                throw new ConcurrentModificationException();
            }
            tab[indexToRemove] = free;
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(long key) {
        long free = this.freeValue;
        if (key != free) {
            long keyToShift;
            int indexToRemove;
            long[] tab = this.table;
            int capacityMask = tab.length - 2;
            int index = LHash.ParallelKVLongKeyMixing.mix((long)key) & capacityMask;
            long cur = tab[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 2;
            while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = keyToShift;
                    tab[indexToRemove + 1] = tab[indexToShift + 1];
                    indexToRemove = indexToShift;
                    shiftDistance = 2;
                    continue;
                }
                shiftDistance += 2;
                if (indexToShift != 2 + index) continue;
                throw new ConcurrentModificationException();
            }
            tab[indexToRemove] = free;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public double remove(long key) {
        long free = this.freeValue;
        if (key != free) {
            long keyToShift;
            int indexToRemove;
            long[] tab = this.table;
            int capacityMask = tab.length - 2;
            int index = LHash.ParallelKVLongKeyMixing.mix((long)key) & capacityMask;
            long cur = tab[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            double val = Double.longBitsToDouble(tab[index + 1]);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 2;
            while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = keyToShift;
                    tab[indexToRemove + 1] = tab[indexToShift + 1];
                    indexToRemove = indexToShift;
                    shiftDistance = 2;
                    continue;
                }
                shiftDistance += 2;
                if (indexToShift != 2 + index) continue;
                throw new ConcurrentModificationException();
            }
            tab[indexToRemove] = free;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, (Double)value);
    }

    public boolean remove(long key, double value) {
        long free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 2;
            int index = LHash.ParallelKVLongKeyMixing.mix((long)key) & capacityMask;
            long cur = tab[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = tab[index = index - 2 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if (tab[index + 1] == Double.doubleToLongBits(value)) {
                long keyToShift;
                int indexToRemove;
                this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = free;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(LongDoublePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !filter.test(key, Double.longBitsToDouble(tab[i + 1]))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Long> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !filter.test((Long)key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(LongPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.retainAll(thisC, (LongCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block13: {
                long key = tab[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block12: {
                long key = tab[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved, long delayedRemoved) {
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        for (int i = firstDelayedRemoved; i >= 0; i -= 2) {
            long keyToShift;
            int indexToRemove;
            if (tab[i] != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 2;
            while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                if (keyToShift != delayedRemoved && (LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = keyToShift;
                    tab[indexToRemove + 1] = tab[indexToShift + 1];
                    indexToRemove = indexToShift;
                    shiftDistance = 2;
                    continue;
                }
                shiftDistance += 2;
                if (indexToShift != 2 + i) continue;
                throw new ConcurrentModificationException();
            }
            tab[indexToRemove] = free;
            this.postRemoveHook();
        }
    }

    @Override
    public LongIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public LongCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements LongDoubleCursor {
        long[] tab;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue);
        }

        public void forEachForward(LongDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(key, Double.longBitsToDouble(tab[i + 1]));
            }
            if (index != this.index || mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(double value) {
            if (this.curKey == this.free) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.tab[this.index + 1] = Double.doubleToLongBits(value);
            if (this.tab == MutableLHashParallelKVLongDoubleMapGO.this.table) return;
            MutableLHashParallelKVLongDoubleMapGO.this.table[this.index + 1] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = free;
                MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongDoubleMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        long[] tab;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue);
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (index != this.index || mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public double elem() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = free;
                MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongDoubleMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        long[] tab;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        double next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            this.capacityMask = tab.length - 2;
            long free = this.free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] == free) continue;
                this.next = Double.longBitsToDouble(tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            if (this.expectedModCount == MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    long free = this.free;
                    double prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        if (tab[nextI] == free) continue;
                        this.next = Double.longBitsToDouble(tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != this.free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = Double.longBitsToDouble(tab[indexToShift + 1]);
                                }
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = this.free;
                MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongDoubleMapGO.this.justRemove(tab[index]);
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Double>> {
        long[] tab;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Double>)((Object)new MutableEntry2(mc, i, key, tab[i + 1])));
            }
            if (index != this.index || mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Double> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = free;
                MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongDoubleMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, long key, long value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(long newValue) {
                if (NoRemovedEntryCursor.this.tab == MutableLHashParallelKVLongDoubleMapGO.this.table) {
                    NoRemovedEntryCursor.this.tab[NoRemovedEntryCursor.this.index + 1] = newValue;
                } else {
                    MutableLHashParallelKVLongDoubleMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Double>> {
        long[] tab;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            this.capacityMask = tab.length - 2;
            long free = this.free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key == free) continue;
                this.next = new MutableEntry2(mc, nextI, key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Double>)((Object)new MutableEntry2(mc, i, key, tab[i + 1])));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Double> next() {
            int mc = this.expectedModCount;
            if (mc == MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    long free = this.free;
                    MutableEntry prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry2(mc, nextI, key, tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != this.free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = new MutableEntry2(MutableLHashParallelKVLongDoubleMapGO.this.modCount(), indexToShift, keyToShift, tab[indexToShift + 1]);
                                }
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = this.free;
                MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongDoubleMapGO.this.justRemove(tab[index]);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, long key, long value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(long newValue) {
                if (NoRemovedEntryIterator.this.tab == MutableLHashParallelKVLongDoubleMapGO.this.table) {
                    NoRemovedEntryIterator.this.tab[NoRemovedEntryIterator.this.index + 1] = newValue;
                } else {
                    MutableLHashParallelKVLongDoubleMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        public int size() {
            return MutableLHashParallelKVLongDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashParallelKVLongDoubleMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableLHashParallelKVLongDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return MutableLHashParallelKVLongDoubleMapGO.this.containsValue(v);
        }

        public boolean contains(long bits) {
            return MutableLHashParallelKVLongDoubleMapGO.this.containsValue(bits);
        }

        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free || predicate.test(Double.longBitsToDouble(tab[i + 1]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free || c.contains(tab[i + 1])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                changed |= c.add(Double.longBitsToDouble(tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                changed |= c.add(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                changed |= s.removeDouble(Double.longBitsToDouble(tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                changed |= s.removeDouble(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public DoubleCursor cursor() {
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                result[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                a[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                result[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                a[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                sb.append(' ').append(Double.longBitsToDouble(tab[i + 1])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return MutableLHashParallelKVLongDoubleMapGO.this.removeValue(v);
        }

        public boolean removeDouble(long bits) {
            return MutableLHashParallelKVLongDoubleMapGO.this.removeValue(bits);
        }

        public void clear() {
            MutableLHashParallelKVLongDoubleMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Double> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    long key = tab[i];
                    if (key == free || !filter.test((Double)Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    tab[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                        MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(DoublePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    long key = tab[i];
                    if (key == free || !filter.test(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    tab[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                        MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.removeAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    long key = tab[i];
                    if (key == free || !c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    tab[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                        MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.removeAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    long key = tab[i];
                    if (key == free || !c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    tab[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                        MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    long key = tab[i];
                    if (key == free || !c.contains(tab[i + 1])) continue;
                    MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    tab[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                        MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.retainAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block13: {
                    long key = tab[i];
                    if (key == free || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    tab[indexToRemove] = key;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                        MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.retainAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block13: {
                    long key = tab[i];
                    if (key == free || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    tab[indexToRemove] = key;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                        MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    long key = tab[i];
                    if (key == free || c.contains(tab[i + 1])) continue;
                    MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    tab[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                        MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends LongDoubleEntry {
        private long key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends LongDoubleEntry {
        final int modCount;
        private final int index;
        final long key;
        private long value;

        MutableEntry(int modCount, int index, long key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        public Double setValue(Double newValue) {
            long unwrappedNewValue;
            if (this.modCount != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            double oldValue = Double.longBitsToDouble(this.value);
            this.value = unwrappedNewValue = Double.doubleToLongBits(newValue);
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            MutableLHashParallelKVLongDoubleMapGO.this.table[this.index + 1] = newValue;
        }
    }

    abstract class LongDoubleEntry
    extends AbstractEntry<Long, Double> {
        LongDoubleEntry() {
        }

        abstract long key();

        public final Long getKey() {
            return this.key();
        }

        abstract long value();

        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((long)this.key()) ^ Primitives.hashCode((long)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, Double>>
    implements HashObjSet<Map.Entry<Long, Double>>,
    InternalObjCollectionOps<Map.Entry<Long, Double>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Long, Double>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashParallelKVLongDoubleMapGO.this.hashConfig();
        }

        public int size() {
            return MutableLHashParallelKVLongDoubleMapGO.this.size;
        }

        public double currentLoad() {
            return MutableLHashParallelKVLongDoubleMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashParallelKVLongDoubleMapGO.this.containsEntry((long)((Long)e.getKey()), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])));
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || predicate.test((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Long, Double>> iterator() {
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, Double>> cursor() {
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableLHashParallelKVLongDoubleMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Double.longBitsToDouble(tab[i + 1]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashParallelKVLongDoubleMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                double value = (Double)e.getValue();
                return MutableLHashParallelKVLongDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, Double>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    long key = tab[i];
                    if (key == free || !filter.test((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])))) continue;
                    MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    tab[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                        MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block13: {
                    long key = tab[i];
                    if (key == free || !c.contains((Object)e.with(key, tab[i + 1]))) continue;
                    MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    tab[indexToRemove] = key;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                        MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableLHashParallelKVLongDoubleMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVLongDoubleMapGO.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    long key = tab[i];
                    if (key == free || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                    MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                            if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    tab[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = keyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                            if (indexToShift != 2 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        tab[indexToRemove] = free;
                        MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    } else {
                        tab[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVLongDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableLHashParallelKVLongDoubleMapGO.this.doClear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableParallelKVLongLHashGO.NoRemovedCursor {
        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashParallelKVLongDoubleMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = free;
                MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongDoubleMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableParallelKVLongLHashGO.NoRemovedIterator {
        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashParallelKVLongDoubleMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVLongDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVLongDoubleMapGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVLongDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != this.free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = this.free;
                MutableLHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVLongDoubleMapGO.this.justRemove(tab[index]);
            }
        }
    }
}

