/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.InternalLongCharMapOps;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHashSeparateKVLongKeyMap;
import com.koloboke.collect.impl.hash.SeparateKVLongCharLHash;
import com.koloboke.collect.map.hash.HashLongCharMap;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;

public abstract class MutableLHashSeparateKVLongCharMapSO
extends MutableLHashSeparateKVLongKeyMap
implements HashLongCharMap,
InternalLongCharMapOps,
SeparateKVLongCharLHash {
    char[] values;

    void copy(SeparateKVLongCharLHash hash) {
        super.copy(hash);
        this.values = (char[])hash.valueArray().clone();
    }

    void move(SeparateKVLongCharLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public char[] valueArray() {
        return this.values;
    }

    int valueIndex(char value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(char value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(char value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.containsValue(((Character)value).charValue());
    }

    int insert(long key, char value) {
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVLongKeyMixing.mix((long)key) & capacityMask;
        long cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return index;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != free) {
                if (cur != key) continue;
                return index;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new char[capacity];
    }
}

