/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.DoubleCollection;
import com.koloboke.collect.DoubleCursor;
import com.koloboke.collect.DoubleIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractDoubleValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.CommonObjDoubleMapOps;
import com.koloboke.collect.impl.InternalDoubleCollectionOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.InternalObjDoubleMapOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHashSeparateKVObjDoubleMapSO;
import com.koloboke.collect.impl.hash.MutableSeparateKVObjLHashGO;
import com.koloboke.collect.impl.hash.ObjHash;
import com.koloboke.collect.impl.hash.SeparateKVObjDoubleLHash;
import com.koloboke.collect.map.ObjDoubleCursor;
import com.koloboke.collect.set.DoubleSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ObjDoublePredicate;
import com.koloboke.function.ObjDoubleToDoubleFunction;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nonnull;

public class MutableLHashSeparateKVObjDoubleMapGO<K>
extends MutableLHashSeparateKVObjDoubleMapSO<K> {
    @Override
    final void copy(SeparateKVObjDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    public boolean containsEntry(Object key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Double.doubleToLongBits(value);
        }
        return false;
    }

    public boolean containsEntry(Object key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Double get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return null;
    }

    public double getDouble(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return this.defaultValue();
    }

    public Double getOrDefault(Object key, Double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    public double getOrDefault(Object key, double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super K, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, Double.longBitsToDouble(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void forEach(ObjDoubleConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, Double.longBitsToDouble(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean forEachWhile(ObjDoublePredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || predicate.test(key, Double.longBitsToDouble(vals[i]))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ObjDoubleCursor<K> cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjDoubleMapOps.containsAllEntries((InternalObjDoubleMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalObjDoubleMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalObjDoubleMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<K, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            long val = vals[i];
            hashCode += this.nullableKeyHashCode(key) ^ (int)(val ^ val >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            sb.append(Double.longBitsToDouble(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        Object[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        long[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            int index = LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(key)) & capacityMask;
            if (newKeys[index] != FREE) {
                while (newKeys[index = index - 1 & capacityMask] != FREE) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Double put(K key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        long[] vals = this.values;
        double prevValue = Double.longBitsToDouble(vals[index]);
        vals[index] = Double.doubleToLongBits(value);
        return prevValue;
    }

    public double put(K key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        long[] vals = this.values;
        double prevValue = Double.longBitsToDouble(vals[index]);
        vals[index] = Double.doubleToLongBits(value);
        return prevValue;
    }

    public Double putIfAbsent(K key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        return Double.longBitsToDouble(this.values[index]);
    }

    public double putIfAbsent(K key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Double.longBitsToDouble(this.values[index]);
    }

    public void justPut(K key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return;
        }
        this.values[index] = Double.doubleToLongBits(value);
    }

    public void justPut(K key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Exception decompiling
     */
    public Double compute(K key, BiFunction<? super K, ? super Double, ? extends Double> remappingFunction) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    Double computeNullKey(BiFunction<? super K, ? super Double, ? extends Double> remappingFunction) {
        block4: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            index = 0;
            cur = keys[0];
            if (cur == null) break block4;
            if (cur == MutableLHashSeparateKVObjDoubleMapGO.FREE) ** GOTO lbl12
            capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != MutableLHashSeparateKVObjDoubleMapGO.FREE) continue;
lbl12:
                // 2 sources

                if ((newValue = remappingFunction.apply(null, null)) != null) {
                    this.incrementModCount();
                    keys[index] = null;
                    vals[index] = Double.doubleToLongBits(newValue);
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(null, Double.longBitsToDouble(vals[index]))) != null) {
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Exception decompiling
     */
    public double compute(K key, ObjDoubleToDoubleFunction<? super K> remappingFunction) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    double computeNullKey(ObjDoubleToDoubleFunction<? super K> remappingFunction) {
        block2: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            index = 0;
            cur = keys[0];
            if (cur == null) break block2;
            if (cur == MutableLHashSeparateKVObjDoubleMapGO.FREE) ** GOTO lbl12
            capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != MutableLHashSeparateKVObjDoubleMapGO.FREE) continue;
lbl12:
                // 2 sources

                newValue = remappingFunction.applyAsDouble(null, this.defaultValue());
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsDouble(null, Double.longBitsToDouble(vals[index]));
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public Double computeIfAbsent(K key, Function<? super K, ? extends Double> mappingFunction) {
        if (key != null) {
            Double value;
            block8: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                Object[] keys = this.set;
                long[] vals = this.values;
                int capacityMask = keys.length - 1;
                int index = LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) & capacityMask;
                Object cur = keys[index];
                if (cur == key) {
                    return Double.longBitsToDouble(vals[index]);
                }
                if (cur != FREE) {
                    if (this.keyEquals(key, cur)) {
                        return Double.longBitsToDouble(vals[index]);
                    }
                    do {
                        if ((cur = keys[index = index - 1 & capacityMask]) == key) {
                            return Double.longBitsToDouble(vals[index]);
                        }
                        if (cur == FREE) break block8;
                    } while (!this.keyEquals(key, cur));
                    return Double.longBitsToDouble(vals[index]);
                }
            }
            if ((value = mappingFunction.apply(key)) != null) {
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
            return null;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    Double computeIfAbsentNullKey(Function<? super K, ? extends Double> mappingFunction) {
        Double value;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Object[] keys = this.set;
        long[] vals = this.values;
        int index = 0;
        Object cur = keys[0];
        if (cur == null) {
            return Double.longBitsToDouble(vals[index]);
        }
        if (cur != FREE) {
            int capacityMask = keys.length - 1;
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != null) continue;
                return Double.longBitsToDouble(vals[index]);
            } while (cur != FREE);
        }
        if ((value = mappingFunction.apply(null)) != null) {
            this.incrementModCount();
            keys[index] = null;
            vals[index] = Double.doubleToLongBits(value);
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public double computeIfAbsent(K key, ToDoubleFunction<? super K> mappingFunction) {
        if (key != null) {
            block7: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                Object[] keys = this.set;
                long[] vals = this.values;
                int capacityMask = keys.length - 1;
                int index = LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) & capacityMask;
                Object cur = keys[index];
                if (cur == key) {
                    return Double.longBitsToDouble(vals[index]);
                }
                if (cur != FREE) {
                    if (this.keyEquals(key, cur)) {
                        return Double.longBitsToDouble(vals[index]);
                    }
                    do {
                        if ((cur = keys[index = index - 1 & capacityMask]) == key) {
                            return Double.longBitsToDouble(vals[index]);
                        }
                        if (cur == FREE) break block7;
                    } while (!this.keyEquals(key, cur));
                    return Double.longBitsToDouble(vals[index]);
                }
            }
            double value = mappingFunction.applyAsDouble(key);
            this.incrementModCount();
            keys[index] = key;
            vals[index] = Double.doubleToLongBits(value);
            this.postInsertHook();
            return value;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    double computeIfAbsentNullKey(ToDoubleFunction<? super K> mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Object[] keys = this.set;
        long[] vals = this.values;
        int index = 0;
        Object cur = keys[0];
        if (cur == null) {
            return Double.longBitsToDouble(vals[index]);
        }
        if (cur != FREE) {
            int capacityMask = keys.length - 1;
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != null) continue;
                return Double.longBitsToDouble(vals[index]);
            } while (cur != FREE);
        }
        double value = mappingFunction.applyAsDouble(null);
        this.incrementModCount();
        keys[index] = null;
        vals[index] = Double.doubleToLongBits(value);
        this.postInsertHook();
        return value;
    }

    public Double computeIfPresent(K key, BiFunction<? super K, ? super Double, ? extends Double> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            Double newValue = remappingFunction.apply(key, Double.longBitsToDouble(vals[index]));
            if (newValue != null) {
                vals[index] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public double computeIfPresent(K key, ObjDoubleToDoubleFunction<? super K> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(vals[index]));
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Exception decompiling
     */
    public Double merge(K key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    Double mergeNullKey(Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        block4: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            index = 0;
            cur = keys[0];
            if (cur == null) break block4;
            if (cur == MutableLHashSeparateKVObjDoubleMapGO.FREE) ** GOTO lbl14
            capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != MutableLHashSeparateKVObjDoubleMapGO.FREE) continue;
lbl14:
                // 2 sources

                this.incrementModCount();
                keys[index] = null;
                vals[index] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(vals[index]), value)) != null) {
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Exception decompiling
     */
    public double merge(K key, double value, DoubleBinaryOperator remappingFunction) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    double mergeNullKey(double value, DoubleBinaryOperator remappingFunction) {
        block2: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            index = 0;
            cur = keys[0];
            if (cur == null) break block2;
            if (cur == MutableLHashSeparateKVObjDoubleMapGO.FREE) ** GOTO lbl12
            capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != MutableLHashSeparateKVObjDoubleMapGO.FREE) continue;
lbl12:
                // 2 sources

                this.incrementModCount();
                keys[index] = null;
                vals[index] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(vals[index]), value);
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    /*
     * Exception decompiling
     */
    public double addValue(K key, double value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    double addValueNullKey(double value) {
        block1: {
            keys = this.set;
            vals = this.values;
            index = 0;
            cur = keys[0];
            if (cur == null) break block1;
            if (cur == MutableLHashSeparateKVObjDoubleMapGO.FREE) ** GOTO lbl10
            capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != MutableLHashSeparateKVObjDoubleMapGO.FREE) continue;
lbl10:
                // 2 sources

                newValue = this.defaultValue() + value;
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = Double.longBitsToDouble(vals[index]) + value;
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    /*
     * Exception decompiling
     */
    public double addValue(K key, double addition, double initialValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    double addValueWithInitialNullKey(double addition, double initialValue) {
        block1: {
            keys = this.set;
            vals = this.values;
            index = 0;
            cur = keys[0];
            if (cur == null) break block1;
            if (cur == MutableLHashSeparateKVObjDoubleMapGO.FREE) ** GOTO lbl10
            capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != MutableLHashSeparateKVObjDoubleMapGO.FREE) continue;
lbl10:
                // 2 sources

                newValue = initialValue + addition;
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = Double.longBitsToDouble(vals[index]) + addition;
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends K, ? extends Double> m) {
        CommonObjDoubleMapOps.putAll((InternalObjDoubleMapOps)this, m);
    }

    public Double replace(K key, Double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double oldValue = Double.longBitsToDouble(vals[index]);
            vals[index] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return null;
    }

    public double replace(K key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double oldValue = Double.longBitsToDouble(vals[index]);
            vals[index] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(K key, Double oldValue, Double newValue) {
        return this.replace(key, (double)oldValue, (double)newValue);
    }

    public boolean replace(K key, double oldValue, double newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            if (vals[index] == Double.doubleToLongBits(oldValue)) {
                vals[index] = Double.doubleToLongBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super K, ? super Double, ? extends Double> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            vals[i] = Double.doubleToLongBits(function.apply(key, Double.longBitsToDouble(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ObjDoubleToDoubleFunction<? super K> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            vals[i] = Double.doubleToLongBits(function.applyAsDouble(key, Double.longBitsToDouble(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        Object keyToShift;
        int indexToRemove;
        Object[] keys = this.set;
        long[] vals = this.values;
        int capacityMask = keys.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
            Object castedKeyToShift = keyToShift;
            if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = castedKeyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
        }
        keys[indexToRemove] = FREE;
        this.postRemoveHook();
    }

    public Double remove(Object key) {
        if (key != null) {
            Object keyToShift;
            int indexToRemove;
            Object k = key;
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) & capacityMask;
            Object cur = keys[index];
            if (cur != k) {
                if (cur == FREE) {
                    return null;
                }
                if (!this.keyEquals(k, cur)) {
                    while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                        if (cur == FREE) {
                            return null;
                        }
                        if (!this.keyEquals(k, cur)) continue;
                    }
                }
            }
            long[] vals = this.values;
            double val = Double.longBitsToDouble(vals[index]);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                Object castedKeyToShift = keyToShift;
                if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = castedKeyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
            }
            keys[indexToRemove] = FREE;
            this.postRemoveHook();
            return val;
        }
        return this.removeNullKey();
    }

    Double removeNullKey() {
        Object keyToShift;
        int indexToRemove;
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return null;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != FREE) continue;
                return null;
            }
        }
        long[] vals = this.values;
        double val = Double.longBitsToDouble(vals[index]);
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
            Object castedKeyToShift = keyToShift;
            if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = castedKeyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
        }
        keys[indexToRemove] = FREE;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean justRemove(Object key) {
        if (key != null) {
            Object keyToShift;
            int indexToRemove;
            Object k = key;
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) & capacityMask;
            Object cur = keys[index];
            if (cur != k) {
                if (cur == FREE) {
                    return false;
                }
                if (!this.keyEquals(k, cur)) {
                    while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                        if (cur == FREE) {
                            return false;
                        }
                        if (!this.keyEquals(k, cur)) continue;
                    }
                }
            }
            long[] vals = this.values;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                Object castedKeyToShift = keyToShift;
                if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = castedKeyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
            }
            keys[indexToRemove] = FREE;
            this.postRemoveHook();
            return true;
        }
        return this.justRemoveNullKey();
    }

    boolean justRemoveNullKey() {
        Object keyToShift;
        int indexToRemove;
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != FREE) continue;
                return false;
            }
        }
        long[] vals = this.values;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
            Object castedKeyToShift = keyToShift;
            if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = castedKeyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
        }
        keys[indexToRemove] = FREE;
        this.postRemoveHook();
        return true;
    }

    public double removeAsDouble(Object key) {
        if (key != null) {
            Object keyToShift;
            int indexToRemove;
            Object k = key;
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) & capacityMask;
            Object cur = keys[index];
            if (cur != k) {
                if (cur == FREE) {
                    return this.defaultValue();
                }
                if (!this.keyEquals(k, cur)) {
                    while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                        if (cur == FREE) {
                            return this.defaultValue();
                        }
                        if (!this.keyEquals(k, cur)) continue;
                    }
                }
            }
            long[] vals = this.values;
            double val = Double.longBitsToDouble(vals[index]);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                Object castedKeyToShift = keyToShift;
                if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = castedKeyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
            }
            keys[indexToRemove] = FREE;
            this.postRemoveHook();
            return val;
        }
        return this.removeAsDoubleNullKey();
    }

    double removeAsDoubleNullKey() {
        Object keyToShift;
        int indexToRemove;
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return this.defaultValue();
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != FREE) continue;
                return this.defaultValue();
            }
        }
        long[] vals = this.values;
        double val = Double.longBitsToDouble(vals[index]);
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
            Object castedKeyToShift = keyToShift;
            if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = castedKeyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
        }
        keys[indexToRemove] = FREE;
        this.postRemoveHook();
        return val;
    }

    public boolean remove(Object key, Object value) {
        return this.remove(key, (Double)value);
    }

    public boolean remove(Object key, double value) {
        if (key != null) {
            long[] vals;
            Object k = key;
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) & capacityMask;
            Object cur = keys[index];
            if (cur != k) {
                if (cur == FREE) {
                    return false;
                }
                if (!this.keyEquals(k, cur)) {
                    while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                        if (cur == FREE) {
                            return false;
                        }
                        if (!this.keyEquals(k, cur)) continue;
                    }
                }
            }
            if ((vals = this.values)[index] == Double.doubleToLongBits(value)) {
                Object keyToShift;
                int indexToRemove;
                this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        keys[indexToRemove] = castedKeyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = FREE;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return this.removeEntryNullKey(value);
    }

    boolean removeEntryNullKey(double value) {
        long[] vals;
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != FREE) continue;
                return false;
            }
        }
        if ((vals = this.values)[index] == Double.doubleToLongBits(value)) {
            Object keyToShift;
            int indexToRemove;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                Object castedKeyToShift = keyToShift;
                if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = castedKeyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
            }
            keys[indexToRemove] = FREE;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(ObjDoublePredicate<? super K> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                Object key = keys[i];
                if (key == FREE || !filter.test(key, Double.longBitsToDouble(vals[i]))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                        Object castedKeyToShift = keyToShift;
                        if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = REMOVED;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = castedKeyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                    }
                    keys[indexToRemove] = FREE;
                    this.postRemoveHook();
                } else {
                    keys[i] = REMOVED;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super K> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                Object key = keys[i];
                if (key == FREE || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                        Object castedKeyToShift = keyToShift;
                        if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = REMOVED;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = castedKeyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                    }
                    keys[indexToRemove] = FREE;
                    this.postRemoveHook();
                } else {
                    keys[i] = REMOVED;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashObjSet<K> thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                Object key = keys[i];
                if (key == FREE || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                        Object castedKeyToShift = keyToShift;
                        if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = REMOVED;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = castedKeyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                    }
                    keys[indexToRemove] = FREE;
                    this.postRemoveHook();
                } else {
                    keys[i] = REMOVED;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashObjSet<K> thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                Object key = keys[i];
                if (key == FREE || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                        Object castedKeyToShift = keyToShift;
                        if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = REMOVED;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = castedKeyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                    }
                    keys[indexToRemove] = FREE;
                    this.postRemoveHook();
                } else {
                    keys[i] = REMOVED;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved) {
        Object[] keys = this.set;
        long[] vals = this.values;
        int capacityMask = keys.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            Object keyToShift;
            int indexToRemove;
            if (keys[i] != REMOVED) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                Object castedKeyToShift = keyToShift;
                if (keyToShift != REMOVED && (LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = castedKeyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
            }
            keys[indexToRemove] = FREE;
            this.postRemoveHook();
        }
    }

    @Override
    public ObjIterator<K> iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public ObjCursor<K> setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements ObjDoubleCursor<K> {
        Object[] keys;
        long[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjDoubleConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != ObjHash.FREE) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(double value) {
            if (this.curKey == ObjHash.FREE) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.vals[this.index] = Double.doubleToLongBits(value);
            if (this.vals == MutableLHashSeparateKVObjDoubleMapGO.this.values) return;
            MutableLHashSeparateKVObjDoubleMapGO.this.values[this.index] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == ObjHash.FREE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = ObjHash.FREE;
            int index = this.index;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjDoubleMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = ObjHash.FREE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = castedKeyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjDoubleMapGO.this.justRemove(curKey);
                keys[index] = null;
            }
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        Object[] keys;
        long[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public double elem() {
            if (this.curKey != ObjHash.FREE) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == ObjHash.FREE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = ObjHash.FREE;
            int index = this.index;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjDoubleMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = ObjHash.FREE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = castedKeyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjDoubleMapGO.this.justRemove(curKey);
                keys[index] = null;
            }
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        Object[] keys;
        long[] vals;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        double next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = Double.longBitsToDouble(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            if (this.expectedModCount == MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] keys = this.keys;
                    double prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == ObjHash.FREE) continue;
                        this.next = Double.longBitsToDouble(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjDoubleMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = ObjHash.FREE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = Double.longBitsToDouble(vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = castedKeyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjDoubleMapGO.this.justRemove(keys[index]);
                keys[index] = null;
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Double>> {
        Object[] keys;
        long[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new MutableEntry2(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Double> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == ObjHash.FREE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = ObjHash.FREE;
            int index = this.index;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjDoubleMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = ObjHash.FREE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = castedKeyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjDoubleMapGO.this.justRemove(curKey);
                keys[index] = null;
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, K key, long value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(long newValue) {
                if (NoRemovedEntryCursor.this.vals == MutableLHashSeparateKVObjDoubleMapGO.this.values) {
                    NoRemovedEntryCursor.this.vals[NoRemovedEntryCursor.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVObjDoubleMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Double>> {
        Object[] keys;
        long[] vals;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new MutableEntry2(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new MutableEntry2(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Double> next() {
            int mc = this.expectedModCount;
            if (mc == MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = new MutableEntry2(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjDoubleMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = ObjHash.FREE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashSeparateKVObjDoubleMapGO.this.modCount(), indexToShift, castedKeyToShift, vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = castedKeyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjDoubleMapGO.this.justRemove(keys[index]);
                keys[index] = null;
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, K key, long value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(long newValue) {
                if (NoRemovedEntryIterator.this.vals == MutableLHashSeparateKVObjDoubleMapGO.this.values) {
                    NoRemovedEntryIterator.this.vals[NoRemovedEntryIterator.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVObjDoubleMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        public int size() {
            return MutableLHashSeparateKVObjDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVObjDoubleMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableLHashSeparateKVObjDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return MutableLHashSeparateKVObjDoubleMapGO.this.containsValue(v);
        }

        public boolean contains(long bits) {
            return MutableLHashSeparateKVObjDoubleMapGO.this.containsValue(bits);
        }

        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || predicate.test(Double.longBitsToDouble(vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(Double.longBitsToDouble(vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeDouble(Double.longBitsToDouble(vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeDouble(vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public DoubleCursor cursor() {
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                sb.append(' ').append(Double.longBitsToDouble(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return MutableLHashSeparateKVObjDoubleMapGO.this.removeValue(v);
        }

        public boolean removeDouble(long bits) {
            return MutableLHashSeparateKVObjDoubleMapGO.this.removeValue(bits);
        }

        public void clear() {
            MutableLHashSeparateKVObjDoubleMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Double> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] == ObjHash.FREE || !filter.test((Double)Double.longBitsToDouble(vals[i]))) continue;
                    MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = castedKeyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                        MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(DoublePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] == ObjHash.FREE || !filter.test(Double.longBitsToDouble(vals[i]))) continue;
                    MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = castedKeyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                        MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.removeAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    if (keys[i] == ObjHash.FREE || !c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = castedKeyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                        MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.removeAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    if (keys[i] == ObjHash.FREE || !c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = castedKeyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                        MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] == ObjHash.FREE || !c.contains(vals[i])) continue;
                    MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = castedKeyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                        MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.retainAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    if (keys[i] == ObjHash.FREE || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = castedKeyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                        MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.retainAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    if (keys[i] == ObjHash.FREE || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = castedKeyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                        MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                    MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = castedKeyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                        MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ObjDoubleEntry {
        private K key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ObjDoubleEntry {
        final int modCount;
        private final int index;
        final K key;
        private long value;

        MutableEntry(int modCount, int index, K key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        public Double setValue(Double newValue) {
            long unwrappedNewValue;
            if (this.modCount != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            double oldValue = Double.longBitsToDouble(this.value);
            this.value = unwrappedNewValue = Double.doubleToLongBits(newValue);
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            MutableLHashSeparateKVObjDoubleMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ObjDoubleEntry
    extends AbstractEntry<K, Double> {
        ObjDoubleEntry() {
        }

        abstract K key();

        public final K getKey() {
            return this.key();
        }

        abstract long value();

        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyEquals(k2, this.key()) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode((long)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Double>>
    implements HashObjSet<Map.Entry<K, Double>>,
    InternalObjCollectionOps<Map.Entry<K, Double>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<K, Double>> equivalence() {
            return Equivalence.entryEquivalence(MutableLHashSeparateKVObjDoubleMapGO.this.keyEquivalence(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashSeparateKVObjDoubleMapGO.this.hashConfig();
        }

        public int size() {
            return MutableLHashSeparateKVObjDoubleMapGO.this.size;
        }

        public double currentLoad() {
            return MutableLHashSeparateKVObjDoubleMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashSeparateKVObjDoubleMapGO.this.containsEntry(e.getKey(), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || predicate.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<K, Double>> iterator() {
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Double>> cursor() {
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableLHashSeparateKVObjDoubleMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Collection)");
                sb.append('=');
                sb.append(Double.longBitsToDouble(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVObjDoubleMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                double value = (Double)e.getValue();
                return MutableLHashSeparateKVObjDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Double>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || !filter.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = castedKeyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                        MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = castedKeyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                        MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long[] vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = castedKeyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                        MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableLHashSeparateKVObjDoubleMapGO.this.doClear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableSeparateKVObjLHashGO.NoRemovedCursor {
        long[] vals;

        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashSeparateKVObjDoubleMapGO.this, mc);
            this.vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == ObjHash.FREE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = ObjHash.FREE;
            int index = this.index;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjDoubleMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = ObjHash.FREE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = castedKeyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjDoubleMapGO.this.justRemove(curKey);
                keys[index] = null;
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableSeparateKVObjLHashGO.NoRemovedIterator {
        long[] vals;

        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashSeparateKVObjDoubleMapGO.this, mc);
            this.vals = MutableLHashSeparateKVObjDoubleMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            Object[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjDoubleMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableLHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = ObjHash.FREE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = castedKeyToShift;
                                }
                            }
                        }
                        keys[indexToRemove] = castedKeyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjDoubleMapGO.this.justRemove(keys[index]);
                keys[index] = null;
            }
        }
    }
}

