/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.LongCollection;
import com.koloboke.collect.LongCursor;
import com.koloboke.collect.LongIterator;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableParallelKVLongLHashSO;
import com.koloboke.collect.set.LongSet;
import com.koloboke.collect.set.hash.HashLongSet;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public abstract class MutableParallelKVLongLHashGO
extends MutableParallelKVLongLHashSO {
    @Override
    @Nonnull
    public long[] table() {
        return this.table;
    }

    @Override
    boolean doubleSizedArrays() {
        return true;
    }

    public int capacity() {
        return this.table.length >> 1;
    }

    public void forEach(Consumer<? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            action.accept((Long)key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            action.accept(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(LongCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(LongCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            changed |= c.add(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(LongSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            changed |= s.removeLong(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public LongIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedIterator(mc);
    }

    public LongCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public long[] toLongArray() {
        int size = this.size();
        long[] result = new long[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public long[] toArray(long[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new long[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0L;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0L;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            hashCode += (int)(key ^ key >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            sb.append(' ').append(key).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(long var1);

    public boolean removeIf(Predicate<? super Long> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !filter.test((Long)key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean removeIf(LongPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                long key = tab[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.retainAll(thisC, (LongCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block13: {
                long key = tab[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block12: {
                long key = tab[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                        if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                tab[indexToRemove] = key;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                        if (indexToShift != 2 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    tab[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    tab[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    void closeDelayedRemoved(int firstDelayedRemoved, long delayedRemoved) {
        long free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        for (int i = firstDelayedRemoved; i >= 0; i -= 2) {
            long keyToShift;
            int indexToRemove;
            if (tab[i] != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 2;
            while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                if (keyToShift != delayedRemoved && (LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = keyToShift;
                    indexToRemove = indexToShift;
                    shiftDistance = 2;
                    continue;
                }
                shiftDistance += 2;
                if (indexToShift != 2 + i) continue;
                throw new ConcurrentModificationException();
            }
            tab[indexToRemove] = free;
            this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements LongCursor {
        long[] tab;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;

        NoRemovedCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = MutableParallelKVLongLHashGO.this.table;
            long[] tab = MutableParallelKVLongLHashGO.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableParallelKVLongLHashGO.this.freeValue);
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVLongLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVLongLHashGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableParallelKVLongLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableParallelKVLongLHashGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableParallelKVLongLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = free;
                MutableParallelKVLongLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableParallelKVLongLHashGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedIterator
    implements LongIterator {
        long[] tab;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        long next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVLongLHashGO.this.table;
            long[] tab = MutableParallelKVLongLHashGO.this.table;
            this.capacityMask = tab.length - 2;
            long free = this.free = MutableParallelKVLongLHashGO.this.freeValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            if (this.expectedModCount == MutableParallelKVLongLHashGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    long free = this.free;
                    long prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key == free) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept((Long)key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVLongLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVLongLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableParallelKVLongLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableParallelKVLongLHashGO.this.table) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableParallelKVLongLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != this.free) {
                    if ((LHash.ParallelKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        tab[indexToRemove] = keyToShift;
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                    if (indexToShift != 2 + index) continue;
                    throw new ConcurrentModificationException();
                }
                tab[indexToRemove] = this.free;
                MutableParallelKVLongLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableParallelKVLongLHashGO.this.justRemove(tab[index]);
            }
        }
    }
}

